/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.robots.AIRobotRecharge;

public class AIRobotMain
extends AIRobot {
    private AIRobot overridingAI;

    public AIRobotMain(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public void preempt(AIRobot ai) {
        if (!(ai instanceof AIRobotRecharge)) {
            if ((double)this.robot.getEnergy() < 25000.0) {
                this.startDelegateAI(new AIRobotRecharge(this.robot));
            } else if (this.overridingAI != null && ai != this.overridingAI) {
                this.startDelegateAI(this.overridingAI);
            }
        }
    }

    @Override
    public void update() {
        RedstoneBoardRobot board = this.robot.getBoard();
        if (board != null) {
            this.startDelegateAI(board);
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai == this.overridingAI) {
            this.overridingAI = null;
        }
    }

    public void setOverridingAI(AIRobot ai) {
        if (this.overridingAI == null) {
            this.overridingAI = ai;
        }
    }

    public AIRobot getOverridingAI() {
        return this.overridingAI;
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }
}

