/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class AIRobotPumpBlock
extends AIRobot {
    public BlockIndex blockToPump;
    public long waited = 0L;
    int pumped = 0;

    public AIRobotPumpBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotPumpBlock(EntityRobotBase iRobot, BlockIndex iBlockToPump) {
        super(iRobot);
        this.blockToPump = iBlockToPump;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.blockToPump.x, this.blockToPump.y, this.blockToPump.z);
    }

    @Override
    public void update() {
        if (this.waited < 40L) {
            ++this.waited;
        } else {
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)this.robot.field_70170_p.func_147439_a(this.blockToPump.x, this.blockToPump.y, this.blockToPump.z));
            if (fluid != null) {
                this.pumped = this.robot.fill(ForgeDirection.UNKNOWN, new FluidStack(fluid, 1000), true);
                if (this.pumped > 0) {
                    this.robot.field_70170_p.func_147468_f(this.blockToPump.x, this.blockToPump.y, this.blockToPump.z);
                }
            }
            this.terminate();
        }
    }

    @Override
    public void end() {
        this.robot.aimItemAt(0, 1, 0);
    }

    @Override
    public int getEnergyCost() {
        return 20;
    }

    @Override
    public boolean success() {
        return this.pumped > 0;
    }
}

