/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.robots.AIRobotSearchAndGotoStation;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.IStationFilter;
import buildcraft.transport.PipeTransportPower;

public class AIRobotRecharge
extends AIRobot {
    private DockingStation axeDocking = null;

    public AIRobotRecharge(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public void start() {
        this.robot.getRegistry().releaseResources(this.robot);
        this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new IStationFilter(){

            @Override
            public boolean matches(DockingStation station) {
                return station.getPipe().getPipeType() == IPipeTile.PipeType.POWER;
            }
        }, null));
    }

    @Override
    public void update() {
        PipeTransportPower powerProvider = (PipeTransportPower)((DockingStation)this.robot.getDockingStation()).getPipe().pipe.transport;
        int amount = this.robot.getBattery().receiveEnergy(1000, false);
        powerProvider.requestEnergy(this.robot.getDockingStation().side(), amount);
        this.robot.getBattery().receiveEnergy(powerProvider.consumePower(this.robot.getDockingStation().side(), amount), false);
        if (this.robot.getEnergy() >= 100000) {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoStation && (this.robot.getDockingStation() == null || !(((DockingStation)this.robot.getDockingStation()).getPipe().pipe.transport instanceof PipeTransportPower))) {
            this.terminate();
        }
    }
}

