/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.builders.TileConstructionMarker;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotGotoSleep;
import buildcraft.core.robots.AIRobotGotoStationToLoad;
import buildcraft.core.robots.AIRobotLoad;
import buildcraft.core.robots.AIRobotRecharge;
import buildcraft.core.robots.boards.BoardRobotBuilderNBT;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BoardRobotBuilder
extends RedstoneBoardRobot {
    private TileConstructionMarker markerToBuild;
    private BuildingSlot currentBuildingSlot;
    private LinkedList<ItemStack> requirementsToLookFor;
    private int launchingDelay = 0;

    public BoardRobotBuilder(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotBuilderNBT.instance;
    }

    @Override
    public void update() {
        if (this.launchingDelay > 0) {
            --this.launchingDelay;
            return;
        }
        if (this.markerToBuild == null) {
            double minDistance = Double.MAX_VALUE;
            for (TileConstructionMarker marker : TileConstructionMarker.currentMarkers) {
                double dz;
                double dy;
                double dx;
                double distance;
                if (marker.getWorld() != this.robot.field_70170_p || !marker.needsToBuild() || !((distance = (dx = this.robot.field_70165_t - (double)marker.field_145851_c) * dx + (dy = this.robot.field_70163_u - (double)marker.field_145848_d) * dy + (dz = this.robot.field_70161_v - (double)marker.field_145849_e) * dz) < minDistance)) continue;
                this.markerToBuild = marker;
                minDistance = distance;
            }
            if (this.markerToBuild == null) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
                return;
            }
        }
        if (this.markerToBuild == null || !this.markerToBuild.needsToBuild()) {
            this.markerToBuild = null;
            this.startDelegateAI(new AIRobot(this.robot));
            return;
        }
        if (this.currentBuildingSlot == null) {
            this.currentBuildingSlot = this.markerToBuild.bluePrintBuilder.reserveNextSlot(this.robot.field_70170_p);
            if (this.currentBuildingSlot != null) {
                this.requirementsToLookFor = this.currentBuildingSlot.getRequirements(this.markerToBuild.getContext());
            }
        }
        if (this.requirementsToLookFor != null && this.requirementsToLookFor.size() > 0) {
            this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, new ArrayStackFilter(this.requirementsToLookFor.getFirst()), this.robot.getZoneToWork()));
        }
        if (this.currentBuildingSlot != null && this.requirementsToLookFor != null && this.requirementsToLookFor.size() == 0) {
            if (this.currentBuildingSlot.stackConsumed == null) {
                this.markerToBuild.bluePrintBuilder.useRequirements(this.robot, this.currentBuildingSlot);
            }
            if (this.robot.getEnergy() - this.currentBuildingSlot.getEnergyRequirement() < 25000) {
                this.startDelegateAI(new AIRobotRecharge(this.robot));
            } else {
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, (int)this.currentBuildingSlot.getDestination().x, (int)this.currentBuildingSlot.getDestination().y, (int)this.currentBuildingSlot.getDestination().z, 8.0));
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationToLoad) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotLoad(this.robot, new ArrayStackFilter(this.requirementsToLookFor.getFirst()), this.requirementsToLookFor.getFirst().field_77994_a));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotLoad) {
            this.requirementsToLookFor.removeFirst();
        } else if (ai instanceof AIRobotGotoBlock) {
            if (this.markerToBuild == null || this.markerToBuild.bluePrintBuilder == null) {
                return;
            }
            if (this.robot.getEnergy() - this.currentBuildingSlot.getEnergyRequirement() < 25000) {
                this.startDelegateAI(new AIRobotRecharge(this.robot));
                return;
            }
            this.robot.getBattery().extractEnergy(this.currentBuildingSlot.getEnergyRequirement(), false);
            this.launchingDelay = this.currentBuildingSlot.getStacksToDisplay().size() * BuildingItem.ITEMS_SPACE;
            this.markerToBuild.bluePrintBuilder.buildSlot(this.robot.field_70170_p, this.markerToBuild, this.currentBuildingSlot, this.robot.field_70165_t + 0.125, this.robot.field_70163_u + 0.125, this.robot.field_70161_v + 0.125);
            this.currentBuildingSlot = null;
            this.requirementsToLookFor = null;
        }
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.func_74768_a("launchingDelay", this.launchingDelay);
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        this.launchingDelay = nbt.func_74762_e("launchingDelay");
    }
}

