/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.core.TickHandlerCore;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.robots.AIRobotFetchAndEquipItemStack;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotGotoSleep;
import buildcraft.core.robots.AIRobotSearchBlock;
import buildcraft.core.robots.AIRobotUseToolOnBlock;
import buildcraft.core.robots.IBlockFilter;
import buildcraft.core.robots.ResourceIdBlock;
import buildcraft.core.robots.RobotRegistry;
import buildcraft.core.robots.boards.BoardRobotFarmerNBT;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BoardRobotFarmer
extends RedstoneBoardRobot {
    private BlockIndex blockFound;

    public BoardRobotFarmer(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotFarmerNBT.instance;
    }

    @Override
    public void update() {
        if (this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return stack != null && stack.func_77973_b() instanceof ItemHoe;
                }
            }));
        } else {
            this.startDelegateAI(new AIRobotSearchBlock(this.robot, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    return BuildCraftAPI.isDirtProperty.get(world, x, y, z) && !BoardRobotFarmer.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z)) && BoardRobotFarmer.this.isAirAbove(world, x, y, z);
                }
            }));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchBlock) {
            AIRobotSearchBlock searchAI = (AIRobotSearchBlock)ai;
            if (searchAI.blockFound != null && RobotRegistry.getRegistry(this.robot.field_70170_p).take((ResourceId)new ResourceIdBlock(searchAI.blockFound), this.robot)) {
                if (this.blockFound != null) {
                    this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
                }
                this.blockFound = searchAI.blockFound;
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, searchAI.path));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            AIRobotGotoBlock gotoBlock = (AIRobotGotoBlock)ai;
            this.startDelegateAI(new AIRobotUseToolOnBlock(this.robot, this.blockFound));
        } else if (ai instanceof AIRobotFetchAndEquipItemStack) {
            if (this.robot.func_70694_bm() == null) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotUseToolOnBlock) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    @Override
    public void end() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
        }
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.func_74782_a("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = new BlockIndex(nbt.func_74775_l("blockFound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAirAbove(World world, int x, int y, int z) {
        Integer n = TickHandlerCore.startSynchronousComputation;
        synchronized (n) {
            try {
                TickHandlerCore.startSynchronousComputation.wait();
                return world.func_147437_c(x, y + 1, z);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

