/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.core.TickHandlerCore;
import buildcraft.core.inventory.filters.ArrayStackOrListFilter;
import buildcraft.core.inventory.filters.CompositeFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.inventory.filters.OreStackFilter;
import buildcraft.core.robots.AIRobotFetchAndEquipItemStack;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotGotoRandomGroundBlock;
import buildcraft.core.robots.AIRobotGotoSleep;
import buildcraft.core.robots.AIRobotSearchBlock;
import buildcraft.core.robots.AIRobotUseToolOnBlock;
import buildcraft.core.robots.IBlockFilter;
import buildcraft.core.robots.ResourceIdBlock;
import buildcraft.core.robots.boards.BoardRobotPlanterNBT;
import buildcraft.silicon.statements.ActionRobotFilter;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BoardRobotPlanter
extends RedstoneBoardRobot {
    private IStackFilter stackFilter = new CompositeFilter(new OreStackFilter("treeSapling"), new SeedFilter());
    private BlockIndex blockFound;

    public BoardRobotPlanter(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotPlanterNBT.instance;
    }

    @Override
    public void update() {
        if (this.robot.func_70694_bm() == null) {
            Collection<ItemStack> gateFilter = ActionRobotFilter.getGateFilterStacks(this.robot.getLinkedStation());
            if (gateFilter.size() != 0) {
                ArrayList<ItemStack> filteredFilter = new ArrayList<ItemStack>();
                for (ItemStack tentative : gateFilter) {
                    if (!this.stackFilter.matches(tentative)) continue;
                    filteredFilter.add(tentative);
                }
                if (filteredFilter.size() > 0) {
                    ArrayStackOrListFilter arrayFilter = new ArrayStackOrListFilter(filteredFilter.toArray(new ItemStack[filteredFilter.size()]));
                    this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, arrayFilter));
                } else {
                    this.startDelegateAI(new AIRobotGotoSleep(this.robot));
                }
            } else {
                this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, this.stackFilter));
            }
        } else if (this.robot.func_70694_bm().func_77973_b() instanceof ItemSeeds) {
            this.startDelegateAI(new AIRobotSearchBlock(this.robot, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    return BuildCraftAPI.isFarmlandProperty.get(world, x, y, z) && !BoardRobotPlanter.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z)) && BoardRobotPlanter.this.isAirAbove(world, x, y, z);
                }
            }));
        } else {
            this.startDelegateAI(new AIRobotGotoRandomGroundBlock(this.robot, 100, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    Block b = BoardRobotPlanter.this.robot.field_70170_p.func_147439_a(x, y, z);
                    return b instanceof BlockDirt || b instanceof BlockGrass;
                }
            }, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoRandomGroundBlock) {
            AIRobotGotoRandomGroundBlock gotoBlock = (AIRobotGotoRandomGroundBlock)ai;
            if (gotoBlock.blockFound == null) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else {
                this.startDelegateAI(new AIRobotUseToolOnBlock(this.robot, gotoBlock.blockFound));
            }
        } else if (ai instanceof AIRobotSearchBlock) {
            AIRobotSearchBlock gotoBlock = (AIRobotSearchBlock)ai;
            if (gotoBlock.blockFound != null && this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(gotoBlock.blockFound), this.robot)) {
                if (this.blockFound != null) {
                    this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
                }
                this.blockFound = gotoBlock.blockFound;
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, gotoBlock.path));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            this.startDelegateAI(new AIRobotUseToolOnBlock(this.robot, this.blockFound));
        } else if (ai instanceof AIRobotFetchAndEquipItemStack && this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotGotoSleep(this.robot));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAirAbove(World world, int x, int y, int z) {
        Integer n = TickHandlerCore.startSynchronousComputation;
        synchronized (n) {
            try {
                TickHandlerCore.startSynchronousComputation.wait();
                return world.func_147437_c(x, y + 1, z);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.func_74782_a("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = new BlockIndex(nbt.func_74775_l("blockFound"));
        }
    }

    private static class SeedFilter
    implements IStackFilter {
        private SeedFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemSeeds;
        }
    }
}

