/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.TickHandlerCore;
import buildcraft.core.robots.AIRobotGotoBlock;
import buildcraft.core.robots.AIRobotGotoSleep;
import buildcraft.core.robots.AIRobotGotoStationAndUnloadFluids;
import buildcraft.core.robots.AIRobotPumpBlock;
import buildcraft.core.robots.AIRobotSearchBlock;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.IBlockFilter;
import buildcraft.core.robots.ResourceIdBlock;
import buildcraft.core.robots.boards.BoardRobotPumpNBT;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.gates.StatementSlot;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BoardRobotPump
extends RedstoneBoardRobot {
    private BlockIndex blockFound;
    private ArrayList<Fluid> fluidFilter = new ArrayList();

    public BoardRobotPump(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BoardRobotPumpNBT.instance;
    }

    @Override
    public void update() {
        FluidStack tank = this.robot.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
        if (tank != null && tank.amount > 0) {
            this.startDelegateAI(new AIRobotGotoStationAndUnloadFluids(this.robot, this.robot.getZoneToWork()));
        } else {
            this.updateFilter();
            this.startDelegateAI(new AIRobotSearchBlock(this.robot, new IBlockFilter(){

                @Override
                public boolean matches(World world, int x, int y, int z) {
                    if (BuildCraftAPI.isFluidSource.get(world, x, y, z) && !BoardRobotPump.this.robot.getRegistry().isTaken(new ResourceIdBlock(x, y, z))) {
                        return BoardRobotPump.this.matchesGateFilter(world, x, y, z);
                    }
                    return false;
                }
            }));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchBlock) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else {
                this.blockFound = ((AIRobotSearchBlock)ai).blockFound;
                if (!this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(this.blockFound), this.robot)) {
                    this.blockFound = null;
                    this.startDelegateAI(new AIRobotGotoSleep(this.robot));
                } else {
                    this.startDelegateAI(new AIRobotGotoBlock(this.robot, ((AIRobotSearchBlock)ai).path));
                }
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            } else {
                this.startDelegateAI(new AIRobotPumpBlock(this.robot, this.blockFound));
            }
        } else if (ai instanceof AIRobotGotoStationAndUnloadFluids) {
            this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(this.blockFound), this.robot);
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        }
    }

    public void updateFilter() {
        this.fluidFilter.clear();
        DockingStation station = (DockingStation)this.robot.getLinkedStation();
        for (StatementSlot slot : new ActionIterator(station.getPipe().pipe)) {
            if (!(slot.statement instanceof ActionRobotFilter)) continue;
            for (IStatementParameter p : slot.parameters) {
                FluidStack fluid;
                StatementParameterItemStack param;
                ItemStack stack;
                if (p == null || !(p instanceof StatementParameterItemStack) || (stack = (param = (StatementParameterItemStack)p).getItemStack()) == null || (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) == null) continue;
                this.fluidFilter.add(fluid.getFluid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesGateFilter(World world, int x, int y, int z) {
        if (this.fluidFilter.size() == 0) {
            return true;
        }
        Integer n = TickHandlerCore.startSynchronousComputation;
        synchronized (n) {
            try {
                TickHandlerCore.startSynchronousComputation.wait();
                Block block = world.func_147439_a(x, y, z);
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                for (Fluid f : this.fluidFilter) {
                    if (f.getID() != fluid.getID()) continue;
                    return true;
                }
                return false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

