/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.tiles.IControllable;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionMachineControl
extends BCStatement
implements IActionExternal {
    public final IControllable.Mode mode;

    public ActionMachineControl(IControllable.Mode mode) {
        super("buildcraft:machine." + mode.name().toLowerCase(Locale.ENGLISH), "buildcraft.machine." + mode.name().toLowerCase(Locale.ENGLISH));
        this.mode = mode;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.machine." + this.mode.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void actionActivate(TileEntity target, ForgeDirection side, IStatementContainer source, IStatementParameter[] parameters) {
        if (target instanceof IControllable) {
            ((IControllable)target).setControlMode(this.mode);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("buildcraft:triggers/action_machinecontrol_" + this.mode.name().toLowerCase());
    }
}

