/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerEnergy
extends BCStatement
implements ITriggerInternal,
ITriggerExternal {
    private boolean high;
    private IIcon iconEnergyLow;
    private IIcon iconEnergyHigh;

    public TriggerEnergy(boolean high) {
        super("buildcraft:energyStored" + (high ? "high" : "low"));
        this.high = high;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.machine.energyStored" + (this.high ? "High" : "Low"));
    }

    private boolean isValidEnergyHandler(IEnergyHandler handler) {
        return handler.getMaxEnergyStored(ForgeDirection.UNKNOWN) > 0;
    }

    private boolean isTriggeredEnergyHandler(IEnergyHandler handler) {
        int energyStored = handler.getEnergyStored(ForgeDirection.UNKNOWN);
        int energyMaxStored = handler.getMaxEnergyStored(ForgeDirection.UNKNOWN);
        if (energyMaxStored > 0) {
            if (this.high) {
                return (double)(energyStored / energyMaxStored) > 0.95;
            }
            return (double)(energyStored / energyMaxStored) < 0.05;
        }
        return false;
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        IGate gate;
        if (container instanceof IGate && (gate = (IGate)((Object)container)).getPipe() instanceof IEnergyHandler && this.isValidEnergyHandler((IEnergyHandler)((Object)gate.getPipe()))) {
            return this.isTriggeredEnergyHandler((IEnergyHandler)((Object)gate.getPipe()));
        }
        return false;
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameters) {
        if (tile instanceof IEnergyHandler) {
            return this.isTriggeredEnergyHandler((IEnergyHandler)tile);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_machine_energy_" + (this.high ? "high" : "low"));
    }
}

