/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.StringUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerMachine
extends BCStatement
implements ITriggerExternal {
    boolean active;

    public TriggerMachine(boolean active) {
        super("buildcraft:work." + (active ? "scheduled" : "done"), "buildcraft.work." + (active ? "scheduled" : "done"));
        this.active = active;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.machine." + (this.active ? "scheduled" : "done"));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameters) {
        if (tile instanceof IHasWork) {
            IHasWork machine = (IHasWork)tile;
            if (this.active) {
                return machine.hasWork();
            }
            return !machine.hasWork();
        }
        return false;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("buildcraft:triggers/trigger_machine_" + (this.active ? "active" : "inactive"));
    }
}

