/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.api.core.BCLog;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class ConfigUtils {
    private static final String COMMENT_PREFIX = "";
    private static final String COMMENT_SUFFIX = "";
    private final Configuration config;
    private final String cat;

    public ConfigUtils(Configuration config, String cat) {
        this.config = config;
        this.cat = cat;
    }

    public boolean get(String tag, boolean defaultValue, String comment) {
        return this.get(tag, defaultValue, false, comment);
    }

    public boolean get(String tag, boolean defaultValue, boolean reset, String comment) {
        Property prop = this.config.get(this.cat, tag, defaultValue);
        prop.comment = "" + comment.replace("{t}", tag) + "";
        boolean ret = this.parseBoolean(prop, defaultValue);
        if (reset) {
            prop.set(defaultValue);
        }
        return ret;
    }

    public int get(String tag, int defaultValue, String comment) {
        Property prop = this.config.get(this.cat, tag, defaultValue);
        prop.comment = "" + comment.replace("{t}", tag) + "";
        return this.parseInteger(prop, defaultValue);
    }

    public int get(String tag, int min, int defaultValue, int max, String comment) {
        Property prop = this.config.get(this.cat, tag, defaultValue);
        prop.comment = "" + comment.replace("{t}", tag) + "";
        int parsed = this.parseInteger(prop, defaultValue);
        int clamped = Math.max(parsed, min);
        if ((clamped = Math.min(clamped, max)) != parsed) {
            prop.set(clamped);
        }
        return clamped;
    }

    public float get(String tag, float min, float defaultValue, float max, String comment) {
        Property prop = this.config.get(this.cat, tag, (double)defaultValue);
        prop.comment = "" + comment.replace("{t}", tag) + "";
        double parsed = this.parseDouble(prop, defaultValue);
        double clamped = Math.max(parsed, (double)min);
        if ((clamped = Math.min(clamped, (double)max)) != parsed) {
            prop.set(clamped);
        }
        return (float)clamped;
    }

    private boolean parseBoolean(Property prop, boolean defaultValue) {
        boolean parsed;
        String value = prop.getString();
        try {
            parsed = Boolean.parseBoolean(value);
        }
        catch (NumberFormatException ex) {
            BCLog.logger.log(Level.WARN, "Failed to parse config tag, reseting to default: " + prop.getName(), (Throwable)ex);
            prop.set(defaultValue);
            return defaultValue;
        }
        return parsed;
    }

    private int parseInteger(Property prop, int defaultValue) {
        int parsed;
        String value = prop.getString();
        try {
            parsed = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            BCLog.logger.log(Level.WARN, "Failed to parse config tag, reseting to default: " + prop.getName(), (Throwable)ex);
            prop.set(defaultValue);
            return defaultValue;
        }
        return parsed;
    }

    private double parseDouble(Property prop, double defaultValue) {
        double parsed;
        String value = prop.getString();
        try {
            parsed = Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            BCLog.logger.log(Level.WARN, "Failed to parse config tag, reseting to default: " + prop.getName(), (Throwable)ex);
            prop.set(defaultValue);
            return defaultValue;
        }
        return parsed;
    }
}

