/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.ICustomHighlight;
import buildcraft.core.IItemPipe;
import buildcraft.energy.TileEngine;
import buildcraft.energy.TileEngineCreative;
import buildcraft.energy.TileEngineIron;
import buildcraft.energy.TileEngineStone;
import buildcraft.energy.TileEngineWood;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEngine
extends BlockBuildCraft
implements ICustomHighlight {
    private static final AxisAlignedBB[][] boxes = new AxisAlignedBB[][]{{AxisAlignedBB.func_72330_a((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.func_72330_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75)}, {AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), AxisAlignedBB.func_72330_a((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)1.0, (double)0.75)}, {AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.func_72330_a((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.5)}, {AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), AxisAlignedBB.func_72330_a((double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75, (double)1.0)}, {AxisAlignedBB.func_72330_a((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.func_72330_a((double)0.0, (double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75)}, {AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), AxisAlignedBB.func_72330_a((double)0.5, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75)}};
    private static IIcon woodTexture;
    private static IIcon stoneTexture;
    private static IIcon ironTexture;

    public BlockEngine() {
        super(Material.field_151573_f);
        this.func_149663_c("engineBlock");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        woodTexture = par1IconRegister.func_94245_a("buildcraft:engineWoodBottom");
        stoneTexture = par1IconRegister.func_94245_a("buildcraft:engineStoneBottom");
        ironTexture = par1IconRegister.func_94245_a("buildcraft:engineIronBottom");
    }

    public int func_149645_b() {
        return BuildCraftCore.blockByEntityModel;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEngineWood();
            }
            case 1: {
                return new TileEngineStone();
            }
            case 2: {
                return new TileEngineIron();
            }
            case 3: {
                return new TileEngineCreative();
            }
        }
        return new TileEngineWood();
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEngine) {
            return ((TileEngine)tile).orientation.getOpposite() == side;
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEngine) {
            return ((TileEngine)tile).switchOrientation(false);
        }
        return false;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int side, float par7, float par8, float par9) {
        TileEntity tile = world.func_147438_o(i, j, k);
        BlockInteractionEvent event = new BlockInteractionEvent(player, (Block)this, world.func_72805_g(i, j, k));
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemPipe) {
            return false;
        }
        if (tile instanceof TileEngine) {
            return ((TileEngine)tile).onBlockActivated(player, ForgeDirection.getOrientation((int)side));
        }
        return false;
    }

    public void func_149743_a(World wrd, int x, int y, int z, AxisAlignedBB mask, List list, Entity ent) {
        TileEntity tile = wrd.func_147438_o(x, y, z);
        if (tile instanceof TileEngine) {
            AxisAlignedBB[] aabbs;
            for (AxisAlignedBB aabb : aabbs = boxes[((TileEngine)tile).orientation.ordinal()]) {
                AxisAlignedBB aabbTmp = aabb.func_72325_c((double)x, (double)y, (double)z);
                if (!mask.func_72326_a(aabbTmp)) continue;
                list.add(aabbTmp);
            }
        } else {
            super.func_149743_a(wrd, x, y, z, mask, list, ent);
        }
    }

    @Override
    public AxisAlignedBB[] getBoxes(World wrd, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = wrd.func_147438_o(x, y, z);
        if (tile instanceof TileEngine) {
            return boxes[((TileEngine)tile).orientation.ordinal()];
        }
        return new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};
    }

    @Override
    public double getExpansion() {
        return 0.0075;
    }

    public MovingObjectPosition func_149731_a(World wrd, int x, int y, int z, Vec3 origin, Vec3 direction) {
        TileEntity tile = wrd.func_147438_o(x, y, z);
        if (tile instanceof TileEngine) {
            AxisAlignedBB[] aabbs = boxes[((TileEngine)tile).orientation.ordinal()];
            MovingObjectPosition closest = null;
            for (AxisAlignedBB aabb : aabbs) {
                MovingObjectPosition mop = aabb.func_72325_c((double)x, (double)y, (double)z).func_72327_a(origin, direction);
                if (mop == null) continue;
                closest = closest != null && mop.field_72307_f.func_72438_d(origin) < closest.field_72307_f.func_72438_d(origin) ? mop : mop;
            }
            if (closest != null) {
                closest.field_72311_b = x;
                closest.field_72312_c = y;
                closest.field_72309_d = z;
            }
            return closest;
        }
        return super.func_149731_a(wrd, x, y, z, origin, direction);
    }

    public void func_149714_e(World world, int x, int y, int z, int par5) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEngine) {
            TileEngine engine = (TileEngine)tile;
            engine.orientation = ForgeDirection.UP;
            if (!engine.isOrientationValid()) {
                engine.switchOrientation(true);
            }
        }
    }

    public int func_149692_a(int i) {
        return i;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileEngine && !((TileEngine)tile).isBurning()) {
            return;
        }
        float f = (float)i + 0.5f;
        float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)k + 0.5f;
        float f3 = 0.52f;
        float f4 = random.nextFloat() * 0.6f - 0.3f;
        world.func_72869_a("reddust", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
        itemList.add(new ItemStack((Block)this, 1, 1));
        itemList.add(new ItemStack((Block)this, 1, 2));
        itemList.add(new ItemStack((Block)this, 1, 3));
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEngine) {
            ((TileEngine)tile).onNeighborUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return woodTexture;
            }
            case 1: {
                return stoneTexture;
            }
            case 2: {
                return ironTexture;
            }
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return null;
    }
}

