/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.LaserData;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.RPCSide;
import buildcraft.energy.TileEnergyReceiver;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEnergyEmitter
extends TileBuildCraft {
    public Map<BlockIndex, Target> targets = new TreeMap<BlockIndex, Target>();
    public int rfAcc = 0;
    public int accumulated = 0;
    private SafeTimeTracker syncMJ = new SafeTimeTracker(20L, 5L);
    private SafeTimeTracker scanTracker = new SafeTimeTracker(100L, 10L);

    public TileEnergyEmitter() {
        this.setBattery(new RFBattery(10240, 10240, 0));
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            RPCHandler.rpcServer(this, "requestLasers", new Object[0]);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            for (Target t : this.targets.values()) {
                if (!t.data.isVisible) continue;
                t.data.update();
                t.data.wavePosition += (double)0.2f;
                if (t.data.wavePosition > t.data.renderSize) {
                    t.data.wavePosition = 0.0;
                    t.data.waveSize = (float)(this.getBattery().getEnergyStored() / this.targets.size()) / 100.0f;
                    if (t.data.waveSize > 1.0f) {
                        t.data.waveSize = 1.0f;
                    }
                }
                t.data.iterateTexture();
            }
            return;
        }
        if (this.scanTracker.markTimeIfDelay(this.field_145850_b)) {
            for (TileEnergyReceiver receiver : TileEnergyReceiver.knownReceivers) {
                BlockIndex index;
                float dx = this.field_145851_c - receiver.field_145851_c;
                float dy = this.field_145848_d - receiver.field_145848_d;
                float dz = this.field_145849_e - receiver.field_145849_e;
                if (!(dx * dx + dy * dy + dz * dz < 10000.0f) || this.targets.containsKey(index = new BlockIndex(receiver.field_145851_c, receiver.field_145848_d, receiver.field_145849_e))) continue;
                this.addLaser(receiver.field_145851_c, receiver.field_145848_d, receiver.field_145849_e);
                RPCHandler.rpcBroadcastWorldPlayers(this.field_145850_b, this, "addLaser", receiver.field_145851_c, receiver.field_145848_d, receiver.field_145849_e);
                this.targets.get((Object)index).receiver = receiver;
            }
        }
        this.rfAcc += this.getBattery().getEnergyStored();
        ++this.accumulated;
        if (this.syncMJ.markTimeIfDelay(this.field_145850_b)) {
            RPCHandler.rpcBroadcastWorldPlayers(this.field_145850_b, this, "synchronizeMJ", this.rfAcc / this.accumulated);
            this.rfAcc = 0;
            this.accumulated = 0;
        }
        if (this.getBattery().getEnergyStored() == 0) {
            for (Target t : this.targets.values()) {
                if (!t.data.isVisible) continue;
                t.data.isVisible = false;
                RPCHandler.rpcBroadcastWorldPlayers(this.field_145850_b, this, "disableLaser", t.receiver.field_145851_c, t.receiver.field_145848_d, t.receiver.field_145849_e);
            }
        } else {
            int perTargetEnergy = (int)Math.floor(this.getBattery().useEnergy(this.targets.size(), this.targets.size() * 100, false) / this.targets.size());
            for (Target t : this.targets.values()) {
                if (t.data.isVisible) continue;
                t.data.isVisible = true;
                RPCHandler.rpcBroadcastWorldPlayers(this.field_145850_b, this, "enableLaser", t.receiver.field_145851_c, t.receiver.field_145848_d, t.receiver.field_145849_e);
            }
            for (Target t : this.targets.values()) {
                t.receiver.energyStored += perTargetEnergy;
            }
        }
    }

    @RPC(value=RPCSide.CLIENT)
    public void synchronizeMJ(int val) {
        this.getBattery().setEnergy(val);
    }

    @RPC(value=RPCSide.CLIENT)
    public void addLaser(int x, int y, int z) {
        BlockIndex index = new BlockIndex(x, y, z);
        if (!this.targets.containsKey(index)) {
            Target t = new Target();
            t.data.head.x = (float)this.field_145851_c + 0.5f;
            t.data.head.y = (float)this.field_145848_d + 0.5f;
            t.data.head.z = (float)this.field_145849_e + 0.5f;
            t.data.tail.x = (float)x + 0.5f;
            t.data.tail.y = (float)y + 0.5f;
            t.data.tail.z = (float)z + 0.5f;
            this.targets.put(index, t);
        }
    }

    @RPC(value=RPCSide.CLIENT)
    public void enableLaser(int x, int y, int z) {
        BlockIndex index = new BlockIndex(x, y, z);
        if (this.targets.containsKey(index)) {
            this.targets.get((Object)index).data.isVisible = true;
        }
    }

    @RPC(value=RPCSide.CLIENT)
    public void disableLaser(int x, int y, int z) {
        BlockIndex index = new BlockIndex(x, y, z);
        if (this.targets.containsKey(index)) {
            this.targets.get((Object)index).data.isVisible = false;
        }
    }

    @RPC(value=RPCSide.SERVER)
    public void requestLasers(RPCMessageInfo info) {
        for (BlockIndex b : this.targets.keySet()) {
            RPCHandler.rpcPlayer(info.sender, this, "addLaser", b.x, b.y, b.z);
        }
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double xMin = this.field_145851_c;
        double yMin = this.field_145848_d;
        double zMin = this.field_145849_e;
        double xMax = (double)this.field_145851_c + 1.0;
        double yMax = (double)this.field_145848_d + 1.0;
        double zMax = (double)this.field_145849_e + 1.0;
        for (Target t : this.targets.values()) {
            if (t.data.tail.x < xMin) {
                xMin = t.data.tail.x;
            }
            if (t.data.tail.y < yMin) {
                yMin = t.data.tail.y;
            }
            if (t.data.tail.z < zMin) {
                zMin = t.data.tail.z;
            }
            if (t.data.tail.x > xMax) {
                xMax = t.data.tail.x;
            }
            if (t.data.tail.y > yMax) {
                yMax = t.data.tail.y;
            }
            if (!(t.data.tail.z > zMax)) continue;
            zMax = t.data.tail.z;
        }
        return AxisAlignedBB.func_72330_a((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    public static class Target {
        public LaserData data = new LaserData();
        TileEnergyReceiver receiver;
    }
}

