/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.core.NetworkData;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import buildcraft.energy.gui.ContainerEngine;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEngine
extends TileBuildCraft
implements IPowerReceptor,
IPowerEmitter,
IPipeConnection,
IEnergyHandler {
    public static final ResourceLocation[] BASE_TEXTURES = new ResourceLocation[]{new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_wood.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_stone.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_iron.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_creative.png")};
    public static final ResourceLocation[] CHAMBER_TEXTURES = new ResourceLocation[]{new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber_wood.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber_stone.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber_iron.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber_creative.png")};
    public static final ResourceLocation[] TRUNK_TEXTURES = new ResourceLocation[]{new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_wood.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_stone.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_iron.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_creative.png")};
    public static final ResourceLocation TRUNK_BLUE_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_blue.png");
    public static final ResourceLocation TRUNK_GREEN_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_green.png");
    public static final ResourceLocation TRUNK_YELLOW_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_yellow.png");
    public static final ResourceLocation TRUNK_RED_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_red.png");
    public static final float MIN_HEAT = 20.0f;
    public static final float IDEAL_HEAT = 100.0f;
    public static final float MAX_HEAT = 250.0f;
    public int currentOutput = 0;
    public boolean isRedstonePowered = false;
    public float progress;
    public int energy;
    public float heat = 20.0f;
    @NetworkData
    public EnergyStage energyStage = EnergyStage.BLUE;
    @NetworkData
    public ForgeDirection orientation = ForgeDirection.UP;
    protected int progressPart = 0;
    protected boolean lastPower = false;
    protected PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.ENGINE);
    private boolean checkOrientation = false;
    private TileBuffer[] tileCache;
    @NetworkData
    private boolean isPumping = false;

    public TileEngine() {
        this.powerHandler.configurePowerPerdition(1, 100);
    }

    @Override
    public void initialize() {
        if (!this.field_145850_b.field_72995_K) {
            this.powerHandler.configure(this.minEnergyReceived() / 10, this.maxEnergyReceived() / 10, 1.0, this.getMaxEnergy() / 10);
            this.checkRedstonePower();
        }
    }

    public abstract ResourceLocation getBaseTexture();

    public abstract ResourceLocation getChamberTexture();

    public ResourceLocation getTrunkTexture(EnergyStage stage) {
        switch (stage) {
            case BLUE: {
                return TRUNK_BLUE_TEXTURE;
            }
            case GREEN: {
                return TRUNK_GREEN_TEXTURE;
            }
            case YELLOW: {
                return TRUNK_YELLOW_TEXTURE;
            }
            case RED: {
                return TRUNK_RED_TEXTURE;
            }
        }
        return TRUNK_RED_TEXTURE;
    }

    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        return false;
    }

    public double getEnergyLevel() {
        return (double)this.energy / (double)this.getMaxEnergy();
    }

    protected EnergyStage computeEnergyStage() {
        float energyLevel = this.getHeatLevel();
        if (energyLevel < 0.25f) {
            return EnergyStage.BLUE;
        }
        if (energyLevel < 0.5f) {
            return EnergyStage.GREEN;
        }
        if (energyLevel < 0.75f) {
            return EnergyStage.YELLOW;
        }
        if (energyLevel < 1.0f) {
            return EnergyStage.RED;
        }
        return EnergyStage.OVERHEAT;
    }

    public final EnergyStage getEnergyStage() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.energyStage == EnergyStage.OVERHEAT) {
                return this.energyStage;
            }
            EnergyStage newStage = this.computeEnergyStage();
            if (this.energyStage != newStage) {
                this.energyStage = newStage;
                this.sendNetworkUpdate();
            }
        }
        return this.energyStage;
    }

    public void updateHeatLevel() {
        this.heat = (float)(230.0 * this.getEnergyLevel()) + 20.0f;
    }

    public float getHeatLevel() {
        return (this.heat - 20.0f) / 230.0f;
    }

    public float getIdealHeatLevel() {
        return this.heat / 100.0f;
    }

    public float getHeat() {
        return this.heat;
    }

    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.16f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.02f;
            }
            case GREEN: {
                return 0.04f;
            }
            case YELLOW: {
                return 0.08f;
            }
            case RED: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public void func_145845_h() {
        TileEntity tile;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.progressPart != 0) {
                this.progress += this.getPistonSpeed();
                if (this.progress > 1.0f) {
                    this.progressPart = 0;
                    this.progress = 0.0f;
                }
            } else if (this.isPumping) {
                this.progressPart = 1;
            }
            return;
        }
        if (this.checkOrientation) {
            this.checkOrientation = false;
            if (!this.isOrientationValid()) {
                this.switchOrientation(true);
            } else {
                tile = this.getTileBuffer(this.orientation).getTile();
            }
        }
        this.updateHeatLevel();
        this.getEnergyStage();
        this.engineUpdate();
        tile = this.getTileBuffer(this.orientation).getTile();
        if (this.progressPart != 0) {
            this.progress += this.getPistonSpeed();
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.isActive()) {
            if (this.isPoweredTile(tile, this.orientation)) {
                this.progressPart = 1;
                this.setPumping(true);
                if (this.getPowerToExtract() > 0) {
                    this.progressPart = 1;
                    this.setPumping(true);
                } else {
                    this.setPumping(false);
                }
            } else {
                this.setPumping(false);
            }
        } else {
            this.setPumping(false);
        }
        this.burn();
        if (!this.isRedstonePowered) {
            this.currentOutput = 0;
        } else if (this.isRedstonePowered && this.isActive()) {
            this.sendPower();
        }
    }

    private int getPowerToExtract() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        if (tile instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tile;
            int minEnergy = 0;
            int maxEnergy = handler.receiveEnergy(this.orientation.getOpposite(), Math.round(this.energy), true);
            return this.extractEnergy(minEnergy, maxEnergy, false);
        }
        if (tile instanceof IPowerReceptor) {
            PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(this.orientation.getOpposite());
            return this.extractEnergy((int)Math.floor(receptor.getMinEnergyReceived() * 10.0), (int)Math.ceil(receptor.getMaxEnergyReceived() * 10.0), false);
        }
        return 0;
    }

    protected void sendPower() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        if (this.isPoweredTile(tile, this.orientation)) {
            int extracted = this.getPowerToExtract();
            if (extracted > 0) {
                this.setPumping(true);
            } else {
                this.setPumping(false);
            }
            if (tile instanceof IEnergyHandler) {
                IEnergyHandler handler = (IEnergyHandler)tile;
                if (extracted > 0) {
                    int neededRF = handler.receiveEnergy(this.orientation.getOpposite(), Math.round(extracted), false);
                    this.extractEnergy(0, neededRF, true);
                }
            } else if (tile instanceof IPowerReceptor) {
                PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(this.orientation.getOpposite());
                if (extracted > 0) {
                    double neededMJ = receptor.receiveEnergy(PowerHandler.Type.ENGINE, (double)extracted / 10.0, this.orientation.getOpposite());
                    this.extractEnergy((int)Math.floor(receptor.getMinEnergyReceived() * 10.0), (int)Math.ceil(neededMJ * 10.0), true);
                }
            }
        }
    }

    protected void burn() {
    }

    protected void engineUpdate() {
        if (!this.isRedstonePowered) {
            if (this.energy >= 10) {
                this.energy -= 10;
            } else if (this.energy < 10) {
                this.energy = 0;
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    protected final void setPumping(boolean isActive) {
        if (this.isPumping == isActive) {
            return;
        }
        this.isPumping = isActive;
        this.sendNetworkUpdate();
    }

    public boolean isOrientationValid() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        return this.isPoweredTile(tile, this.orientation);
    }

    public boolean switchOrientation(boolean preferPipe) {
        if (preferPipe && this.switchOrientationDo(true)) {
            return true;
        }
        return this.switchOrientationDo(false);
    }

    private boolean switchOrientationDo(boolean pipesOnly) {
        for (int i = this.orientation.ordinal() + 1; i <= this.orientation.ordinal() + 6; ++i) {
            ForgeDirection o = ForgeDirection.VALID_DIRECTIONS[i % 6];
            TileEntity tile = this.getTileBuffer(o).getTile();
            if (pipesOnly && !(tile instanceof IPipeTile) || !this.isPoweredTile(tile, o)) continue;
            this.orientation = o;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return true;
        }
        return false;
    }

    public TileBuffer getTileBuffer(ForgeDirection side) {
        if (this.tileCache == null) {
            this.tileCache = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
        return this.tileCache[side.ordinal()];
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.tileCache = null;
        this.checkOrientation = true;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.tileCache = null;
        this.checkOrientation = true;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.orientation = ForgeDirection.getOrientation((int)data.func_74771_c("orientation"));
        this.progress = data.func_74760_g("progress");
        this.energy = data.func_74762_e("energy");
        this.heat = data.func_74760_g("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("orientation", (byte)this.orientation.ordinal());
        data.func_74776_a("progress", this.progress);
        data.func_74768_a("energy", this.energy);
        data.func_74776_a("heat", this.heat);
    }

    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                int iEnergy = Math.round(this.energy);
                this.energy = iEnergy = iEnergy & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 1: {
                int iEnergy = Math.round(this.energy);
                this.energy = iEnergy = iEnergy & 0xFFFF | (value & 0xFFFF) << 16;
                break;
            }
            case 2: {
                this.currentOutput = value;
                break;
            }
            case 3: {
                this.heat = (float)value / 100.0f;
            }
        }
    }

    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a((Container)containerEngine, 0, Math.round(this.energy) & 0xFFFF);
        iCrafting.func_71112_a((Container)containerEngine, 1, (Math.round(this.energy) & 0xFFFF0000) >> 16);
        iCrafting.func_71112_a((Container)containerEngine, 2, Math.round(this.currentOutput));
        iCrafting.func_71112_a((Container)containerEngine, 3, Math.round(this.heat * 100.0f));
    }

    public abstract boolean isBurning();

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    public void addEnergy(int addition) {
        this.energy += addition;
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.explosionRange(), true);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.energy > this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    public int extractEnergy(int min, int energyMax, boolean doExtract) {
        int extracted;
        int max = Math.min(energyMax, this.maxEnergyExtracted());
        if (max < min || this.energy < min) {
            return 0;
        }
        if (this.energy >= max) {
            extracted = max;
            if (doExtract) {
                this.energy -= max;
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0;
            }
        }
        return extracted;
    }

    public boolean isPoweredTile(TileEntity tile, ForgeDirection side) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IEnergyHandler) {
            return ((IEnergyHandler)tile).canConnectEnergy(side.getOpposite());
        }
        if (tile instanceof IPowerReceptor) {
            return ((IPowerReceptor)tile).getPowerReceiver(side.getOpposite()) != null;
        }
        return false;
    }

    public abstract int getMaxEnergy();

    public int minEnergyReceived() {
        return 20;
    }

    public abstract int maxEnergyReceived();

    public abstract int maxEnergyExtracted();

    public abstract float explosionRange();

    public int getEnergyStored() {
        return this.energy;
    }

    public abstract int calculateCurrentOutput();

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.DEFAULT;
        }
        if (with == this.orientation) {
            return IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return side == this.orientation;
    }

    public void checkRedstonePower() {
        this.isRedstonePowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onNeighborUpdate() {
        this.checkRedstonePower();
        this.checkOrientation = true;
        this.tileCache = null;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (from != this.orientation) {
            return 0;
        }
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergy();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.orientation;
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        RED,
        OVERHEAT;

        public static final EnergyStage[] VALUES;

        static {
            VALUES = EnergyStage.values();
        }
    }
}

