/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.energy.TileEngine;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngineWood
extends TileEngine {
    private boolean hasSent = false;

    @Override
    public ResourceLocation getBaseTexture() {
        return BASE_TEXTURES[0];
    }

    @Override
    public ResourceLocation getChamberTexture() {
        return CHAMBER_TEXTURES[0];
    }

    @Override
    public float explosionRange() {
        return 1.0f;
    }

    @Override
    public int minEnergyReceived() {
        return 0;
    }

    @Override
    public int maxEnergyReceived() {
        return 500;
    }

    @Override
    protected TileEngine.EnergyStage computeEnergyStage() {
        double energyLevel = this.getEnergyLevel();
        if (energyLevel < 0.25) {
            return TileEngine.EnergyStage.BLUE;
        }
        if (energyLevel < 0.5) {
            return TileEngine.EnergyStage.GREEN;
        }
        if (energyLevel < 0.75) {
            return TileEngine.EnergyStage.YELLOW;
        }
        return TileEngine.EnergyStage.RED;
    }

    @Override
    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.08f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case GREEN: {
                return 0.02f;
            }
            case YELLOW: {
                return 0.04f;
            }
            case RED: {
                return 0.08f;
            }
        }
        return 0.01f;
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        if (this.isRedstonePowered && this.field_145850_b.func_82737_E() % 16L == 0L) {
            this.addEnergy(10);
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public int getMaxEnergy() {
        return 1000;
    }

    @Override
    public int calculateCurrentOutput() {
        return 10;
    }

    @Override
    public int maxEnergyExtracted() {
        return 10;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return false;
    }

    @Override
    protected void sendPower() {
        if (this.progressPart == 2 && !this.hasSent) {
            this.hasSent = true;
            TileEntity tile = this.getTileBuffer(this.orientation).getTile();
            if (tile instanceof IPipeTile && ((IPipeTile)tile).getPipeType() != IPipeTile.PipeType.POWER) {
                super.sendPower();
            } else {
                this.energy = 0;
            }
        } else if (this.progressPart != 2) {
            this.hasSent = false;
        }
    }
}

