/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMiningWell
extends TileBuildCraft
implements IHasWork,
IPipeConnection {
    boolean isDigging = true;

    public TileMiningWell() {
        this.setBattery(new RFBattery(10000, 640, 0));
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int miningCost = (int)Math.ceil(640.0f * BuildCraftFactory.miningMultiplier);
        if (this.getBattery().useEnergy(miningCost, miningCost, false) == 0) {
            return;
        }
        World world = this.field_145850_b;
        int depth = this.field_145848_d - 1;
        while (world.func_147439_a(this.field_145851_c, depth, this.field_145849_e) == BuildCraftFactory.plainPipeBlock) {
            --depth;
        }
        if (depth < 1 || depth < this.field_145848_d - BuildCraftFactory.miningDepth || !BlockUtil.canChangeBlock(world, this.field_145851_c, depth, this.field_145849_e)) {
            this.isDigging = false;
            return;
        }
        boolean wasAir = world.func_147437_c(this.field_145851_c, depth, this.field_145849_e);
        List<ItemStack> stacks = BlockUtil.getItemStackFromBlock((WorldServer)this.field_145850_b, this.field_145851_c, depth, this.field_145849_e);
        world.func_147449_b(this.field_145851_c, depth, this.field_145849_e, (Block)BuildCraftFactory.plainPipeBlock);
        if (wasAir) {
            return;
        }
        if (stacks == null || stacks.isEmpty()) {
            return;
        }
        for (ItemStack stack : stacks) {
            stack.field_77994_a -= Utils.addToRandomInventoryAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack);
            if (stack.field_77994_a <= 0) continue;
            stack.field_77994_a -= Utils.addToRandomPipeAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UNKNOWN, stack);
            if (stack.field_77994_a <= 0) continue;
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)this.field_145851_c + f), (double)((float)this.field_145848_d + f1 + 0.5f), (double)((float)this.field_145849_e + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.field_145804_b = 10;
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 1.0f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && this.field_145848_d > 2) {
            BuildCraftFactory.miningWellBlock.removePipes(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean hasWork() {
        return this.isDigging;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }
}

