/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.core.NetworkData;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.tiles.IControllable;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCSide;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.robots.ResourceIdAssemblyTable;
import buildcraft.core.robots.RobotRegistry;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.TileLaserTableBase;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TileAssemblyTable
extends TileLaserTableBase
implements IInventory,
IFlexibleCrafter {
    @NetworkData
    public String currentRecipeId = "";
    public IFlexibleRecipe<ItemStack> currentRecipe;
    @NetworkData
    private HashSet<String> plannedOutput = new HashSet();

    public List<CraftingResult<ItemStack>> getPotentialOutputs() {
        LinkedList<CraftingResult<ItemStack>> result = new LinkedList<CraftingResult<ItemStack>>();
        for (IFlexibleRecipe<ItemStack> recipe : AssemblyRecipeManager.INSTANCE.getRecipes()) {
            CraftingResult<ItemStack> r = recipe.craft(this, true);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.currentRecipe == null) {
            return;
        }
        if (!this.currentRecipe.canBeCrafted(this)) {
            this.setNextCurrentRecipe();
            if (this.currentRecipe == null) {
                return;
            }
        }
        if (this.getEnergy() >= this.currentRecipe.craft((IFlexibleCrafter)this, (boolean)true).energyCost && this.lastMode != IControllable.Mode.Off) {
            this.setEnergy(0);
            if (this.currentRecipe.canBeCrafted(this)) {
                ItemStack remaining = ((ItemStack)this.currentRecipe.craft((IFlexibleCrafter)this, (boolean)false).crafted).func_77946_l();
                EntityRobot robot = RobotRegistry.getRegistry(this.field_145850_b).robotTaking(new ResourceIdAssemblyTable(this));
                if (robot != null) {
                    remaining = robot.receiveItem(this, remaining);
                }
                if (remaining != null && remaining.field_77994_a > 0) {
                    remaining.field_77994_a -= Utils.addToRandomInventoryAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, remaining);
                }
                if (remaining != null && remaining.field_77994_a > 0) {
                    remaining.field_77994_a -= Utils.addToRandomPipeAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UNKNOWN, remaining);
                }
                if (remaining != null && remaining.field_77994_a > 0) {
                    EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5, remaining);
                    this.field_145850_b.func_72838_d((Entity)entityitem);
                }
                this.setNextCurrentRecipe();
            }
        }
    }

    public int func_70302_i_() {
        return 12;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (this.currentRecipe == null) {
            this.setNextCurrentRecipe();
        }
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.assemblyTableBlock.name");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        IFlexibleRecipe recipe;
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("plannedIds", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            IFlexibleRecipe recipe2 = AssemblyRecipeManager.INSTANCE.getRecipe(list.func_150307_f(i));
            if (recipe2 == null) continue;
            this.plannedOutput.add(recipe2.getId());
        }
        if (nbt.func_74764_b("recipeId") && (recipe = AssemblyRecipeManager.INSTANCE.getRecipe(nbt.func_74779_i("recipeId"))) != null) {
            this.setCurrentRecipe(recipe);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (String recipe : this.plannedOutput) {
            list.func_74742_a((NBTBase)new NBTTagString(recipe));
        }
        nbt.func_74782_a("plannedIds", (NBTBase)list);
        if (this.currentRecipe != null) {
            nbt.func_74778_a("recipeId", this.currentRecipe.getId());
        }
    }

    public boolean isPlanned(IFlexibleRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        return this.plannedOutput.contains(recipe.getId());
    }

    public boolean isAssembling(IFlexibleRecipe recipe) {
        return recipe != null && recipe == this.currentRecipe;
    }

    private void setCurrentRecipe(IFlexibleRecipe<ItemStack> recipe) {
        this.currentRecipe = recipe;
        this.currentRecipeId = recipe != null ? recipe.getId() : "";
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.sendNetworkUpdate();
        }
    }

    @Override
    public int getRequiredEnergy() {
        if (this.currentRecipe != null) {
            CraftingResult<ItemStack> result = this.currentRecipe.craft(this, true);
            if (result != null) {
                return result.energyCost;
            }
            return 0;
        }
        return 0;
    }

    public void planOutput(IFlexibleRecipe<ItemStack> recipe) {
        if (recipe != null && !this.isPlanned(recipe)) {
            this.plannedOutput.add(recipe.getId());
            if (!this.isAssembling(this.currentRecipe) || !this.isPlanned(this.currentRecipe)) {
                this.setCurrentRecipe(recipe);
            }
        }
    }

    public void cancelPlanOutput(IFlexibleRecipe<ItemStack> recipe) {
        if (this.isAssembling(recipe)) {
            this.setCurrentRecipe(null);
        }
        this.plannedOutput.remove(recipe.getId());
        if (!this.plannedOutput.isEmpty()) {
            this.setCurrentRecipe(AssemblyRecipeManager.INSTANCE.getRecipe(this.plannedOutput.iterator().next()));
        }
    }

    public void setNextCurrentRecipe() {
        IFlexibleRecipe recipe;
        boolean takeNext = false;
        for (String recipeId : this.plannedOutput) {
            recipe = AssemblyRecipeManager.INSTANCE.getRecipe(recipeId);
            if (recipe == this.currentRecipe) {
                takeNext = true;
                continue;
            }
            if (!takeNext || !recipe.canBeCrafted(this)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        for (String recipeId : this.plannedOutput) {
            recipe = AssemblyRecipeManager.INSTANCE.getRecipe(recipeId);
            if (!recipe.canBeCrafted(this)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        this.setCurrentRecipe(null);
    }

    public void rpcSelectRecipe(String id, boolean select) {
        RPCHandler.rpcServer(this, "selectRecipe", id, select);
    }

    @RPC(value=RPCSide.SERVER)
    private void selectRecipe(String id, boolean select) {
        IFlexibleRecipe recipe = AssemblyRecipeManager.INSTANCE.getRecipe(id);
        if (recipe != null) {
            if (select) {
                this.planOutput(recipe);
            } else {
                this.cancelPlanOutput(recipe);
            }
        }
        this.sendNetworkUpdate();
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null && super.hasWork();
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public void postPacketHandling(PacketUpdate packet) {
        this.currentRecipe = AssemblyRecipeManager.INSTANCE.getRecipe(this.currentRecipeId);
    }

    @Override
    public int getCraftingItemStackSize() {
        return this.func_70302_i_();
    }

    @Override
    public ItemStack getCraftingItemStack(int slotid) {
        return this.func_70301_a(slotid);
    }

    @Override
    public ItemStack decrCraftingItemgStack(int slotid, int val) {
        return this.func_70298_a(slotid, val);
    }

    @Override
    public FluidStack getCraftingFluidStack(int tankid) {
        return null;
    }

    @Override
    public FluidStack decrCraftingFluidStack(int tankid, int val) {
        return null;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return 0;
    }
}

