/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.JavaTools;
import buildcraft.api.core.Position;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.transport.IPipePluggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.BlockSpring;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.TileGenericPipe;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemFacade
extends ItemBuildCraft
implements IFacadeItem {
    public static final LinkedList<ItemStack> allFacades = new LinkedList();
    public static final LinkedList<String> blacklistedFacades = new LinkedList();
    private static final Block NULL_BLOCK = null;
    private static final ItemStack NO_MATCH = new ItemStack(NULL_BLOCK, 0, 0);

    public ItemFacade() {
        super(CreativeTabBuildCraft.FACADES);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public String func_77653_i(ItemStack itemstack) {
        switch (this.getFacadeType(itemstack)) {
            case Basic: {
                return super.func_77653_i(itemstack) + ": " + ItemFacade.getFacadeStateDisplayName(ItemFacade.getFacadeStates(itemstack)[0]);
            }
            case Phased: {
                return StringUtils.localize("item.FacadePhased.name");
            }
        }
        return "";
    }

    public String func_77667_c(ItemStack itemstack) {
        return "item.Facade";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean debug) {
        if (this.getFacadeType(stack) == FacadeType.Phased) {
            String stateString = StringUtils.localize("item.FacadePhased.state");
            FacadeState defaultState = null;
            for (FacadeState state : ItemFacade.getFacadeStates(stack)) {
                if (state.wire == null) {
                    defaultState = state;
                    continue;
                }
                list.add(String.format(stateString, state.wire.getColor(), ItemFacade.getFacadeStateDisplayName(state)));
            }
            if (defaultState != null) {
                list.add(1, String.format(StringUtils.localize("item.FacadePhased.state_default"), ItemFacade.getFacadeStateDisplayName(defaultState)));
            }
        }
    }

    public static String getFacadeStateDisplayName(FacadeState state) {
        if (state.block == null) {
            return StringUtils.localize("item.FacadePhased.state_transparent");
        }
        int meta = state.metadata;
        if (state.block.func_149645_b() == 31) {
            meta &= 3;
        } else if (state.block.func_149645_b() == 39 && meta > 2) {
            meta = 2;
        }
        return CoreProxy.proxy.getItemDisplayName(new ItemStack(state.block, 1, meta));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (ItemStack stack : allFacades) {
            itemList.add(stack.func_77946_l());
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (worldObj.field_72995_K) {
            return false;
        }
        Position pos = new Position(x, y, z, ForgeDirection.getOrientation((int)side));
        pos.moveForwards(1.0);
        TileEntity tile = worldObj.func_147438_o((int)pos.x, (int)pos.y, (int)pos.z);
        if (!(tile instanceof TileGenericPipe)) {
            return false;
        }
        TileGenericPipe pipeTile = (TileGenericPipe)tile;
        if (pipeTile.addFacade(ForgeDirection.getOrientation((int)side).getOpposite(), ItemFacade.getFacadeStates(stack))) {
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    public void initialize() {
        for (Object o : Block.field_149771_c) {
            Item item;
            Block b = (Block)o;
            if (!ItemFacade.isBlockValidForFacade(b) || (item = Item.func_150898_a((Block)b)) == null || ItemFacade.isBlockBlacklisted(b)) continue;
            this.registerValidFacades(b, item);
        }
    }

    private void registerValidFacades(Block block, Item item) {
        HashSet names = Sets.newHashSet();
        for (int i = 0; i < 16; ++i) {
            try {
                ItemStack stack;
                if (block.hasTileEntity(i) || Strings.isNullOrEmpty((String)(stack = new ItemStack(item, 1, i)).func_77977_a()) || !names.add(stack.func_77977_a())) continue;
                this.addFacade("buildcraft:facade{" + Block.field_149771_c.func_148750_c((Object)block) + "#" + stack.func_77960_j() + "}", stack);
                if (block.func_149645_b() != 31 && (block.func_149645_b() != 39 || i != 2)) continue;
                break;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static boolean isBlockBlacklisted(Block block) {
        String blockName = Block.field_149771_c.func_148750_c((Object)block);
        if (blockName == null) {
            return true;
        }
        for (String blacklistedBlock : BuildCraftTransport.facadeBlacklist) {
            if (!blockName.equals(JavaTools.stripSurroundingQuotes(blacklistedBlock))) continue;
            return true;
        }
        for (String blacklistedBlock : blacklistedFacades) {
            if (!blockName.equals(blacklistedBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlockValidForFacade(Block block) {
        try {
            if (block.func_149645_b() != 0 && block.func_149645_b() != 31 && block.func_149645_b() != 39) {
                return false;
            }
            if (block.func_149753_y() != 1.0 || block.func_149669_A() != 1.0 || block.func_149693_C() != 1.0) {
                return false;
            }
            return !(block instanceof BlockSpring) && !(block instanceof BlockGenericPipe);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static FacadeState[] getFacadeStates(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return new FacadeState[0];
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!(nbt = ItemFacade.migrate(stack, nbt)).func_74764_b("states")) {
            return new FacadeState[0];
        }
        return FacadeState.readArray(nbt.func_150295_c("states", 10));
    }

    private static NBTTagCompound migrate(ItemStack stack, NBTTagCompound nbt) {
        Block block = null;
        Block blockAlt = null;
        int metadata = 0;
        PipeWire wire = null;
        if (nbt.func_74764_b("id")) {
            block = (Block)Block.field_149771_c.func_148754_a(nbt.func_74762_e("id"));
        } else if (nbt.func_74764_b("name")) {
            block = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("name"));
        }
        if (nbt.func_74764_b("name_alt")) {
            blockAlt = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("name_alt"));
        }
        if (nbt.func_74764_b("meta")) {
            metadata = nbt.func_74762_e("meta");
        }
        int metadataAlt = nbt.func_74764_b("meta_alt") ? nbt.func_74762_e("meta_alt") : stack.func_77960_j() & 0xF;
        if (nbt.func_74764_b("wire")) {
            wire = PipeWire.fromOrdinal(nbt.func_74762_e("wire"));
        }
        if (block != null) {
            FacadeState[] states;
            FacadeState mainState = FacadeState.create(block, metadata);
            if (blockAlt != null && wire != null) {
                FacadeState altState = FacadeState.create(blockAlt, metadataAlt, wire);
                states = new FacadeState[]{mainState, altState};
            } else {
                states = new FacadeState[]{mainState};
            }
            NBTTagCompound newNbt = ItemFacade.getFacade(states).func_77978_p();
            stack.func_77982_d(newNbt);
            return newNbt;
        }
        return nbt;
    }

    @Override
    public Block[] getBlocksForFacade(ItemStack stack) {
        FacadeState[] states = ItemFacade.getFacadeStates(stack);
        Block[] blocks = new Block[states.length];
        for (int i = 0; i < states.length; ++i) {
            blocks[i] = states[i].block;
        }
        return blocks;
    }

    @Override
    public int[] getMetaValuesForFacade(ItemStack stack) {
        FacadeState[] states = ItemFacade.getFacadeStates(stack);
        int[] meta = new int[states.length];
        for (int i = 0; i < states.length; ++i) {
            meta[i] = states[i].metadata;
        }
        return meta;
    }

    @Override
    public FacadeType getFacadeType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return FacadeType.Basic;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("type")) {
            return FacadeType.Basic;
        }
        return FacadeType.fromOrdinal(nbt.func_74762_e("type"));
    }

    @Override
    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public void addFacade(String id, ItemStack itemStack) {
        ItemStack facade;
        if (itemStack.field_77994_a == 0) {
            itemStack.field_77994_a = 1;
        }
        if (!allFacades.contains(facade = this.getFacadeForBlock(Block.func_149634_a((Item)itemStack.func_77973_b()), itemStack.func_77960_j()))) {
            allFacades.add(facade);
            ItemStack facade6 = facade.func_77946_l();
            facade6.field_77994_a = 6;
            BuildcraftRecipeRegistry.assemblyTable.addRecipe(id, 8000, facade6, new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack);
        }
    }

    public static void blacklistFacade(String blockName) {
        if (!blacklistedFacades.contains(blockName)) {
            blacklistedFacades.add(blockName);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @Override
    public ItemStack getFacadeForBlock(Block block, int metadata) {
        return ItemFacade.getFacade(FacadeState.create(block, metadata));
    }

    public static ItemStack getAdvancedFacade(PipeWire wire, Block block, int metadata, Block blockAlt, int metaDataAlt) {
        return ItemFacade.getFacade(FacadeState.create(block, metadata), FacadeState.create(blockAlt, metaDataAlt, wire));
    }

    public static ItemStack getFacade(FacadeState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        boolean basic = states.length == 1 && states[0].wire == null;
        ItemStack stack = new ItemStack((Item)BuildCraftTransport.facadeItem, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("type", (byte)(basic ? FacadeType.Basic : FacadeType.Phased).ordinal());
        nbt.func_74782_a("states", (NBTBase)FacadeState.writeArray(states));
        stack.func_77982_d(nbt);
        return stack;
    }

    public class FacadeRecipe
    implements IRecipe {
        public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            return facade != null && facade[0] != null && ((Block[])facade[0]).length == 1;
        }

        public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            if (facade == null || ((Block[])facade[0]).length != 1) {
                return null;
            }
            Block block = ((Block[])facade[0])[0];
            ItemStack originalFacade = (ItemStack)facade[1];
            if (block == null) {
                return null;
            }
            return this.getNextFacadeItemStack(block, originalFacade);
        }

        private Object[] getFacadeBlockFromCraftingGrid(InventoryCrafting inventorycrafting) {
            ItemStack slotmatch = null;
            int countOfItems = 0;
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                ItemStack slot = inventorycrafting.func_70301_a(i);
                if (slot != null && slot.func_77973_b() == ItemFacade.this && slotmatch == null) {
                    slotmatch = slot;
                    ++countOfItems;
                } else if (slot != null) {
                    slotmatch = NO_MATCH;
                }
                if (countOfItems <= true) continue;
                return null;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                return new Object[]{ItemFacade.this.getBlocksForFacade(slotmatch), slotmatch};
            }
            return null;
        }

        private ItemStack getNextFacadeItemStack(Block block, ItemStack originalFacade) {
            int blockMeta;
            int stackMeta = blockMeta = ItemFacade.this.getMetaValuesForFacade(originalFacade)[0];
            switch (block.func_149645_b()) {
                case 0: {
                    stackMeta = blockMeta + 1 & 0xF;
                    break;
                }
                case 31: {
                    if ((blockMeta & 0xC) == 0) {
                        stackMeta = blockMeta & 3 | 4;
                        break;
                    }
                    if ((blockMeta & 8) == 0) {
                        stackMeta = blockMeta & 3 | 8;
                        break;
                    }
                    if ((blockMeta & 4) != 0) break;
                    stackMeta = blockMeta & 3;
                    break;
                }
                case 39: {
                    if (blockMeta >= 2 && blockMeta < 4) {
                        stackMeta = blockMeta + 1;
                        break;
                    }
                    if (blockMeta != 4) break;
                    stackMeta = 2;
                }
            }
            return ItemFacade.this.getFacadeForBlock(block, stackMeta);
        }

        public int func_77570_a() {
            return 1;
        }

        public ItemStack func_77571_b() {
            return null;
        }
    }

    public static class FacadePluggable
    implements IPipePluggable {
        public FacadeState[] states;

        public FacadePluggable(FacadeState[] states) {
            this.states = states;
        }

        public FacadePluggable() {
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            if (this.states != null) {
                nbt.func_74782_a("states", (NBTBase)FacadeState.writeArray(this.states));
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("states")) {
                this.states = FacadeState.readArray(nbt.func_150295_c("states", 10));
            }
        }

        @Override
        public ItemStack[] getDropItems(IPipeTile pipe) {
            ItemStack[] itemStackArray;
            if (this.states == null) {
                itemStackArray = null;
            } else {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = ItemFacade.getFacade(this.states);
            }
            return itemStackArray;
        }

        @Override
        public void onAttachedPipe(IPipeTile pipe, ForgeDirection direction) {
        }

        @Override
        public void onDetachedPipe(IPipeTile pipe, ForgeDirection direction) {
        }

        @Override
        public boolean blocking(IPipeTile pipe, ForgeDirection direction) {
            return false;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate(IPipeTile pipe, ForgeDirection direction) {
        }
    }

    public static class FacadeState {
        public final Block block;
        public final int metadata;
        public final boolean transparent;
        public final PipeWire wire;

        public FacadeState(Block block, int metadata, PipeWire wire) {
            this.block = block;
            this.metadata = metadata;
            this.wire = wire;
            this.transparent = false;
        }

        public FacadeState(NBTTagCompound nbt) {
            this.block = nbt.func_74764_b("block") ? (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("block")) : null;
            this.metadata = nbt.func_74771_c("metadata");
            this.wire = nbt.func_74764_b("wire") ? PipeWire.fromOrdinal(nbt.func_74771_c("wire")) : null;
            this.transparent = nbt.func_74764_b("transparent") && nbt.func_74767_n("transparent");
        }

        private FacadeState(PipeWire wire) {
            this.block = null;
            this.metadata = 0;
            this.wire = wire;
            this.transparent = true;
        }

        public static FacadeState create(Block block, int metadata) {
            return FacadeState.create(block, metadata, null);
        }

        public static FacadeState create(Block block, int metadata, PipeWire wire) {
            return new FacadeState(block, metadata, wire);
        }

        public static FacadeState createTransparent(PipeWire wire) {
            return new FacadeState(wire);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            if (this.block != null) {
                nbt.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
            }
            nbt.func_74774_a("metadata", (byte)this.metadata);
            if (this.wire != null) {
                nbt.func_74774_a("wire", (byte)this.wire.ordinal());
            }
            nbt.func_74757_a("transparent", this.transparent);
        }

        public static NBTTagList writeArray(FacadeState[] states) {
            if (states == null) {
                return null;
            }
            NBTTagList list = new NBTTagList();
            for (FacadeState state : states) {
                NBTTagCompound stateNBT = new NBTTagCompound();
                state.writeToNBT(stateNBT);
                list.func_74742_a((NBTBase)stateNBT);
            }
            return list;
        }

        public static FacadeState[] readArray(NBTTagList list) {
            if (list == null) {
                return null;
            }
            int length = list.func_74745_c();
            FacadeState[] states = new FacadeState[length];
            for (int i = 0; i < length; ++i) {
                states[i] = new FacadeState(list.func_150305_b(i));
            }
            return states;
        }
    }
}

