/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.network.IClientState;
import buildcraft.transport.utils.ConnectionMatrix;
import buildcraft.transport.utils.FacadeMatrix;
import buildcraft.transport.utils.GateMatrix;
import buildcraft.transport.utils.RobotStationMatrix;
import buildcraft.transport.utils.TextureMatrix;
import buildcraft.transport.utils.WireMatrix;
import io.netty.buffer.ByteBuf;

public class PipeRenderState
implements IClientState {
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public final WireMatrix wireMatrix = new WireMatrix();
    public final ConnectionMatrix plugMatrix = new ConnectionMatrix();
    public final RobotStationMatrix robotStationMatrix = new RobotStationMatrix();
    public final FacadeMatrix facadeMatrix = new FacadeMatrix();
    public final GateMatrix gateMatrix = new GateMatrix();
    public byte glassColor = (byte)-1;
    private boolean dirty = true;

    public void clean() {
        this.dirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.facadeMatrix.clean();
        this.wireMatrix.clean();
        this.plugMatrix.clean();
        this.robotStationMatrix.clean();
        this.gateMatrix.clean();
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.wireMatrix.isDirty() || this.facadeMatrix.isDirty() || this.plugMatrix.isDirty() || this.robotStationMatrix.isDirty() || this.gateMatrix.isDirty();
    }

    public boolean needsRenderUpdate() {
        return this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.facadeMatrix.isDirty() || this.plugMatrix.isDirty() || this.robotStationMatrix.isDirty() || this.gateMatrix.isDirty();
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte((int)this.glassColor);
        this.pipeConnectionMatrix.writeData(data);
        this.textureMatrix.writeData(data);
        this.wireMatrix.writeData(data);
        this.facadeMatrix.writeData(data);
        this.plugMatrix.writeData(data);
        this.robotStationMatrix.writeData(data);
        this.gateMatrix.writeData(data);
    }

    @Override
    public void readData(ByteBuf data) {
        this.glassColor = data.readByte();
        this.pipeConnectionMatrix.readData(data);
        this.textureMatrix.readData(data);
        this.wireMatrix.readData(data);
        this.facadeMatrix.readData(data);
        this.plugMatrix.readData(data);
        this.robotStationMatrix.readData(data);
        this.gateMatrix.readData(data);
    }
}

