/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipePluggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.DefaultProps;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.ITileBufferHolder;
import buildcraft.core.TileBuffer;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.IClientState;
import buildcraft.core.network.IGuiReturnHandler;
import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.PacketTileState;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.utils.ColorUtils;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.IPipeConnectionForced;
import buildcraft.transport.ISolidSideTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemPlug;
import buildcraft.transport.ItemRobotStation;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.GateFactory;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.utils.RobotStationState;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.logging.log4j.Level;

public class TileGenericPipe
extends TileEntity
implements IPowerReceptor,
IFluidHandler,
IPipeTile,
ITileBufferHolder,
IEnergyHandler,
IDropControlInventory,
ISyncedTile,
ISolidSideTile,
IGuiReturnHandler {
    public boolean initialized = false;
    public final PipeRenderState renderState = new PipeRenderState();
    public final CoreState coreState = new CoreState();
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public Pipe pipe;
    public int redstoneInput;
    public int[] redstoneInputSide = new int[ForgeDirection.VALID_DIRECTIONS.length];
    public int glassColor = -1;
    protected boolean deletePipe = false;
    protected boolean sendClientUpdate = false;
    protected boolean blockNeighborChange = false;
    protected boolean refreshRenderState = false;
    protected boolean pipeBound = false;
    protected boolean resyncGateExpansions = false;
    protected boolean attachPluggables = false;
    private TileBuffer[] tileBuffer;
    private SideProperties sideProperties = new SideProperties();

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.glassColor >= 0) {
            nbt.func_74774_a("stainedColor", (byte)this.glassColor);
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            nbt.func_74774_a(key, (byte)this.redstoneInputSide[i]);
        }
        if (this.pipe != null) {
            nbt.func_74768_a("pipeId", Item.func_150891_b((Item)this.pipe.item));
            this.pipe.writeToNBT(nbt);
        } else {
            nbt.func_74768_a("pipeId", this.coreState.pipeId);
        }
        this.sideProperties.writeToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.glassColor = nbt.func_74764_b("stainedColor") ? (int)nbt.func_74771_c("stainedColor") : -1;
        this.redstoneInput = 0;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            if (nbt.func_74764_b(key)) {
                this.redstoneInputSide[i] = nbt.func_74771_c(key);
                if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                this.redstoneInput = this.redstoneInputSide[i];
                continue;
            }
            this.redstoneInputSide[i] = 0;
        }
        this.coreState.pipeId = nbt.func_74762_e("pipeId");
        this.pipe = BlockGenericPipe.createPipe(Item.func_150899_d((int)this.coreState.pipeId));
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbt);
        } else {
            BCLog.logger.log(Level.WARN, "Pipe failed to load from NBT at {0},{1},{2}", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
            this.deletePipe = true;
        }
        this.sideProperties.readFromNBT(nbt);
        this.attachPluggables = true;
    }

    public void func_145843_s() {
        this.initialized = false;
        this.tileBuffer = null;
        if (this.pipe != null) {
            this.pipe.invalidate();
        }
        this.sideProperties.invalidate();
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.initialized = false;
        this.tileBuffer = null;
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
        this.sideProperties.validate(this);
    }

    protected void notifyBlockChanged() {
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBlock());
        this.scheduleRenderUpdate();
        this.sendUpdateToClient();
        BlockGenericPipe.updateNeighbourSignalState(this.pipe);
    }

    public void func_145845_h() {
        if (this.attachPluggables) {
            this.attachPluggables = false;
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                if (this.sideProperties.pluggables[i] == null) continue;
                this.sideProperties.pluggables[i].onAttachedPipe(this, ForgeDirection.getOrientation((int)i));
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.deletePipe) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.pipe == null) {
                return;
            }
            if (!this.initialized) {
                this.initialize(this.pipe);
            }
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return;
        }
        this.pipe.updateEntity();
        if (this.field_145850_b.field_72995_K) {
            if (this.resyncGateExpansions) {
                this.syncGateExpansions();
            }
            return;
        }
        if (this.blockNeighborChange) {
            this.computeConnections();
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            this.refreshRenderState = false;
        }
        if (this.sendClientUpdate) {
            this.sendClientUpdate = false;
            if (this.field_145850_b instanceof WorldServer) {
                WorldServer world = (WorldServer)this.field_145850_b;
                BuildCraftPacket updatePacket = this.getBCDescriptionPacket();
                for (Object o : world.field_73010_i) {
                    EntityPlayerMP player = (EntityPlayerMP)o;
                    if (!world.func_73040_p().func_72694_a(player, this.field_145851_c >> 4, this.field_145849_e >> 4)) continue;
                    BuildCraftCore.instance.sendToPlayer((EntityPlayer)player, updatePacket);
                }
            }
        }
    }

    public int getItemMetadata() {
        return 1 + (this.field_145850_b.field_72995_K ? (int)this.renderState.glassColor : this.glassColor);
    }

    public int getStainedColorMultiplier() {
        int color = this.field_145850_b.field_72995_K ? (int)this.renderState.glassColor : this.glassColor;
        return color >= 0 ? ColorUtils.getRGBColor(color) : -1;
    }

    protected void refreshRenderState() {
        this.renderState.glassColor = (byte)this.glassColor;
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            this.renderState.pipeConnectionMatrix.setConnected(forgeDirection, this.pipeConnectionsBuffer[forgeDirection.ordinal()]);
        }
        for (int i = 0; i < 7; ++i) {
            ForgeDirection o = ForgeDirection.getOrientation((int)i);
            this.renderState.textureMatrix.setIconIndex(o, this.pipe.getIconIndex(o));
        }
        block8: for (PipeWire pipeWire : PipeWire.values()) {
            this.renderState.wireMatrix.setWire(pipeWire, this.pipe.wireSet[pipeWire.ordinal()]);
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                this.renderState.wireMatrix.setWireConnected(pipeWire, direction, this.pipe.isWireConnectedTo(this.getTile(direction), pipeWire));
            }
            boolean lit = this.pipe.signalStrength[pipeWire.ordinal()] > 0;
            switch (pipeWire) {
                case RED: {
                    this.renderState.wireMatrix.setWireIndex(pipeWire, lit ? 1 : 0);
                    continue block8;
                }
                case BLUE: {
                    this.renderState.wireMatrix.setWireIndex(pipeWire, lit ? 3 : 2);
                    continue block8;
                }
                case GREEN: {
                    this.renderState.wireMatrix.setWireIndex(pipeWire, lit ? 5 : 4);
                    continue block8;
                }
                case YELLOW: {
                    this.renderState.wireMatrix.setWireIndex(pipeWire, lit ? 7 : 6);
                    continue block8;
                }
            }
        }
        for (PipeWire pipeWire : ForgeDirection.VALID_DIRECTIONS) {
            Gate gate = this.pipe.gates[pipeWire.ordinal()];
            this.renderState.gateMatrix.setIsGateExists(gate != null, (ForgeDirection)pipeWire);
            this.renderState.gateMatrix.setIsGateLit(gate != null && gate.isGateActive(), (ForgeDirection)pipeWire);
            this.renderState.gateMatrix.setIsGatePulsing(gate != null && gate.isGatePulsing(), (ForgeDirection)pipeWire);
        }
        for (PipeWire pipeWire : ForgeDirection.VALID_DIRECTIONS) {
            IPipePluggable pluggable = this.sideProperties.pluggables[pipeWire.ordinal()];
            if (!(pluggable instanceof ItemFacade.FacadePluggable)) {
                this.renderState.facadeMatrix.setFacade((ForgeDirection)pipeWire, null, 0, true);
                continue;
            }
            ItemFacade.FacadeState[] states = ((ItemFacade.FacadePluggable)pluggable).states;
            if (states == null) {
                this.renderState.facadeMatrix.setFacade((ForgeDirection)pipeWire, null, 0, true);
                continue;
            }
            ItemFacade.FacadeState defaultState = null;
            ItemFacade.FacadeState activeState = null;
            for (ItemFacade.FacadeState state : states) {
                if (state.wire == null) {
                    defaultState = state;
                    continue;
                }
                if (this.pipe == null || !this.pipe.isWireActive(state.wire)) continue;
                activeState = state;
                break;
            }
            if (activeState == null) {
                activeState = defaultState;
            }
            Block block = activeState != null ? activeState.block : null;
            int metadata = activeState != null ? activeState.metadata : 0;
            boolean transparent = activeState == null || block == null;
            this.renderState.facadeMatrix.setFacade((ForgeDirection)pipeWire, block, metadata, transparent);
        }
        for (PipeWire pipeWire : ForgeDirection.VALID_DIRECTIONS) {
            IPipePluggable pluggable = this.sideProperties.pluggables[pipeWire.ordinal()];
            this.renderState.plugMatrix.setConnected((ForgeDirection)pipeWire, pluggable instanceof ItemPlug.PlugPluggable);
            if (pluggable instanceof ItemRobotStation.RobotStationPluggable) {
                DockingStation station = ((ItemRobotStation.RobotStationPluggable)pluggable).getStation();
                if (station.isTaken()) {
                    if (station.isMainStation()) {
                        this.renderState.robotStationMatrix.setState((ForgeDirection)pipeWire, RobotStationState.Linked);
                        continue;
                    }
                    this.renderState.robotStationMatrix.setState((ForgeDirection)pipeWire, RobotStationState.Reserved);
                    continue;
                }
                this.renderState.robotStationMatrix.setState((ForgeDirection)pipeWire, RobotStationState.Available);
                continue;
            }
            this.renderState.robotStationMatrix.setState((ForgeDirection)pipeWire, RobotStationState.None);
        }
        if (this.renderState.isDirty()) {
            this.renderState.clean();
            this.sendUpdateToClient();
        }
    }

    public void initialize(Pipe<?> pipe) {
        this.field_145854_h = this.func_145838_q();
        if (pipe == null) {
            BCLog.logger.log(Level.WARN, "Pipe failed to initialize at {0},{1},{2}, deleting", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        this.pipe = pipe;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.getTile(o);
            if (tile instanceof ITileBufferHolder) {
                ((ITileBufferHolder)tile).blockCreated(o, (Block)BuildCraftTransport.genericPipeBlock, this);
            }
            if (!(tile instanceof TileGenericPipe)) continue;
            ((TileGenericPipe)tile).scheduleNeighborChange();
        }
        this.bindPipe();
        this.computeConnections();
        this.scheduleNeighborChange();
        this.scheduleRenderUpdate();
        if (pipe.needsInit()) {
            pipe.initialize();
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.coreState.pipeId = Item.func_150891_b((Item)this.pipe.item);
            this.pipeBound = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void scheduleNeighborChange() {
        this.blockNeighborChange = true;
    }

    @Override
    public int injectItem(ItemStack payload, boolean doAdd, ForgeDirection from, EnumColor color) {
        if (!this.pipe.inputOpen(from)) {
            return 0;
        }
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof PipeTransportItems && this.isPipeConnected(from)) {
            if (doAdd) {
                Position itemPos = new Position((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, from.getOpposite());
                itemPos.moveBackwards(0.4);
                TravelingItem pipedItem = TravelingItem.make(itemPos.x, itemPos.y, itemPos.z, payload);
                pipedItem.color = color;
                ((PipeTransportItems)this.pipe.transport).injectItem(pipedItem, itemPos.orientation);
            }
            return payload.field_77994_a;
        }
        return 0;
    }

    @Override
    public int injectItem(ItemStack payload, boolean doAdd, ForgeDirection from) {
        return this.injectItem(payload, doAdd, from, null);
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return ((PipeTransport)this.pipe.transport).getPipeType();
        }
        return null;
    }

    public BuildCraftPacket getBCDescriptionPacket() {
        this.bindPipe();
        this.updateCoreState();
        PacketTileState packet = new PacketTileState(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.pipe != null && this.pipe.transport != null) {
            ((PipeTransport)this.pipe.transport).sendDescriptionPacket();
        }
        packet.addStateForSerialization((byte)0, this.coreState);
        packet.addStateForSerialization((byte)1, this.renderState);
        if (this.pipe instanceof IClientState) {
            packet.addStateForSerialization((byte)2, (IClientState)((Object)this.pipe));
        }
        return packet;
    }

    public Packet func_145844_m() {
        return Utils.toPacket(this.getBCDescriptionPacket(), 1);
    }

    public void sendUpdateToClient() {
        this.sendClientUpdate = true;
    }

    @Override
    public void blockRemoved(ForgeDirection from) {
    }

    public TileBuffer[] getTileCache() {
        if (this.tileBuffer == null && this.pipe != null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((PipeTransport)this.pipe.transport).delveIntoUnloadedChunks());
        }
        return this.tileBuffer;
    }

    @Override
    public void blockCreated(ForgeDirection from, Block block, TileEntity tile) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            cache[from.getOpposite().ordinal()].set(block, tile);
        }
    }

    @Override
    public Block getBlock(ForgeDirection to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getBlock();
        }
        return null;
    }

    @Override
    public TileEntity getTile(ForgeDirection to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getTile();
        }
        return null;
    }

    protected boolean canPipeConnect_internal(TileEntity with, ForgeDirection side) {
        IPipeConnection.ConnectOverride override;
        if (!(this.pipe instanceof IPipeConnectionForced && ((IPipeConnectionForced)((Object)this.pipe)).ignoreConnectionOverrides(side) || !(with instanceof IPipeConnection) || (override = ((IPipeConnection)with).overridePipeConnection(((PipeTransport)this.pipe.transport).getPipeType(), side.getOpposite())) == IPipeConnection.ConnectOverride.DEFAULT)) {
            return override == IPipeConnection.ConnectOverride.CONNECT;
        }
        if (with instanceof TileGenericPipe) {
            TileGenericPipe other = (TileGenericPipe)with;
            if (other.hasBlockingPluggable(side.getOpposite())) {
                return false;
            }
            if (other.glassColor >= 0 && this.glassColor >= 0 && other.glassColor != this.glassColor) {
                return false;
            }
            Pipe otherPipe = ((TileGenericPipe)with).pipe;
            if (!BlockGenericPipe.isValid(otherPipe)) {
                return false;
            }
            if (!otherPipe.canPipeConnect(this, side.getOpposite())) {
                return false;
            }
        }
        return this.pipe.canPipeConnect(with, side);
    }

    protected boolean canPipeConnect(TileEntity with, ForgeDirection side) {
        if (with == null) {
            return false;
        }
        if (this.hasBlockingPluggable(side)) {
            return false;
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return false;
        }
        return this.canPipeConnect_internal(with, side);
    }

    protected boolean hasBlockingPluggable(ForgeDirection side) {
        IPipePluggable pluggable = this.sideProperties.pluggables[side.ordinal()];
        return pluggable != null && pluggable.blocking(this, side);
    }

    private void computeConnections() {
        TileBuffer[] cache = this.getTileCache();
        if (cache == null) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileBuffer t = cache[side.ordinal()];
            t.refresh();
            this.pipeConnectionsBuffer[side.ordinal()] = this.canPipeConnect(t.getTile(), side);
        }
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        if (this.field_145850_b.field_72995_K) {
            return this.renderState.pipeConnectionMatrix.isConnected(with);
        }
        return this.pipeConnectionsBuffer[with.ordinal()];
    }

    @Override
    public boolean doDrop() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.doDrop();
        }
        return false;
    }

    public void onChunkUnload() {
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from) && !this.hasRobotStation(from)) {
            return ((IFluidHandler)this.pipe.transport).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from) && !this.hasRobotStation(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from) && !this.hasRobotStation(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, resource, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from) && !this.hasRobotStation(from)) {
            return ((IFluidHandler)this.pipe.transport).canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from) && !this.hasRobotStation(from)) {
            return ((IFluidHandler)this.pipe.transport).canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    public boolean addFacade(ForgeDirection direction, ItemFacade.FacadeState[] states) {
        return this.setPluggable(direction, new ItemFacade.FacadePluggable(states));
    }

    public boolean addPlug(ForgeDirection direction) {
        return this.setPluggable(direction, new ItemPlug.PlugPluggable());
    }

    public boolean addRobotStation(ForgeDirection direction) {
        return this.setPluggable(direction, new ItemRobotStation.RobotStationPluggable());
    }

    public boolean addGate(ForgeDirection direction, Gate gate) {
        gate.setDirection(direction);
        this.pipe.gates[direction.ordinal()] = gate;
        return this.setPluggable(direction, new ItemGate.GatePluggable(gate));
    }

    public boolean hasFacade(ForgeDirection direction) {
        if (direction == null || direction == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.func_145831_w().field_72995_K) {
            return this.renderState.facadeMatrix.getFacadeBlock(direction) != null;
        }
        return this.sideProperties.pluggables[direction.ordinal()] instanceof ItemFacade.FacadePluggable;
    }

    public boolean hasGate(ForgeDirection direction) {
        if (direction == null || direction == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.func_145831_w().field_72995_K) {
            return this.renderState.gateMatrix.isGateExists(direction);
        }
        return this.sideProperties.pluggables[direction.ordinal()] instanceof ItemGate.GatePluggable;
    }

    public boolean setPluggable(ForgeDirection direction, IPipePluggable pluggable) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K || pluggable == null) {
            return false;
        }
        this.sideProperties.dropItem(this, direction);
        this.sideProperties.pluggables[direction.ordinal()] = pluggable;
        pluggable.onAttachedPipe(this, direction);
        this.notifyBlockChanged();
        return true;
    }

    private void updateCoreState() {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            IPipePluggable pluggable = this.sideProperties.pluggables[i];
            this.coreState.gates[i] = pluggable instanceof ItemGate.GatePluggable ? (ItemGate.GatePluggable)pluggable : null;
        }
    }

    public boolean hasEnabledFacade(ForgeDirection direction) {
        return this.hasFacade(direction) && !this.renderState.facadeMatrix.getFacadeTransparent(direction);
    }

    public ItemStack getFacade(ForgeDirection direction) {
        IPipePluggable pluggable = this.sideProperties.pluggables[direction.ordinal()];
        return pluggable instanceof ItemFacade.FacadePluggable ? ItemFacade.getFacade(((ItemFacade.FacadePluggable)pluggable).states) : null;
    }

    public DockingStation getStation(ForgeDirection direction) {
        IPipePluggable pluggable = this.sideProperties.pluggables[direction.ordinal()];
        return pluggable instanceof ItemRobotStation.RobotStationPluggable ? ((ItemRobotStation.RobotStationPluggable)pluggable).getStation() : null;
    }

    public void setGate(Gate gate, int direction) {
        if (this.sideProperties.pluggables[direction] == null) {
            gate.setDirection(ForgeDirection.getOrientation((int)direction));
            this.pipe.gates[direction] = gate;
            this.sideProperties.pluggables[direction] = new ItemGate.GatePluggable(gate);
        }
    }

    public boolean dropSideItems(ForgeDirection direction) {
        return this.sideProperties.dropItem(this, direction);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getPipeIcons() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getIconProvider();
    }

    @Override
    public IClientState getStateInstance(byte stateId) {
        switch (stateId) {
            case 0: {
                return this.coreState;
            }
            case 1: {
                return this.renderState;
            }
            case 2: {
                return (IClientState)((Object)this.pipe);
            }
        }
        throw new RuntimeException("Unknown state requested: " + stateId + " this is a bug!");
    }

    @Override
    public void afterStateUpdated(byte stateId) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        switch (stateId) {
            case 0: {
                if (this.pipe == null && this.coreState.pipeId != 0) {
                    this.initialize(BlockGenericPipe.createPipe((Item)Item.field_150901_e.func_148754_a(this.coreState.pipeId)));
                }
                if (this.pipe == null) break;
                for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                    ItemGate.GatePluggable gatePluggable = this.coreState.gates[i];
                    if (gatePluggable == null) {
                        this.pipe.gates[i] = null;
                        continue;
                    }
                    Gate gate = this.pipe.gates[i];
                    if (gate != null && gate.logic == gatePluggable.logic && gate.material == gatePluggable.material) continue;
                    this.pipe.gates[i] = GateFactory.makeGate(this.pipe, gatePluggable.material, gatePluggable.logic, ForgeDirection.getOrientation((int)i));
                }
                this.syncGateExpansions();
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 1: {
                if (!this.renderState.needsRenderUpdate()) break;
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.renderState.clean();
            }
        }
    }

    private void syncGateExpansions() {
        this.resyncGateExpansions = false;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            Gate gate = this.pipe.gates[i];
            ItemGate.GatePluggable gatePluggable = this.coreState.gates[i];
            if (gate == null || gatePluggable.expansions.length <= 0) continue;
            for (IGateExpansion expansion : gatePluggable.expansions) {
                if (expansion != null) {
                    if (gate.expansions.containsKey((Object)expansion)) continue;
                    gate.addGateExpansion(expansion);
                    continue;
                }
                this.resyncGateExpansions = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return DefaultProps.PIPE_CONTENTS_RENDER_DIST * DefaultProps.PIPE_CONTENTS_RENDER_DIST;
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        if (this.hasFacade(side)) {
            return true;
        }
        return BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof ISolidSideTile && ((ISolidSideTile)((Object)this.pipe)).isSolidOnSide(side);
    }

    public boolean hasPlug(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return this.renderState.plugMatrix.isConnected(side);
        }
        return this.sideProperties.pluggables[side.ordinal()] instanceof ItemPlug.PlugPluggable;
    }

    public boolean hasRobotStation(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return this.renderState.robotStationMatrix.isConnected(side);
        }
        return this.sideProperties.pluggables[side.ordinal()] instanceof ItemRobotStation.RobotStationPluggable;
    }

    public Block getBlock() {
        return this.func_145838_q();
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public void writeGuiData(ByteBuf data) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.pipe)).writeGuiData(data);
        }
    }

    @Override
    public void readGuiData(ByteBuf data, EntityPlayer sender) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.pipe)).readGuiData(data, sender);
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            return ((IPowerReceptor)((Object)this.pipe)).getPowerReceiver(null);
        }
        return null;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            ((IPowerReceptor)((Object)this.pipe)).doWork(workProvider);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        if (this.pipe instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.pipe)).canConnectEnergy(from);
        }
        return false;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.pipe instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.pipe)).receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.pipe instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.pipe)).extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.pipe instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.pipe)).getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.pipe instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.pipe)).getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public TileEntity getAdjacentTile(ForgeDirection dir) {
        return this.getTile(dir);
    }

    @Override
    public IPipe getPipe() {
        return this.pipe;
    }

    public static class SideProperties {
        IPipePluggable[] pluggables = new IPipePluggable[ForgeDirection.VALID_DIRECTIONS.length];

        public void writeToNBT(NBTTagCompound nbt) {
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                IPipePluggable pluggable = this.pluggables[i];
                String key = "pluggable[" + i + "]";
                if (pluggable == null) {
                    nbt.func_82580_o(key);
                    continue;
                }
                NBTTagCompound pluggableData = new NBTTagCompound();
                pluggableData.func_74778_a("pluggableClass", pluggable.getClass().getName());
                pluggable.writeToNBT(pluggableData);
                nbt.func_74782_a(key, (NBTBase)pluggableData);
            }
        }

        public void readFromNBT(NBTTagCompound nbt) {
            int i;
            for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                String key = "pluggable[" + i + "]";
                if (!nbt.func_74764_b(key)) continue;
                try {
                    NBTTagCompound pluggableData = nbt.func_74775_l(key);
                    Class<?> pluggableClass = Class.forName(pluggableData.func_74779_i("pluggableClass"));
                    if (!IPipePluggable.class.isAssignableFrom(pluggableClass)) {
                        BCLog.logger.warn("Wrong pluggable class: " + pluggableClass);
                        continue;
                    }
                    IPipePluggable pluggable = (IPipePluggable)pluggableClass.newInstance();
                    pluggable.readFromNBT(pluggableData);
                    this.pluggables[i] = pluggable;
                    continue;
                }
                catch (Exception e) {
                    BCLog.logger.warn("Failed to load side state");
                    e.printStackTrace();
                }
            }
            for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                IPipePluggable pluggable = null;
                if (nbt.func_74764_b("facadeState[" + i + "]")) {
                    pluggable = new ItemFacade.FacadePluggable(ItemFacade.FacadeState.readArray(nbt.func_150295_c("facadeState[" + i + "]", 10)));
                } else if (nbt.func_74764_b("facadeBlocks[" + i + "]")) {
                    Block block = (Block)Block.field_149771_c.func_148754_a(nbt.func_74762_e("facadeBlocks[" + i + "]"));
                    int blockId = nbt.func_74762_e("facadeBlocks[" + i + "]");
                    if (blockId != 0) {
                        int metadata = nbt.func_74762_e("facadeMeta[" + i + "]");
                        pluggable = new ItemFacade.FacadePluggable(new ItemFacade.FacadeState[]{ItemFacade.FacadeState.create(block, metadata)});
                    }
                } else if (nbt.func_74764_b("facadeBlocksStr[" + i + "][0]")) {
                    ItemFacade.FacadeState mainState = ItemFacade.FacadeState.create((Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("facadeBlocksStr[" + i + "][0]")), nbt.func_74762_e("facadeMeta[" + i + "][0]"));
                    if (nbt.func_74764_b("facadeBlocksStr[" + i + "][1]")) {
                        ItemFacade.FacadeState phasedState = ItemFacade.FacadeState.create((Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("facadeBlocksStr[" + i + "][1]")), nbt.func_74762_e("facadeMeta[" + i + "][1]"), PipeWire.fromOrdinal(nbt.func_74762_e("facadeWires[" + i + "]")));
                        pluggable = new ItemFacade.FacadePluggable(new ItemFacade.FacadeState[]{mainState, phasedState});
                    } else {
                        pluggable = new ItemFacade.FacadePluggable(new ItemFacade.FacadeState[]{mainState});
                    }
                }
                if (nbt.func_74767_n("plug[" + i + "]")) {
                    pluggable = new ItemPlug.PlugPluggable();
                }
                if (nbt.func_74767_n("robotStation[" + i + "]")) {
                    pluggable = new ItemRobotStation.RobotStationPluggable();
                }
                if (pluggable == null) continue;
                this.pluggables[i] = pluggable;
            }
        }

        public void rotateLeft() {
            IPipePluggable[] newPluggables = new IPipePluggable[ForgeDirection.VALID_DIRECTIONS.length];
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                newPluggables[dir.getRotation((ForgeDirection)ForgeDirection.UP).ordinal()] = this.pluggables[dir.ordinal()];
            }
            this.pluggables = newPluggables;
        }

        public boolean dropItem(TileGenericPipe pipe, ForgeDirection direction) {
            boolean result = false;
            IPipePluggable pluggable = this.pluggables[direction.ordinal()];
            if (pluggable != null) {
                pluggable.onDetachedPipe(pipe, direction);
                ItemStack[] stacks = pluggable.getDropItems(pipe);
                if (stacks != null) {
                    for (ItemStack stack : stacks) {
                        InvUtils.dropItems(pipe.field_145850_b, stack, pipe.field_145851_c, pipe.field_145848_d, pipe.field_145849_e);
                    }
                }
                result = true;
            }
            this.pluggables[direction.ordinal()] = null;
            pipe.notifyBlockChanged();
            return result;
        }

        public void invalidate() {
            for (IPipePluggable p : this.pluggables) {
                if (p == null) continue;
                p.invalidate();
            }
        }

        public void validate(TileGenericPipe pipe) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IPipePluggable p = this.pluggables[d.ordinal()];
                if (p == null) continue;
                p.validate(pipe, d);
            }
        }
    }

    public static class CoreState
    implements IClientState {
        public int pipeId = -1;
        public ItemGate.GatePluggable[] gates = new ItemGate.GatePluggable[ForgeDirection.VALID_DIRECTIONS.length];

        @Override
        public void writeData(ByteBuf data) {
            data.writeInt(this.pipeId);
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                ItemGate.GatePluggable gate = this.gates[i];
                boolean gateValid = gate != null;
                data.writeBoolean(gateValid);
                if (!gateValid) continue;
                gate.writeToByteBuf(data);
            }
        }

        @Override
        public void readData(ByteBuf data) {
            this.pipeId = data.readInt();
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                if (data.readBoolean()) {
                    ItemGate.GatePluggable gate = this.gates[i];
                    if (gate == null) {
                        this.gates[i] = gate = new ItemGate.GatePluggable();
                    }
                    gate.readFromByteBuf(data);
                    continue;
                }
                this.gates[i] = null;
            }
        }
    }
}

