/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.StatementSlot;
import java.util.Iterator;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionIterator
implements Iterable<StatementSlot> {
    private Pipe pipe;

    public ActionIterator(Pipe iPipe) {
        this.pipe = iPipe;
    }

    @Override
    public Iterator<StatementSlot> iterator() {
        return new It();
    }

    private class It
    implements Iterator<StatementSlot> {
        private ForgeDirection curDir = ForgeDirection.values()[0];
        private int index = 0;
        private StatementSlot next;

        public It() {
            while (!this.isValid() && this.curDir != ForgeDirection.UNKNOWN) {
                if (((ActionIterator)ActionIterator.this).pipe.gates[this.curDir.ordinal()] == null || this.index >= ((ActionIterator)ActionIterator.this).pipe.gates[this.curDir.ordinal()].activeActions.size() - 1) {
                    this.index = 0;
                    this.curDir = ForgeDirection.values()[this.curDir.ordinal() + 1];
                    continue;
                }
                ++this.index;
            }
            if (this.isValid()) {
                this.next = ((ActionIterator)ActionIterator.this).pipe.gates[this.curDir.ordinal()].activeActions.get(this.index);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public StatementSlot next() {
            StatementSlot result = this.next;
            do {
                if (this.index < Gate.MAX_STATEMENTS - 1) {
                    ++this.index;
                    continue;
                }
                if (this.curDir == ForgeDirection.UNKNOWN) break;
                this.index = 0;
                this.curDir = ForgeDirection.values()[this.curDir.ordinal() + 1];
            } while (!this.isValid());
            if (this.isValid()) {
                this.next = new StatementSlot();
                this.next.statement = ((ActionIterator)ActionIterator.this).pipe.gates[this.curDir.ordinal()].actions[this.index];
                this.next.parameters = ((ActionIterator)ActionIterator.this).pipe.gates[this.curDir.ordinal()].actionParameters[this.index];
            } else {
                this.next = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }

        private boolean isValid() {
            return this.curDir != ForgeDirection.UNKNOWN && ((ActionIterator)ActionIterator.this).pipe.gates[this.curDir.ordinal()] != null && this.index < ((ActionIterator)ActionIterator.this).pipe.gates[this.curDir.ordinal()].activeActions.size();
        }
    }
}

