/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.transport.IPipePluggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Gate;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateFactory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemGate
extends ItemBuildCraft {
    private static final String NBT_TAG_MAT = "mat";
    private static final String NBT_TAG_LOGIC = "logic";
    private static final String NBT_TAG_EX = "ex";

    public ItemGate() {
        this.func_77627_a(false);
        this.func_77656_e(0);
        this.setPassSneakClick(true);
    }

    private static NBTTagCompound getNBT(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemGate)) {
            return null;
        }
        return InvUtils.getItemData(stack);
    }

    public static void setMaterial(ItemStack stack, GateDefinition.GateMaterial material) {
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.func_74774_a(NBT_TAG_MAT, (byte)material.ordinal());
    }

    public static GateDefinition.GateMaterial getMaterial(ItemStack stack) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return GateDefinition.GateMaterial.REDSTONE;
        }
        return GateDefinition.GateMaterial.fromOrdinal(nbt.func_74771_c(NBT_TAG_MAT));
    }

    public static GateDefinition.GateLogic getLogic(ItemStack stack) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return GateDefinition.GateLogic.AND;
        }
        return GateDefinition.GateLogic.fromOrdinal(nbt.func_74771_c(NBT_TAG_LOGIC));
    }

    public static void setLogic(ItemStack stack, GateDefinition.GateLogic logic) {
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.func_74774_a(NBT_TAG_LOGIC, (byte)logic.ordinal());
    }

    public static void addGateExpansion(ItemStack stack, IGateExpansion expansion) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return;
        }
        NBTTagList expansionList = nbt.func_150295_c(NBT_TAG_EX, 8);
        expansionList.func_74742_a((NBTBase)new NBTTagString(expansion.getUniqueIdentifier()));
        nbt.func_74782_a(NBT_TAG_EX, (NBTBase)expansionList);
    }

    public static boolean hasGateExpansion(ItemStack stack, IGateExpansion expansion) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return false;
        }
        try {
            NBTTagList expansionList = nbt.func_150295_c(NBT_TAG_EX, 8);
            for (int i = 0; i < expansionList.func_74745_c(); ++i) {
                String ex = expansionList.func_150307_f(i);
                if (!ex.equals(expansion.getUniqueIdentifier())) continue;
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    public static Set<IGateExpansion> getInstalledExpansions(ItemStack stack) {
        HashSet<IGateExpansion> expansions = new HashSet<IGateExpansion>();
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return expansions;
        }
        try {
            NBTTagList expansionList = nbt.func_150295_c(NBT_TAG_EX, 8);
            for (int i = 0; i < expansionList.func_74745_c(); ++i) {
                String exTag = expansionList.func_150307_f(i);
                IGateExpansion ex = GateExpansions.getExpansion(exTag);
                if (ex == null) continue;
                expansions.add(ex);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return expansions;
    }

    public static ItemStack makeGateItem(GateDefinition.GateMaterial material, GateDefinition.GateLogic logic) {
        ItemStack stack = new ItemStack(BuildCraftTransport.pipeGate);
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.func_74774_a(NBT_TAG_MAT, (byte)material.ordinal());
        nbt.func_74774_a(NBT_TAG_LOGIC, (byte)logic.ordinal());
        return stack;
    }

    public static ItemStack makeGateItem(Gate gate) {
        ItemStack stack = new ItemStack(BuildCraftTransport.pipeGate);
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.func_74774_a(NBT_TAG_MAT, (byte)gate.material.ordinal());
        nbt.func_74774_a(NBT_TAG_LOGIC, (byte)gate.logic.ordinal());
        for (IGateExpansion expansion : gate.expansions.keySet()) {
            ItemGate.addGateExpansion(stack, expansion);
        }
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return GateDefinition.getLocalizedName(ItemGate.getMaterial(stack), ItemGate.getLogic(stack));
    }

    public String func_77653_i(ItemStack stack) {
        return ("" + StatCollector.func_74838_a((String)this.func_77657_g(stack))).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        for (GateDefinition.GateMaterial material : GateDefinition.GateMaterial.VALUES) {
            for (GateDefinition.GateLogic logic : GateDefinition.GateLogic.VALUES) {
                if (material == GateDefinition.GateMaterial.REDSTONE && logic == GateDefinition.GateLogic.OR) continue;
                itemList.add(ItemGate.makeGateItem(material, logic));
                for (IGateExpansion exp : GateExpansions.getExpansions()) {
                    ItemStack stackExpansion = ItemGate.makeGateItem(material, logic);
                    ItemGate.addGateExpansion(stackExpansion, exp);
                    itemList.add(stackExpansion);
                }
            }
        }
    }

    public static ItemStack[] getGateVarients() {
        ArrayList<ItemStack> gates = new ArrayList<ItemStack>();
        for (GateDefinition.GateMaterial material : GateDefinition.GateMaterial.VALUES) {
            for (GateDefinition.GateLogic logic : GateDefinition.GateLogic.VALUES) {
                if (material == GateDefinition.GateMaterial.REDSTONE && logic == GateDefinition.GateLogic.OR) continue;
                gates.add(ItemGate.makeGateItem(material, logic));
            }
        }
        return gates.toArray(new ItemStack[gates.size()]);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        super.func_77624_a(stack, player, list, adv);
        list.add(StringUtils.localize("tip.gate.wires"));
        list.add(StringUtils.localize("tip.gate.wires." + ItemGate.getMaterial(stack).getTag()));
        Set<IGateExpansion> expansions = ItemGate.getInstalledExpansions(stack);
        if (!expansions.isEmpty()) {
            list.add(StringUtils.localize("tip.gate.expansions"));
            for (IGateExpansion expansion : expansions) {
                list.add(expansion.getDisplayName());
            }
        }
    }

    public IIcon func_77650_f(ItemStack stack) {
        return ItemGate.getLogic(stack).getIconItem();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (GateDefinition.GateMaterial gateMaterial : GateDefinition.GateMaterial.VALUES) {
            gateMaterial.registerItemIcon(iconRegister);
        }
        for (Enum enum_ : GateDefinition.GateLogic.VALUES) {
            ((GateDefinition.GateLogic)enum_).registerItemIcon(iconRegister);
        }
        for (IGateExpansion expansion : GateExpansions.getExpansions()) {
            expansion.registerItemOverlay(iconRegister);
        }
        StatementManager.registerIcons(iconRegister);
    }

    public static class GatePluggable
    implements IPipePluggable {
        public GateDefinition.GateMaterial material;
        public GateDefinition.GateLogic logic;
        public IGateExpansion[] expansions;

        public GatePluggable() {
        }

        public GatePluggable(Gate gate) {
            this.material = gate.material;
            this.logic = gate.logic;
            Set gateExpansions = gate.expansions.keySet();
            this.expansions = gateExpansions.toArray(new IGateExpansion[gateExpansions.size()]);
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74774_a(ItemGate.NBT_TAG_MAT, (byte)this.material.ordinal());
            nbt.func_74774_a(ItemGate.NBT_TAG_LOGIC, (byte)this.logic.ordinal());
            NBTTagList expansionsList = nbt.func_150295_c(ItemGate.NBT_TAG_EX, 8);
            for (IGateExpansion expansion : this.expansions) {
                expansionsList.func_74742_a((NBTBase)new NBTTagString(expansion.getUniqueIdentifier()));
            }
            nbt.func_74782_a(ItemGate.NBT_TAG_EX, (NBTBase)expansionsList);
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.material = GateDefinition.GateMaterial.fromOrdinal(nbt.func_74771_c(ItemGate.NBT_TAG_MAT));
            this.logic = GateDefinition.GateLogic.fromOrdinal(nbt.func_74771_c(ItemGate.NBT_TAG_LOGIC));
            NBTTagList expansionsList = nbt.func_150295_c(ItemGate.NBT_TAG_EX, 8);
            int expansionsSize = expansionsList.func_74745_c();
            this.expansions = new IGateExpansion[expansionsSize];
            for (int i = 0; i < expansionsSize; ++i) {
                this.expansions[i] = GateExpansions.getExpansion(expansionsList.func_150307_f(i));
            }
        }

        public void writeToByteBuf(ByteBuf buf) {
            buf.writeByte(this.material.ordinal());
            buf.writeByte(this.logic.ordinal());
            int expansionsSize = this.expansions.length;
            buf.writeInt(expansionsSize);
            for (IGateExpansion expansion : this.expansions) {
                buf.writeShort(GateExpansions.getExpansionID(expansion));
            }
        }

        public void readFromByteBuf(ByteBuf buf) {
            this.material = GateDefinition.GateMaterial.fromOrdinal(buf.readByte());
            this.logic = GateDefinition.GateLogic.fromOrdinal(buf.readByte());
            int expansionsSize = buf.readInt();
            this.expansions = new IGateExpansion[expansionsSize];
            for (int i = 0; i < expansionsSize; ++i) {
                this.expansions[i] = GateExpansions.getExpansionByID(buf.readUnsignedShort());
            }
        }

        @Override
        public ItemStack[] getDropItems(IPipeTile pipe) {
            ItemStack gate = ItemGate.makeGateItem(this.material, this.logic);
            for (IGateExpansion expansion : this.expansions) {
                ItemGate.addGateExpansion(gate, expansion);
            }
            return new ItemStack[]{gate};
        }

        @Override
        public void onAttachedPipe(IPipeTile pipe, ForgeDirection direction) {
            Gate gate;
            TileGenericPipe pipeReal = (TileGenericPipe)pipe;
            if (!(pipeReal.getWorld().field_72995_K || (gate = pipeReal.pipe.gates[direction.ordinal()]) != null && gate.material == this.material && gate.logic == this.logic)) {
                pipeReal.pipe.gates[direction.ordinal()] = GateFactory.makeGate(pipeReal.pipe, this.material, this.logic, direction);
                pipeReal.scheduleRenderUpdate();
            }
        }

        @Override
        public void onDetachedPipe(IPipeTile pipe, ForgeDirection direction) {
            TileGenericPipe pipeReal = (TileGenericPipe)pipe;
            if (!pipeReal.getWorld().field_72995_K) {
                Gate gate = pipeReal.pipe.gates[direction.ordinal()];
                if (gate != null) {
                    gate.resetGate();
                    pipeReal.pipe.gates[direction.ordinal()] = null;
                }
                pipeReal.scheduleRenderUpdate();
            }
        }

        @Override
        public boolean blocking(IPipeTile pipe, ForgeDirection direction) {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof GatePluggable)) {
                return false;
            }
            GatePluggable o = (GatePluggable)obj;
            if (o.material.ordinal() != this.material.ordinal()) {
                return false;
            }
            if (o.logic.ordinal() != this.logic.ordinal()) {
                return false;
            }
            if (o.expansions.length != this.expansions.length) {
                return false;
            }
            for (int i = 0; i < this.expansions.length; ++i) {
                if (o.expansions[i] == this.expansions[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate(IPipeTile pipe, ForgeDirection direction) {
        }
    }
}

