/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.RPCSide;
import buildcraft.transport.ActionActiveState;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gui.GuiGateInterface;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;

public class ContainerGateInterface
extends BuildCraftContainer {
    public ActionActiveState[] actionsState = new ActionActiveState[8];
    public GuiGateInterface gateCallback;
    IInventory playerIInventory;
    private final Pipe<?> pipe;
    private Gate gate;
    private final NavigableSet<IStatement> potentialTriggers = new TreeSet<IStatement>(new Comparator<IStatement>(){

        @Override
        public int compare(IStatement o1, IStatement o2) {
            return o1.getUniqueTag().compareTo(o2.getUniqueTag());
        }
    });
    private final NavigableSet<IStatement> potentialActions = new TreeSet<IStatement>(new Comparator<IStatement>(){

        @Override
        public int compare(IStatement o1, IStatement o2) {
            return o1.getUniqueTag().compareTo(o2.getUniqueTag());
        }
    });
    private boolean isSynchronized = false;
    private boolean isNetInitialized = false;
    private int lastTriggerState = 0;

    public ContainerGateInterface(IInventory playerInventory, Pipe<?> pipe) {
        super(0);
        for (int i = 0; i < this.actionsState.length; ++i) {
            this.actionsState[i] = ActionActiveState.Deactivated;
        }
        this.pipe = pipe;
        this.playerIInventory = playerInventory;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(this.playerIInventory, x + y * 9 + 9, 8 + x * 18, 0));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot(this.playerIInventory, x, 8 + x * 18, 0));
        }
    }

    public void init() {
        if (this.gate == null) {
            return;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75139_a((int)(x + y * 9)).field_75221_f = this.gate.material.guiHeight - 84 + y * 18;
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75139_a((int)(x + 27)).field_75221_f = this.gate.material.guiHeight - 26;
        }
        if (!this.pipe.container.func_145831_w().field_72995_K) {
            this.potentialTriggers.addAll(this.gate.getAllValidTriggers());
            this.potentialActions.addAll(this.gate.getAllValidActions());
            Iterator<IStatement> it = this.potentialTriggers.iterator();
            while (it.hasNext()) {
                IStatement trigger = it.next();
                if (trigger.minParameters() <= this.gate.material.numTriggerParameters) continue;
                it.remove();
            }
            it = this.potentialActions.iterator();
            while (it.hasNext()) {
                IStatement action = it.next();
                if (action.minParameters() <= this.gate.material.numActionParameters) continue;
                it.remove();
            }
        }
        if (this.gateCallback != null) {
            this.gateCallback.setGate(this.gate);
        }
    }

    private static <T extends IStatement> String[] statementsToStrings(Collection<T> statements) {
        int size = statements.size();
        String[] array = new String[size];
        int pos = 0;
        for (IStatement statement : statements) {
            array[pos++] = statement.getUniqueTag();
        }
        return array;
    }

    private static <T extends IStatement> void stringsToStatements(Collection<T> statements, String[] strings) {
        statements.clear();
        for (String id : strings) {
            statements.add(StatementManager.statements.get(id));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.gate != null;
    }

    public void markDirty() {
        this.isSynchronized = false;
    }

    public void synchronize() {
        if (!this.isNetInitialized && this.pipe.container.func_145831_w().field_72995_K) {
            this.isNetInitialized = true;
            RPCHandler.rpcServer((Object)this, "initRequest", new Object[0]);
        }
        if (!this.isSynchronized && this.pipe.container.func_145831_w().field_72995_K && this.gate != null) {
            this.isSynchronized = true;
            RPCHandler.rpcServer((Object)this, "selectionRequest", new Object[0]);
        }
    }

    public void func_75137_b(int id, int state) {
        if (id == 0) {
            for (int i = 0; i < 8; ++i) {
                this.actionsState[i] = ActionActiveState.values()[state >> i * 2 & 3];
            }
        }
    }

    private int calculateTriggerState() {
        if (this.gate == null) {
            return 0;
        }
        int state = 0;
        for (int i = 0; i < this.actionsState.length; ++i) {
            this.actionsState[i] = this.getActionState(i);
            state |= (this.actionsState[i].ordinal() & 3) << i * 2;
        }
        return state;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        int state = this.calculateTriggerState();
        if (state != this.lastTriggerState) {
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                ICrafting viewingPlayer = (ICrafting)this.field_75149_d.get(i);
                viewingPlayer.func_71112_a((Container)this, 0, state);
            }
            this.lastTriggerState = state;
        }
    }

    @RPC(value=RPCSide.SERVER)
    public void initRequest(RPCMessageInfo info) {
        EntityPlayer player = info.sender;
        RPCHandler.rpcPlayer(player, (Object)this, "setGate", this.gate.getDirection().ordinal());
        RPCHandler.rpcPlayer(player, (Object)this, "setPotential", ContainerGateInterface.statementsToStrings(this.potentialActions), ContainerGateInterface.statementsToStrings(this.potentialTriggers));
    }

    @RPC(value=RPCSide.CLIENT)
    public void setPotential(String[] potentialActions, String[] potentialTriggers) {
        ContainerGateInterface.stringsToStatements(this.potentialActions, potentialActions);
        ContainerGateInterface.stringsToStatements(this.potentialTriggers, potentialTriggers);
    }

    @RPC(value=RPCSide.CLIENT)
    public void setGate(int direction) {
        this.gate = this.pipe.gates[direction];
        this.init();
    }

    @RPC(value=RPCSide.SERVER)
    public void selectionRequest(RPCMessageInfo info) {
        EntityPlayer player = info.sender;
        for (int position = 0; position < this.gate.material.numSlots; ++position) {
            IStatement action = this.gate.getAction(position);
            IStatement trigger = this.gate.getTrigger(position);
            RPCHandler.rpcPlayer(player, (Object)this, "setAction", position, action != null ? action.getUniqueTag() : null, false);
            RPCHandler.rpcPlayer(player, (Object)this, "setTrigger", position, trigger != null ? trigger.getUniqueTag() : null, false);
            for (int p = 0; p < this.gate.material.numActionParameters; ++p) {
                RPCHandler.rpcPlayer(player, (Object)this, "setActionParameter", position, p, this.gate.getActionParameter(position, p), false);
            }
            for (int q = 0; q < this.gate.material.numTriggerParameters; ++q) {
                RPCHandler.rpcPlayer(player, (Object)this, "setTriggerParameter", position, q, this.gate.getTriggerParameter(position, q), false);
            }
        }
    }

    public boolean hasTriggers() {
        return this.potentialTriggers.size() > 0;
    }

    public IStatement getFirstTrigger() {
        if (this.potentialTriggers.isEmpty()) {
            return null;
        }
        return (IStatement)this.potentialTriggers.first();
    }

    public IStatement getLastTrigger() {
        if (this.potentialTriggers.isEmpty()) {
            return null;
        }
        return (IStatement)this.potentialTriggers.last();
    }

    public Iterator<IStatement> getTriggerIterator(boolean descending) {
        return descending ? this.potentialTriggers.descendingIterator() : this.potentialTriggers.iterator();
    }

    public ActionActiveState getActionState(int i) {
        if (this.gate == null) {
            return ActionActiveState.Deactivated;
        }
        return this.gate.actionsState[i];
    }

    @RPC(value=RPCSide.BOTH)
    public void setTrigger(int trigger, String tag, boolean notifyServer) {
        if (this.gate == null) {
            return;
        }
        if (tag != null) {
            this.gate.setTrigger(trigger, StatementManager.statements.get(tag));
        } else {
            this.gate.setTrigger(trigger, null);
        }
        if (this.pipe.container.func_145831_w().field_72995_K && notifyServer) {
            RPCHandler.rpcServer((Object)this, "setTrigger", trigger, tag, false);
        }
    }

    @RPC(value=RPCSide.BOTH)
    public void setTriggerParameter(int trigger, int param, IStatementParameter parameter, boolean notifyServer) {
        if (this.gate == null) {
            return;
        }
        this.gate.setTriggerParameter(trigger, param, parameter);
        if (this.pipe.container.func_145831_w().field_72995_K && notifyServer) {
            RPCHandler.rpcServer((Object)this, "setTriggerParameter", trigger, param, parameter, false);
        }
    }

    public IStatementParameter getTriggerParameter(int trigger, int param) {
        if (this.gate == null) {
            return null;
        }
        return this.gate.getTriggerParameter(trigger, param);
    }

    public boolean hasActions() {
        return !this.potentialActions.isEmpty();
    }

    public IStatement getFirstAction() {
        if (this.potentialActions.isEmpty()) {
            return null;
        }
        return (IStatement)this.potentialActions.first();
    }

    public IStatement getLastAction() {
        if (this.potentialActions.isEmpty()) {
            return null;
        }
        return (IStatement)this.potentialActions.last();
    }

    public Iterator<IStatement> getActionIterator(boolean descending) {
        return descending ? this.potentialActions.descendingIterator() : this.potentialActions.iterator();
    }

    @RPC(value=RPCSide.BOTH)
    public void setAction(int action, String tag, boolean notifyServer) {
        if (this.gate == null) {
            return;
        }
        if (tag != null) {
            this.gate.setAction(action, StatementManager.statements.get(tag));
        } else {
            this.gate.setAction(action, null);
        }
        if (this.pipe.container.func_145831_w().field_72995_K && notifyServer) {
            RPCHandler.rpcServer((Object)this, "setAction", action, tag, false);
        }
    }

    @RPC(value=RPCSide.BOTH)
    public void setActionParameter(int action, int param, IStatementParameter parameter, boolean notifyServer) {
        if (this.gate == null) {
            return;
        }
        this.gate.setActionParameter(action, param, parameter);
        if (this.pipe.container.func_145831_w().field_72995_K && notifyServer) {
            RPCHandler.rpcServer((Object)this, "setActionParameter", action, param, parameter, false);
        }
    }

    public ResourceLocation getGateGuiFile() {
        return this.gate.material.guiFile;
    }

    public String getGateName() {
        return GateDefinition.getLocalizedName(this.gate.material, this.gate.logic);
    }
}

