/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BitSetUtils;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TileGenericPipe;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidUpdate
extends PacketCoordinates {
    public static int FLUID_ID_BIT = 0;
    public static int FLUID_AMOUNT_BIT = 1;
    public static int FLUID_DATA_NUM = 2;
    public FluidStack[] renderCache = new FluidStack[ForgeDirection.values().length];
    public int[] colorRenderCache = new int[ForgeDirection.values().length];
    public BitSet delta;

    public PacketFluidUpdate(int xCoord, int yCoord, int zCoord) {
        super(3, xCoord, yCoord, zCoord);
    }

    public PacketFluidUpdate(int xCoord, int yCoord, int zCoord, boolean chunkPacket) {
        super(3, xCoord, yCoord, zCoord);
        this.isChunkDataPacket = chunkPacket;
    }

    public PacketFluidUpdate() {
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        World world = CoreProxy.proxy.getClientWorld();
        if (!world.func_72899_e(this.posX, this.posY, this.posZ)) {
            return;
        }
        TileEntity entity = world.func_147438_o(this.posX, this.posY, this.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportFluids)) {
            return;
        }
        PipeTransportFluids transLiq = (PipeTransportFluids)pipe.pipe.transport;
        this.renderCache = transLiq.renderCache;
        this.colorRenderCache = transLiq.colorRenderCache;
        byte[] dBytes = new byte[2];
        data.readBytes(dBytes);
        this.delta = BitSetUtils.fromByteArray(dBytes);
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (this.delta.get(dir.ordinal() * FLUID_DATA_NUM + FLUID_ID_BIT)) {
                int amt = this.renderCache[dir.ordinal()] != null ? this.renderCache[dir.ordinal()].amount : 0;
                this.renderCache[dir.ordinal()] = new FluidStack((int)data.readShort(), amt);
                this.colorRenderCache[dir.ordinal()] = data.readInt();
            }
            if (!this.delta.get(dir.ordinal() * FLUID_DATA_NUM + FLUID_AMOUNT_BIT)) continue;
            if (this.renderCache[dir.ordinal()] == null) {
                this.renderCache[dir.ordinal()] = new FluidStack(0, 0);
            }
            this.renderCache[dir.ordinal()].amount = Math.min(transLiq.getCapacity(), data.readInt());
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        byte[] dBytes = BitSetUtils.toByteArray(this.delta, 2);
        data.writeBytes(dBytes);
        for (ForgeDirection dir : ForgeDirection.values()) {
            FluidStack liquid = this.renderCache[dir.ordinal()];
            if (this.delta.get(dir.ordinal() * FLUID_DATA_NUM + FLUID_ID_BIT)) {
                if (liquid != null) {
                    data.writeShort(liquid.fluidID);
                    data.writeInt(this.colorRenderCache[dir.ordinal()]);
                } else {
                    data.writeShort(0);
                    data.writeInt(0xFFFFFF);
                }
            }
            if (!this.delta.get(dir.ordinal() * FLUID_DATA_NUM + FLUID_AMOUNT_BIT)) continue;
            if (liquid != null) {
                data.writeInt(liquid.amount);
                continue;
            }
            data.writeInt(0);
        }
    }

    @Override
    public int getID() {
        return 3;
    }
}

