/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.NetworkData;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.RFBattery;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.PipeLogicWood;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsWood
extends Pipe<PipeTransportFluids>
implements IEnergyHandler {
    @NetworkData
    public int liquidToExtract;
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeFluidsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    private long lastMining = 0L;
    private boolean lastPower = false;
    private RFBattery battery = new RFBattery(2500, 1000, 0);
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            if (!(tile instanceof IFluidHandler)) {
                return false;
            }
            return PipeManager.canExtractFluids(this.pipe, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    };

    public PipeFluidsWood(Item item) {
        super(new PipeTransportFluids(), item);
        ((PipeTransportFluids)this.transport).flowRate = BuildCraftTransport.pipeFluidsBaseFlowRate;
        ((PipeTransportFluids)this.transport).travelDelay = 12;
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange(blockId);
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public void updateEntity() {
        ForgeDirection side;
        TileEntity tile;
        super.updateEntity();
        int meta = this.container.func_145832_p();
        if (this.liquidToExtract > 0 && meta < 6 && (tile = this.container.getTile(side = ForgeDirection.getOrientation((int)meta))) instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)tile;
            int flowRate = ((PipeTransportFluids)this.transport).flowRate;
            FluidStack extracted = fluidHandler.drain(side.getOpposite(), this.liquidToExtract > flowRate ? flowRate : this.liquidToExtract, false);
            int inserted = 0;
            if (extracted != null) {
                inserted = ((PipeTransportFluids)this.transport).fill(side, extracted, true);
                fluidHandler.drain(side.getOpposite(), inserted, true);
            }
            this.liquidToExtract -= inserted;
        }
        if (this.battery.useEnergy(10, 10, false) > 0) {
            if (meta > 5) {
                return;
            }
            TileEntity tile2 = this.container.getTile(ForgeDirection.getOrientation((int)meta));
            if (tile2 instanceof IFluidHandler) {
                if (!PipeManager.canExtractFluids(this, tile2.func_145831_w(), tile2.field_145851_c, tile2.field_145848_d, tile2.field_145849_e)) {
                    return;
                }
                if (this.liquidToExtract <= 1000) {
                    this.liquidToExtract += 1000;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_145832_p();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        int meta = this.container.func_145832_p();
        return super.outputOpen(to) && meta != to.ordinal();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.battery.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.battery.getMaxEnergyStored();
    }
}

