/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.InventoryWrapper;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.network.IClientState;
import buildcraft.core.network.IGuiReturnHandler;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.pipes.PipeItemsWood;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsEmerald
extends PipeItemsWood
implements IClientState,
IGuiReturnHandler {
    private EmeraldPipeSettings settings = new EmeraldPipeSettings();
    private final SimpleInventory filters = new SimpleInventory(9, "Filters", 1);
    private int currentFilter = 0;

    public PipeItemsEmerald(Item item) {
        super(item);
        this.standardIconIndex = PipeIconProvider.TYPE.PipeItemsEmerald_Standard.ordinal();
        this.solidIconIndex = PipeIconProvider.TYPE.PipeAllEmerald_Solid.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && Block.func_149634_a((Item)entityplayer.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer)) {
            return true;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 52, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        }
        return true;
    }

    @Override
    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory == null) {
            return null;
        }
        ISidedInventory sidedInventory = InventoryWrapper.getWrappedInventory(InvUtils.getInventory(inventory));
        if (this.settings.getFilterMode() == FilterMode.ROUND_ROBIN) {
            return this.checkExtractRoundRobin(sidedInventory, doRemove, from);
        }
        return this.checkExtractFiltered(sidedInventory, doRemove, from);
    }

    private ItemStack[] checkExtractFiltered(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int k : inventory.func_94128_d(from.ordinal())) {
            boolean isBlackList;
            ItemStack stack = inventory.func_70301_a(k);
            if (stack == null || stack.field_77994_a <= 0 || !inventory.func_102008_b(k, stack, from.ordinal())) continue;
            boolean matches = this.isFiltered(stack);
            boolean bl = isBlackList = this.settings.getFilterMode() == FilterMode.BLACK_LIST;
            if (isBlackList && matches || !isBlackList && !matches) continue;
            if (doRemove) {
                int stackSize = (int)Math.floor(this.battery.useEnergy(10, 10 * stack.field_77994_a, false) / 10);
                stack = inventory.func_70298_a(k, stackSize);
            }
            return new ItemStack[]{stack};
        }
        return null;
    }

    private ItemStack[] checkExtractRoundRobin(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int i : inventory.func_94128_d(from.ordinal())) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            ItemStack filter = this.getCurrentFilter();
            if (filter == null) {
                return null;
            }
            if (!StackHelper.isMatchingItemOrList(filter, stack) || !inventory.func_102008_b(i, stack, from.ordinal())) continue;
            if (doRemove) {
                stack = inventory.func_70298_a(i, 1);
                this.incrementFilter();
            }
            return new ItemStack[]{stack};
        }
        return null;
    }

    private boolean isFiltered(ItemStack stack) {
        for (int i = 0; i < this.filters.func_70302_i_(); ++i) {
            ItemStack filter = this.filters.func_70301_a(i);
            if (filter == null) {
                return false;
            }
            if (!StackHelper.isMatchingItemOrList(filter, stack)) continue;
            return true;
        }
        return false;
    }

    private void incrementFilter() {
        ++this.currentFilter;
        for (int count = 0; this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_()) == null && count < this.filters.func_70302_i_(); ++count) {
            ++this.currentFilter;
        }
    }

    private ItemStack getCurrentFilter() {
        ItemStack filter = this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_());
        if (filter == null) {
            this.incrementFilter();
        }
        return this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_());
    }

    public IInventory getFilters() {
        return this.filters;
    }

    public EmeraldPipeSettings getSettings() {
        return this.settings;
    }

    @Override
    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        Utils.writeNBT(data, nbt);
    }

    @Override
    public void readData(ByteBuf data) {
        NBTTagCompound nbt = Utils.readNBT(data);
        this.readFromNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        this.settings.readFromNBT(nbt);
        this.currentFilter = nbt.func_74762_e("currentFilter");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
        this.settings.writeToNBT(nbt);
        nbt.func_74768_a("currentFilter", this.currentFilter);
    }

    @Override
    public void writeGuiData(ByteBuf data) {
        data.writeByte((int)((byte)this.settings.getFilterMode().ordinal()));
    }

    @Override
    public void readGuiData(ByteBuf data, EntityPlayer sender) {
        this.settings.setFilterMode(FilterMode.values()[data.readByte()]);
    }

    public class EmeraldPipeSettings {
        private FilterMode filterMode = FilterMode.WHITE_LIST;

        public FilterMode getFilterMode() {
            return this.filterMode;
        }

        public void setFilterMode(FilterMode mode) {
            this.filterMode = mode;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.filterMode = FilterMode.values()[nbt.func_74771_c("filterMode")];
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74774_a("filterMode", (byte)this.filterMode.ordinal());
        }
    }

    public static enum FilterMode {
        WHITE_LIST,
        BLACK_LIST,
        ROUND_ROBIN;

    }
}

