/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.tools.IToolWrench;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.StatementSlot;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.statements.ActionPipeColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsLapis
extends Pipe<PipeTransportItems> {
    public PipeItemsLapis(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (this.container == null) {
            return PipeIconProvider.TYPE.PipeItemsLapis_Black.ordinal();
        }
        return PipeIconProvider.TYPE.PipeItemsLapis_Black.ordinal() + this.container.func_145832_p();
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e)) {
            if (player.func_70093_af()) {
                this.setColor(this.getColor().getPrevious());
            } else {
                this.setColor(this.getColor().getNext());
            }
            ((IToolWrench)equipped).wrenchUsed(player, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
            return true;
        }
        return false;
    }

    public EnumColor getColor() {
        return EnumColor.fromId(this.container.func_145832_p());
    }

    public void setColor(EnumColor color) {
        if (color.ordinal() != this.container.func_145832_p()) {
            this.container.func_145831_w().func_72921_c(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, color.ordinal(), 3);
            this.container.scheduleRenderUpdate();
        }
    }

    public void eventHandler(PipeEventItem.ReachedCenter event) {
        event.item.color = this.getColor();
    }

    public void eventHandler(PipeEventItem.AdjustSpeed event) {
        event.handled = true;
        TravelingItem item = event.item;
        if (item.getSpeed() > 0.01f) {
            item.setSpeed(item.getSpeed() - 0.0025f);
        }
        if (item.getSpeed() < 0.01f) {
            item.setSpeed(0.01f);
        }
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeColor)) continue;
            this.setColor(((ActionPipeColor)action.statement).color);
            break;
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> result = super.getActions();
        result.addAll(Arrays.asList(BuildCraftTransport.actionPipeColor));
        return result;
    }
}

