/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.api.transport.IStripesPipe;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsStripes
extends Pipe<PipeTransportItems>
implements IEnergyHandler,
IStripesPipe {
    public PipeItemsStripes(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        Position p = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, event.direction);
        p.moveForwards(1.0);
        ItemStack stack = event.entity.func_92059_d();
        EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), (int)p.x, (int)p.y, (int)p.z).get();
        switch (event.direction) {
            case DOWN: {
                player.field_70125_A = 90.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case UP: {
                player.field_70125_A = 270.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case NORTH: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case WEST: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 90.0f;
                break;
            }
            case EAST: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 270.0f;
                break;
            }
        }
        for (IStripesHandler handler : PipeManager.stripesHandlers) {
            if (handler.getType() != IStripesHandler.StripesHandlerType.ITEM_USE || !handler.shouldHandle(stack) || !handler.handle(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, event.direction, stack, player, this)) continue;
            return;
        }
        if (this.convertPipe((PipeTransportItems)this.transport, event.item)) {
            TileEntity targetTile;
            int moves = 0;
            while (stack.field_77994_a > 0 && this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z) == Blocks.field_150350_a) {
                stack.func_77973_b().func_77648_a(new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()), player, this.getWorld(), (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
                --stack.field_77994_a;
                p.moveForwards(1.0);
                ++moves;
            }
            if (this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z) != Blocks.field_150350_a) {
                p.moveBackwards(1.0);
                ++stack.field_77994_a;
                this.getWorld().func_147468_f((int)p.x, (int)p.y, (int)p.z);
            }
            BuildCraftTransport.pipeItemsStripes.func_77648_a(new ItemStack(BuildCraftTransport.pipeItemsStripes, 1, this.container.glassColor), player, this.getWorld(), (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
            this.container.glassColor = stack.func_77960_j() - 1;
            if (stack.field_77994_a > 0 && (targetTile = this.getWorld().func_147438_o((int)p.x, (int)p.y, (int)p.z)) instanceof TileGenericPipe) {
                TravelingItem newItem = TravelingItem.make((double)this.container.field_145851_c + 0.5, (float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(new ItemStack(BuildCraftTransport.pipeItemsStripes)), (double)this.container.field_145849_e + 0.5, stack.func_77946_l());
                ((PipeTransportItems)((TileGenericPipe)targetTile).pipe.transport).injectItem(newItem, event.direction.getOpposite());
                stack.field_77994_a = 0;
            }
        } else if (stack.func_77973_b() instanceof ItemBlock) {
            if (this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z) == Blocks.field_150350_a) {
                stack.func_77943_a(player, this.getWorld(), (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
            }
        } else {
            stack.func_77943_a(player, this.getWorld(), (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public void dropItem(ItemStack itemStack, ForgeDirection direction) {
        Position p = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, direction);
        p.moveForwards(1.0);
        itemStack.func_77943_a((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld()).get(), this.getWorld(), (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void sendItem(ItemStack itemStack, ForgeDirection direction) {
        TravelingItem newItem = TravelingItem.make((double)this.container.field_145851_c + 0.5, (float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(itemStack), (double)this.container.field_145849_e + 0.5, itemStack);
        ((PipeTransportItems)this.transport).injectItem(newItem, direction);
    }

    private boolean convertPipe(PipeTransportItems pipe, TravelingItem item) {
        if (item.getItemStack().func_77973_b() instanceof ItemPipe && item.getItemStack().func_77973_b() != BuildCraftTransport.pipeItemsStripes) {
            Pipe<?> newPipe = BlockGenericPipe.createPipe(item.getItemStack().func_77973_b());
            newPipe.setTile(this.container);
            this.container.pipe = newPipe;
            --item.getItemStack().field_77994_a;
            if (item.getItemStack().field_77994_a <= 0) {
                ((PipeTransportItems)newPipe.transport).items.remove(item);
            }
            return true;
        }
        return false;
    }

    @Override
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return PipeIconProvider.TYPE.Stripes.ordinal();
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe tilePipe = (TileGenericPipe)tile;
            if (tilePipe.pipe instanceof PipeItemsStripes) {
                return false;
            }
        }
        return super.canPipeConnect(tile, side);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (maxReceive == 0) {
            return 0;
        }
        if (simulate) {
            return maxReceive;
        }
        ForgeDirection o = this.getOpenOrientation();
        if (o != ForgeDirection.UNKNOWN) {
            Position p = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, o);
            p.moveForwards(1.0);
            if (!BlockUtil.isUnbreakableBlock(this.getWorld(), (int)p.x, (int)p.y, (int)p.z)) {
                Block block = this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z);
                int metadata = this.getWorld().func_72805_g((int)p.x, (int)p.y, (int)p.z);
                ItemStack stack = new ItemStack(block, 1, metadata);
                EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), (int)p.x, (int)p.y, (int)p.z).get();
                for (IStripesHandler handler : PipeManager.stripesHandlers) {
                    if (handler.getType() != IStripesHandler.StripesHandlerType.BLOCK_BREAK || !handler.shouldHandle(stack) || !handler.handle(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, o, stack, player, this)) continue;
                    return maxReceive;
                }
                ArrayList stacks = block.getDrops(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, metadata, 0);
                if (stacks != null) {
                    for (ItemStack s : stacks) {
                        if (s == null) continue;
                        this.sendItem(s, o.getOpposite());
                    }
                }
                this.getWorld().func_147468_f((int)p.x, (int)p.y, (int)p.z);
            }
        }
        return maxReceive;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 10;
    }
}

