/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.RFBattery;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePowerWood
extends Pipe<PipeTransportPower>
implements IPowerReceptor,
IPipeTransportPowerHook,
IEnergyHandler {
    public final boolean[] powerSources = new boolean[6];
    protected int standardIconIndex = PipeIconProvider.TYPE.PipePowerWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    protected RFBattery battery = new RFBattery(16000, 320, 0);
    private boolean full;
    private int requestedEnergy;
    private int sources;
    private PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.PIPE);

    public PipePowerWood(Item item) {
        super(new PipeTransportPower(), item);
        this.powerHandler.configure(0.0, 500.0, 1.0, 1500.0);
        this.powerHandler.setPerdition(new PowerHandler.PerditionCalculator(0.01f));
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction != ForgeDirection.UNKNOWN && this.powerSources[direction.ordinal()]) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.sources = 0;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            boolean oldPowerSource = this.powerSources[o.ordinal()];
            if (!this.container.isPipeConnected(o)) {
                this.powerSources[o.ordinal()] = false;
            } else {
                TileEntity tile = this.container.getTile(o);
                this.powerSources[o.ordinal()] = this.isPowerSource(tile, o);
                if (this.powerSources[o.ordinal()]) {
                    ++this.sources;
                }
            }
            if (oldPowerSource == this.powerSources[o.ordinal()]) continue;
            this.container.scheduleRenderUpdate();
        }
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.sources <= 0) {
            this.battery.useEnergy(0, 50, false);
            this.requestedEnergy = 0;
            return;
        }
        if (this.sources == 0) {
            return;
        }
        int energyToRemove = Math.min(this.battery.getEnergyStored(), this.requestedEnergy);
        energyToRemove /= this.sources;
        if (this.battery.getEnergyStored() > 0) {
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.powerSources[o.ordinal()]) continue;
                this.battery.setEnergy(this.battery.getEnergyStored() - ((PipeTransportPower)this.transport).receiveEnergy(o, energyToRemove));
            }
        }
        this.requestedEnergy = 0;
    }

    public boolean requestsPower() {
        if (this.full) {
            boolean request;
            boolean bl = request = this.battery.getEnergyStored() < this.battery.getMaxEnergyStored() / 2;
            if (request) {
                this.full = false;
            }
            return request;
        }
        this.full = this.battery.getEnergyStored() >= this.battery.getMaxEnergyStored() - 100;
        return !this.full;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagCompound batteryNBT = new NBTTagCompound();
        this.battery.writeToNBT(batteryNBT);
        data.func_74782_a("battery", (NBTBase)batteryNBT);
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            data.func_74757_a("powerSources[" + i + "]", this.powerSources[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.battery.readFromNBT(data.func_74775_l("battery"));
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.powerSources[i] = data.func_74767_n("powerSources[" + i + "]");
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int val) {
        return -1;
    }

    @Override
    public int requestEnergy(ForgeDirection from, int amount) {
        if (this.container.getTile(from) instanceof IPipeTile) {
            this.requestedEnergy += amount;
            return amount;
        }
        return 0;
    }

    public boolean isPowerSource(TileEntity tile, ForgeDirection from) {
        if (!((PipeTransportPower)this.transport).inputOpen(from)) {
            return false;
        }
        if (tile instanceof IPowerEmitter && ((IPowerEmitter)tile).canEmitPowerFrom(from.getOpposite())) {
            return true;
        }
        return tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(from.getOpposite());
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        this.battery.addEnergy(0, (int)Math.round(this.powerHandler.getEnergyStored() * 10.0), true);
        this.powerHandler.setEnergy(0.0);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.powerSources[from.ordinal()]) {
            return this.battery.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.battery.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.battery.getMaxEnergyStored();
    }
}

