/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.transport.render.ITextureStates;
import buildcraft.transport.render.TextureStateManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public final class FakeBlock
extends Block
implements ITextureStates {
    public static final FakeBlock INSTANCE = new FakeBlock();
    private int renderMask = 0;
    private int colorMultiplier = 0xFFFFFF;
    private TextureStateManager textureState = new TextureStateManager(null);

    private FakeBlock() {
        super(Material.field_151592_s);
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        return this.colorMultiplier;
    }

    public void setColor(int color) {
        this.colorMultiplier = color;
    }

    @Override
    public TextureStateManager getTextureState() {
        return this.textureState;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.textureState.isSided() ? this.textureState.getTextureArray()[side] : this.textureState.getTexture();
    }

    @Override
    public void setRenderSide(ForgeDirection side, boolean render) {
        this.renderMask = render ? (this.renderMask |= 1 << side.ordinal()) : (this.renderMask &= ~(1 << side.ordinal()));
    }

    @Override
    public void setRenderAllSides() {
        this.renderMask = 63;
    }

    @Override
    public void setRenderMask(int mask) {
        this.renderMask = mask;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return (this.renderMask & 1 << side) != 0;
    }
}

