/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class GateMatrix {
    private final boolean[] isGateLit = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
    private final boolean[] isGatePulsing = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
    private final boolean[] isGateExists = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
    private final int[] gateIconIndex = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private boolean dirty = false;

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void setIsGateLit(boolean gateLit, ForgeDirection direction) {
        if (this.isGateLit[direction.ordinal()] != gateLit) {
            this.isGateLit[direction.ordinal()] = gateLit;
            this.dirty = true;
        }
    }

    public boolean isGateLit(ForgeDirection direction) {
        return this.isGateLit[direction.ordinal()];
    }

    public void setIsGatePulsing(boolean gatePulsing, ForgeDirection direction) {
        if (this.isGatePulsing[direction.ordinal()] != gatePulsing) {
            this.isGatePulsing[direction.ordinal()] = gatePulsing;
            this.dirty = true;
        }
    }

    public boolean isGatePulsing(ForgeDirection direction) {
        return this.isGatePulsing[direction.ordinal()];
    }

    public void setIsGateExists(boolean gateExists, ForgeDirection direction) {
        if (this.isGateExists[direction.ordinal()] != gateExists) {
            this.isGateExists[direction.ordinal()] = gateExists;
            this.dirty = true;
        }
    }

    public boolean isGateExists(ForgeDirection direction) {
        return this.isGateExists[direction.ordinal()];
    }

    public void writeData(ByteBuf data) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            data.writeBoolean(this.isGateLit[i]);
            data.writeBoolean(this.isGatePulsing[i]);
            data.writeBoolean(this.isGateExists[i]);
            data.writeInt(this.gateIconIndex[i]);
        }
    }

    public void readData(ByteBuf data) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.isGateLit[i] = data.readBoolean();
            this.isGatePulsing[i] = data.readBoolean();
            this.isGateExists[i] = data.readBoolean();
            this.gateIconIndex[i] = data.readInt();
        }
    }
}

