/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.api.core.NetworkData;
import buildcraft.core.network.serializers.ClassMapping;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.transport.utils.RobotStationState;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class RobotStationMatrix {
    @NetworkData
    private RobotStationState[] states = new RobotStationState[6];
    private boolean dirty = false;

    public RobotStationMatrix() {
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = RobotStationState.None;
        }
    }

    public boolean isConnected(ForgeDirection direction) {
        return this.states[direction.ordinal()] != RobotStationState.None;
    }

    public void setState(ForgeDirection direction, RobotStationState value) {
        if (this.states[direction.ordinal()] != value) {
            this.states[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public RobotStationState getState(ForgeDirection direction) {
        return this.states[direction.ordinal()];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        try {
            SerializationContext context = new SerializationContext();
            ClassMapping.get(this.getClass()).write(data, this, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readData(ByteBuf data) {
        try {
            SerializationContext context = new SerializationContext();
            ClassMapping.get(this.getClass()).read(data, this, context);
            this.dirty = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

