/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2.core.util.StackUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMagnetizer
extends TileEntityBlock
implements IEnergySink {
    public double energy = 0.0;
    public int ticker = 0;
    public int maxEnergy = 100;
    public boolean addedToEnergyNet = false;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74765_d("energy");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_145845_h() {
        int need;
        int y;
        super.func_145845_h();
        if (this.ticker-- > 0) {
            return;
        }
        boolean change = false;
        for (y = this.field_145848_d - 1; y > 0 && y >= this.field_145848_d - 20 && !(this.energy <= 0.0) && StackUtil.equals(this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e), Ic2Items.ironFence); --y) {
            need = 15 - this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e);
            if (need <= 0) continue;
            change = true;
            if ((double)need > this.energy) {
                this.energy = need;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, y, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) + need, 7);
            this.energy -= (double)need;
        }
        for (y = this.field_145848_d + 1; y < IC2.getWorldHeight(this.field_145850_b) && y <= this.field_145848_d + 20 && !(this.energy <= 0.0) && StackUtil.equals(this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e), Ic2Items.ironFence); ++y) {
            need = 15 - this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e);
            if (need <= 0) continue;
            change = true;
            if ((double)need > this.energy) {
                this.energy = need;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, y, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) + need, 7);
            this.energy -= (double)need;
        }
        if (!change) {
            this.ticker = 10;
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return (double)this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getSinkTier() {
        return 1;
    }
}

