/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLuminatorOLD
extends TileEntity
implements IEnergySink,
IEnergyConductor {
    public double energy = 0.0;
    public int mode = 0;
    public boolean powered = false;
    public int ticker = 0;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74765_d("energy");
        }
        this.mode = nbttagcompound.func_74765_d("mode");
        this.powered = nbttagcompound.func_74767_n("powered");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74777_a("mode", (short)this.mode);
        nbttagcompound.func_74757_a("poweredy", this.powered);
    }

    public void func_145829_t() {
        super.func_145829_t();
        IC2.tickHandler.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

            @Override
            public void tickCallback(World world) {
                if (TileEntityLuminatorOLD.this.func_145837_r() || !world.func_72899_e(TileEntityLuminatorOLD.this.field_145851_c, TileEntityLuminatorOLD.this.field_145848_d, TileEntityLuminatorOLD.this.field_145849_e)) {
                    return;
                }
                TileEntityLuminatorOLD.this.onLoaded();
                if (TileEntityLuminatorOLD.this.enableUpdateEntity()) {
                    world.field_147482_g.add(TileEntityLuminatorOLD.this);
                }
            }
        });
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public final boolean canUpdate() {
        return false;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        ++this.ticker;
        if (this.ticker % 20 == 0) {
            if (this.ticker % 160 == 0) {
                System.out.println("Consume for Mode: " + this.mode);
                int consume = 5;
                switch (this.mode) {
                    case 1: {
                        consume = 10;
                        break;
                    }
                    case 2: {
                        consume = 40;
                    }
                }
                if ((double)consume > this.energy) {
                    this.energy = 0.0;
                    this.powered = false;
                    System.out.println("Out of energy");
                } else {
                    System.out.println("Energized");
                    this.energy -= (double)consume;
                    this.powered = true;
                }
                this.updateLightning();
            }
            if (this.powered) {
                this.burnMobs();
            }
        }
    }

    public float getLightLevel() {
        if (this.powered) {
            System.out.println("get powered");
        }
        System.out.println("get unpowered");
        return 0.9375f;
    }

    public void switchStrength() {
        this.mode = (this.mode + 1) % 3;
        this.updateLightning();
    }

    public void updateLightning() {
        System.out.println("Update Lightning");
        this.field_145850_b.func_147463_c(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getConductionLoss() {
        return 0.0;
    }

    @Override
    public double getInsulationEnergyAbsorption() {
        return 32.0;
    }

    @Override
    public double getInsulationBreakdownEnergy() {
        return 33.0;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return 33.0;
    }

    @Override
    public void removeInsulation() {
        System.out.println("REmove Insulation");
        this.poof();
    }

    @Override
    public void removeConductor() {
        System.out.println("REmove Confuctor");
        this.poof();
    }

    @Override
    public double getDemandedEnergy() {
        return (double)this.getMaxEnergy() - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.getMaxEnergy()) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getSinkTier() {
        return 1;
    }

    public int getMaxEnergy() {
        switch (this.mode) {
            case 1: {
                return 20;
            }
            case 2: {
                return 80;
            }
        }
        return 10;
    }

    public void poof() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, 0.5 + (double)this.field_145851_c, 0.5 + (double)this.field_145848_d, 0.5 + (double)this.field_145849_e, 0.5f, 0.85f);
        explosion.doExplosion();
    }

    public void burnMobs() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        boolean xplus = false;
        boolean xminus = false;
        boolean yplus = false;
        boolean yminus = false;
        boolean zplus = false;
        boolean zminus = false;
        Block block = this.field_145850_b.func_147439_a(x + 1, y, z);
        if (block.isAir((IBlockAccess)this.field_145850_b, x + 1, y, z) || block == Blocks.field_150359_w || StackUtil.equals(block, Ic2Items.reinforcedGlass)) {
            xplus = true;
        }
        if ((block = this.field_145850_b.func_147439_a(x - 1, y, z)).isAir((IBlockAccess)this.field_145850_b, x - 1, y, z) || block == Blocks.field_150359_w || StackUtil.equals(block, Ic2Items.reinforcedGlass)) {
            xminus = true;
        }
        if ((block = this.field_145850_b.func_147439_a(x, y + 1, z)).isAir((IBlockAccess)this.field_145850_b, x, y + 1, z) || block == Blocks.field_150359_w || StackUtil.equals(block, Ic2Items.reinforcedGlass)) {
            yplus = true;
        }
        if ((block = this.field_145850_b.func_147439_a(x, y - 1, z)).isAir((IBlockAccess)this.field_145850_b, x, y - 1, z) || block == Blocks.field_150359_w || StackUtil.equals(block, Ic2Items.reinforcedGlass)) {
            yminus = true;
        }
        if ((block = this.field_145850_b.func_147439_a(x, y, z + 1)).isAir((IBlockAccess)this.field_145850_b, x, y, z + 1) || block == Blocks.field_150359_w || StackUtil.equals(block, Ic2Items.reinforcedGlass)) {
            zplus = true;
        }
        if ((block = this.field_145850_b.func_147439_a(x, y, z - 1)).isAir((IBlockAccess)this.field_145850_b, x, y, z - 1) || block == Blocks.field_150359_w || StackUtil.equals(block, Ic2Items.reinforcedGlass)) {
            zminus = true;
        }
        int xplusI = 0;
        int xminusI = 0;
        int yplusI = 0;
        int yminusI = 0;
        int zplusI = 0;
        int zminusI = 0;
        if (xplus) {
            xplusI = 3;
        } else if (yplus || yminus || zplus || zminus) {
            xplusI = 1;
        }
        if (xminus) {
            xminusI = 3;
        } else if (yplus || yminus || zplus || zminus) {
            xminusI = 1;
        }
        if (yplus) {
            yplusI = 3;
        } else if (xplus || xminus || zplus || zminus) {
            yplusI = 1;
        }
        if (yminus) {
            yminusI = 3;
        } else if (xplus || xminus || zplus || zminus) {
            yminusI = 1;
        }
        if (zplus) {
            zplusI = 3;
        } else if (yplus || yminus || xplus || xminus) {
            zplusI = 1;
        }
        if (zminus) {
            zminusI = 3;
        } else if (yplus || yminus || xplus || xminus) {
            zminusI = 1;
        }
        xminusI = x - xminusI;
        yminusI = y - yminusI;
        zminusI = z - zminusI;
        xplusI = x + xplusI;
        yplusI = y + yplusI;
        zplusI = z + zplusI;
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        List list1 = this.field_145850_b.func_72839_b(null, boundingBox.func_72321_a((double)x, (double)y, (double)z).func_72314_b(3.0, 3.0, 3.0));
        for (int l = 0; l < list1.size(); ++l) {
            Entity ent = (Entity)list1.get(l);
            if (!(ent instanceof EntityMob)) continue;
            double ex = ent.field_70165_t;
            double ey = ent.field_70163_u;
            double ez = ent.field_70161_v;
            if (!(ex >= (double)xminusI) || !(ex <= (double)(xplusI + 1)) || !(ey >= (double)yminusI) || !(ey <= (double)(yplusI + 2)) || !(ez >= (double)zminusI) || !(ez <= (double)(zplusI + 1))) continue;
            ent.func_70015_d(10);
        }
    }
}

