/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BlueprintDeployer;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.SchematicFactory;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.blueprints.SchematicRegistry;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.JavaTools;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.gates.ActionManager;
import buildcraft.builders.BlockArchitect;
import buildcraft.builders.BlockBlueprintLibrary;
import buildcraft.builders.BlockBuildTool;
import buildcraft.builders.BlockBuilder;
import buildcraft.builders.BlockFiller;
import buildcraft.builders.BlockMarker;
import buildcraft.builders.BlockPathMarker;
import buildcraft.builders.BuilderProxy;
import buildcraft.builders.EventHandlerBuilders;
import buildcraft.builders.GuiHandler;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.TileFiller;
import buildcraft.builders.TileMarker;
import buildcraft.builders.TilePathMarker;
import buildcraft.builders.blueprints.BlueprintDatabase;
import buildcraft.builders.filler.FillerRegistry;
import buildcraft.builders.filler.pattern.FillerPattern;
import buildcraft.builders.filler.pattern.PatternBox;
import buildcraft.builders.filler.pattern.PatternClear;
import buildcraft.builders.filler.pattern.PatternCylinder;
import buildcraft.builders.filler.pattern.PatternFill;
import buildcraft.builders.filler.pattern.PatternFlatten;
import buildcraft.builders.filler.pattern.PatternFrame;
import buildcraft.builders.filler.pattern.PatternHorizon;
import buildcraft.builders.filler.pattern.PatternPyramid;
import buildcraft.builders.filler.pattern.PatternStairs;
import buildcraft.builders.schematics.SchematicBed;
import buildcraft.builders.schematics.SchematicBlockCreative;
import buildcraft.builders.schematics.SchematicCactus;
import buildcraft.builders.schematics.SchematicCustomStack;
import buildcraft.builders.schematics.SchematicDirt;
import buildcraft.builders.schematics.SchematicDoor;
import buildcraft.builders.schematics.SchematicEnderChest;
import buildcraft.builders.schematics.SchematicFactoryBlock;
import buildcraft.builders.schematics.SchematicFactoryEntity;
import buildcraft.builders.schematics.SchematicFactoryMask;
import buildcraft.builders.schematics.SchematicFarmland;
import buildcraft.builders.schematics.SchematicFire;
import buildcraft.builders.schematics.SchematicFluid;
import buildcraft.builders.schematics.SchematicGlassPane;
import buildcraft.builders.schematics.SchematicGravel;
import buildcraft.builders.schematics.SchematicHanging;
import buildcraft.builders.schematics.SchematicIgnore;
import buildcraft.builders.schematics.SchematicLever;
import buildcraft.builders.schematics.SchematicMinecart;
import buildcraft.builders.schematics.SchematicPiston;
import buildcraft.builders.schematics.SchematicPortal;
import buildcraft.builders.schematics.SchematicPumpkin;
import buildcraft.builders.schematics.SchematicRail;
import buildcraft.builders.schematics.SchematicRedstoneDiode;
import buildcraft.builders.schematics.SchematicRedstoneLamp;
import buildcraft.builders.schematics.SchematicRedstoneWire;
import buildcraft.builders.schematics.SchematicRotateMeta;
import buildcraft.builders.schematics.SchematicSeeds;
import buildcraft.builders.schematics.SchematicSign;
import buildcraft.builders.schematics.SchematicSkull;
import buildcraft.builders.schematics.SchematicStairs;
import buildcraft.builders.schematics.SchematicStandalone;
import buildcraft.builders.schematics.SchematicStone;
import buildcraft.builders.schematics.SchematicTileCreative;
import buildcraft.builders.schematics.SchematicTripWireHook;
import buildcraft.builders.schematics.SchematicWallSide;
import buildcraft.builders.triggers.ActionFiller;
import buildcraft.builders.triggers.BuildersActionProvider;
import buildcraft.builders.urbanism.BlockUrbanist;
import buildcraft.builders.urbanism.UrbanistToolsIconProvider;
import buildcraft.core.InterModComms;
import buildcraft.core.blueprints.RealBlueprintDeployer;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(name="BuildCraft Builders", version="6.0.17", useMetadata=false, modid="BuildCraft|Builders", dependencies="required-after:BuildCraft|Core@6.0.17")
public class BuildCraftBuilders
extends BuildCraftMod {
    public static final char BPT_SEP_CHARACTER = '-';
    public static final int LIBRARY_PAGE_SIZE = 12;
    public static final int MAX_BLUEPRINTS_NAME_SIZE = 32;
    public static BlockBuildTool buildToolBlock;
    public static BlockMarker markerBlock;
    public static BlockPathMarker pathMarkerBlock;
    public static BlockFiller fillerBlock;
    public static BlockBuilder builderBlock;
    public static BlockArchitect architectBlock;
    public static BlockBlueprintLibrary libraryBlock;
    public static BlockUrbanist urbanistBlock;
    public static ItemBlueprintTemplate templateItem;
    public static ItemBlueprintStandard blueprintItem;
    public static ActionFiller[] fillerActions;
    @Mod.Instance(value="BuildCraft|Builders")
    public static BuildCraftBuilders instance;
    public static BlueprintDatabase serverDB;
    public static BlueprintDatabase clientDB;

    @Mod.EventHandler
    public void loadConfiguration(FMLPreInitializationEvent evt) {
        File bptMainDir = new File(new File(evt.getModConfigurationDirectory(), "buildcraft"), "blueprints");
        String blueprintServerDir = BuildCraftCore.mainConfiguration.get("general", "blueprints.serverDir", "\"$MINECRAFT" + File.separator + "config" + File.separator + "buildcraft" + File.separator + "blueprints" + File.separator + "server\"").getString();
        String blueprintLibraryOutput = BuildCraftCore.mainConfiguration.get("general", "blueprints.libraryOutput", "\"$MINECRAFT" + File.separator + "blueprints\"").getString();
        String[] blueprintLibraryInput = (String[])BuildCraftCore.mainConfiguration.get("general", "blueprints.libraryInput", new String[]{"\"$MINECRAFT" + File.separator + "blueprints\"", "\"$MINECRAFT" + File.separator + "config" + File.separator + "buildcraft" + File.separator + "blueprints" + File.separator + "client\"", "\"" + BuildCraftBuilders.getDownloadsDir() + "\""}).getStringList().clone();
        blueprintServerDir = JavaTools.stripSurroundingQuotes(this.replacePathVariables(blueprintServerDir));
        blueprintLibraryOutput = JavaTools.stripSurroundingQuotes(this.replacePathVariables(blueprintLibraryOutput));
        for (int i = 0; i < blueprintLibraryInput.length; ++i) {
            blueprintLibraryInput[i] = JavaTools.stripSurroundingQuotes(this.replacePathVariables(blueprintLibraryInput[i]));
        }
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        File serverDir = new File(bptMainDir, "server");
        File clientDir = new File(bptMainDir, "client");
        serverDB = new BlueprintDatabase();
        clientDB = new BlueprintDatabase();
        serverDB.init(new String[]{blueprintServerDir}, blueprintServerDir);
        clientDB.init(blueprintLibraryInput, blueprintLibraryOutput);
    }

    private static String getDownloadsDir() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("nix") || os.contains("lin") || os.contains("mac")) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"xdg-user-dir", "DOWNLOAD"});
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
                process.waitFor();
                String line = reader.readLine().trim();
                reader.close();
                if (line.length() > 0) {
                    return line;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "$HOME" + File.separator + "Downloads";
    }

    private String replacePathVariables(String path) {
        String result = path.replace("$DOWNLOADS", BuildCraftBuilders.getDownloadsDir());
        result = result.replace("$HOME", System.getProperty("user.home"));
        result = Launch.minecraftHome == null ? result.replace("$MINECRAFT", new File(".").getAbsolutePath()) : result.replace("$MINECRAFT", Launch.minecraftHome.getAbsolutePath());
        return result;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        SchematicRegistry.declareBlueprintSupport("BuildCraft|Builders");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerBuilders());
        SchematicRegistry.registerSchematicBlock(Blocks.field_150433_aE, SchematicIgnore.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150329_H, SchematicIgnore.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150398_cm, SchematicIgnore.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150432_aD, SchematicIgnore.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150332_K, SchematicIgnore.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150346_d, SchematicDirt.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150349_c, SchematicDirt.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150434_aF, SchematicCactus.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150458_ak, SchematicFarmland.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150464_aj, SchematicSeeds.class, Items.field_151014_N);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150393_bb, SchematicSeeds.class, Items.field_151080_bb);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150394_bc, SchematicSeeds.class, Items.field_151081_bc);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150388_bm, SchematicSeeds.class, Items.field_151075_bm);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150478_aa, SchematicWallSide.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150429_aA, SchematicWallSide.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150437_az, SchematicWallSide.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150479_bC, SchematicTripWireHook.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150465_bP, SchematicSkull.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150468_ap, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150396_be, SchematicRotateMeta.class, new int[]{0, 1, 2, 3}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150364_r, SchematicRotateMeta.class, new int[]{8, 4, 8, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150363_s, SchematicRotateMeta.class, new int[]{8, 4, 8, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150407_cf, SchematicRotateMeta.class, new int[]{8, 4, 8, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150371_ca, SchematicRotateMeta.class, new int[]{4, 3, 4, 3}, true);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150438_bZ, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150467_bQ, SchematicRotateMeta.class, new int[]{0, 1, 2, 3}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150460_al, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150470_am, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150486_ae, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150367_z, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150409_cd, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150477_bB, SchematicEnderChest.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150395_bd, SchematicRotateMeta.class, new int[]{1, 4, 8, 2}, false);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150415_aT, SchematicRotateMeta.class, new int[]{0, 1, 2, 3}, false);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150471_bO, SchematicLever.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150430_aB, SchematicLever.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150442_at, SchematicLever.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150348_b, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150352_o, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150366_p, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150365_q, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150369_x, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150482_ag, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150450_ax, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150439_ay, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150412_bA, SchematicStone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150351_n, SchematicGravel.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150488_af, SchematicRedstoneWire.class, new ItemStack(Items.field_151137_ax));
        SchematicRegistry.registerSchematicBlock(Blocks.field_150414_aQ, SchematicCustomStack.class, new ItemStack(Items.field_151105_aU));
        SchematicRegistry.registerSchematicBlock(Blocks.field_150426_aN, SchematicCustomStack.class, new ItemStack(Blocks.field_150426_aN));
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150416_aS, SchematicRedstoneDiode.class, Items.field_151107_aW);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150413_aR, SchematicRedstoneDiode.class, Items.field_151107_aW);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150455_bV, SchematicRedstoneDiode.class, Items.field_151132_bS);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150441_bU, SchematicRedstoneDiode.class, Items.field_151132_bS);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150379_bu, SchematicRedstoneLamp.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150374_bv, SchematicRedstoneLamp.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150355_j, SchematicFluid.class, new ItemStack(Items.field_151131_as));
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150358_i, SchematicFluid.class, new ItemStack(Items.field_151131_as));
        SchematicRegistry.registerSchematicBlock(Blocks.field_150353_l, SchematicFluid.class, new ItemStack(Items.field_151129_at));
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150356_k, SchematicFluid.class, new ItemStack(Items.field_151129_at));
        SchematicRegistry.registerSchematicBlock(Blocks.field_150410_aZ, SchematicGlassPane.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150397_co, SchematicGlassPane.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150331_J, SchematicPiston.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150326_M, SchematicPiston.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150320_F, SchematicPiston.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150428_aP, SchematicPumpkin.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150476_ad, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150446_ar, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150389_bf, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150390_bg, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150387_bl, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150372_bz, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150485_bF, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150487_bG, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150481_bH, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150370_cb, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150400_ck, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150401_cl, SchematicStairs.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150466_ao, SchematicDoor.class, new ItemStack(Items.field_151135_aq));
        SchematicRegistry.registerSchematicBlock(Blocks.field_150454_av, SchematicDoor.class, new ItemStack(Items.field_151139_aw));
        SchematicRegistry.registerSchematicBlock(Blocks.field_150324_C, SchematicBed.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150444_as, SchematicSign.class, true);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150472_an, SchematicSign.class, false);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150427_aO, SchematicPortal.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150448_aq, SchematicRail.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150408_cc, SchematicRail.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150319_E, SchematicRail.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150318_D, SchematicRail.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150480_ab, SchematicFire.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150357_h, SchematicBlockCreative.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150474_ac, SchematicTileCreative.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150359_w, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150333_U, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150334_T, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150376_bx, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150373_bw, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150399_cn, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150422_aJ, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)Blocks.field_150453_bW, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock(Blocks.field_150411_aY, SchematicStandalone.class, new Object[0]);
        SchematicRegistry.registerSchematicEntity(EntityMinecartEmpty.class, SchematicMinecart.class, Items.field_151143_au);
        SchematicRegistry.registerSchematicEntity(EntityMinecartFurnace.class, SchematicMinecart.class, Items.field_151109_aJ);
        SchematicRegistry.registerSchematicEntity(EntityMinecartTNT.class, SchematicMinecart.class, Items.field_151142_bV);
        SchematicRegistry.registerSchematicEntity(EntityMinecartChest.class, SchematicMinecart.class, Items.field_151108_aI);
        SchematicRegistry.registerSchematicEntity(EntityMinecartHopper.class, SchematicMinecart.class, Items.field_151140_bW);
        SchematicRegistry.registerSchematicEntity(EntityPainting.class, SchematicHanging.class, Items.field_151159_an);
        SchematicRegistry.registerSchematicEntity(EntityItemFrame.class, SchematicHanging.class, Items.field_151160_bD);
        SchematicRegistry.registerSchematicBlock((Block)architectBlock, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock((Block)builderBlock, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        SchematicRegistry.registerSchematicBlock((Block)markerBlock, SchematicWallSide.class, new Object[0]);
        SchematicRegistry.registerSchematicBlock((Block)pathMarkerBlock, SchematicWallSide.class, new Object[0]);
        SchematicFactory.registerSchematicFactory(SchematicBlock.class, new SchematicFactoryBlock());
        SchematicFactory.registerSchematicFactory(SchematicMask.class, new SchematicFactoryMask());
        SchematicFactory.registerSchematicFactory(SchematicEntity.class, new SchematicFactoryEntity());
        BlueprintDeployer.instance = new RealBlueprintDeployer();
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftBuilders.loadRecipes();
        }
        BuilderProxy.proxy.registerBlockRenderers();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        templateItem = new ItemBlueprintTemplate();
        templateItem.func_77655_b("templateItem");
        CoreProxy.proxy.registerItem(templateItem);
        blueprintItem = new ItemBlueprintStandard();
        blueprintItem.func_77655_b("blueprintItem");
        CoreProxy.proxy.registerItem(blueprintItem);
        buildToolBlock = new BlockBuildTool();
        CoreProxy.proxy.registerBlock(buildToolBlock);
        markerBlock = new BlockMarker();
        CoreProxy.proxy.registerBlock(markerBlock.func_149663_c("markerBlock"));
        pathMarkerBlock = new BlockPathMarker();
        CoreProxy.proxy.registerBlock(pathMarkerBlock.func_149663_c("pathMarkerBlock"));
        fillerBlock = new BlockFiller();
        CoreProxy.proxy.registerBlock(fillerBlock.func_149663_c("fillerBlock"));
        builderBlock = new BlockBuilder();
        CoreProxy.proxy.registerBlock(builderBlock.func_149663_c("builderBlock"));
        architectBlock = new BlockArchitect();
        CoreProxy.proxy.registerBlock(architectBlock.func_149663_c("architectBlock"));
        libraryBlock = new BlockBlueprintLibrary();
        CoreProxy.proxy.registerBlock(libraryBlock.func_149663_c("libraryBlock"));
        GameRegistry.registerTileEntity(TileMarker.class, (String)"Marker");
        GameRegistry.registerTileEntity(TileFiller.class, (String)"Filler");
        GameRegistry.registerTileEntity(TileBuilder.class, (String)"net.minecraft.src.builders.TileBuilder");
        GameRegistry.registerTileEntity(TileArchitect.class, (String)"net.minecraft.src.builders.TileTemplate");
        GameRegistry.registerTileEntity(TilePathMarker.class, (String)"net.minecraft.src.builders.TilePathMarker");
        GameRegistry.registerTileEntity(TileBlueprintLibrary.class, (String)"net.minecraft.src.builders.TileBlueprintLibrary");
        SchematicRegistry.readConfiguration(BuildCraftCore.mainConfiguration);
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            FillerManager.registry = new FillerRegistry();
            FillerManager.registry.addPattern(PatternFill.INSTANCE);
            FillerManager.registry.addPattern(new PatternFlatten());
            FillerManager.registry.addPattern(new PatternHorizon());
            FillerManager.registry.addPattern(new PatternClear());
            FillerManager.registry.addPattern(new PatternBox());
            FillerManager.registry.addPattern(new PatternPyramid());
            FillerManager.registry.addPattern(new PatternStairs());
            FillerManager.registry.addPattern(new PatternCylinder());
            FillerManager.registry.addPattern(new PatternFrame());
        }
        catch (Error error) {
            BCLog.logErrorAPI("Buildcraft", error, IFillerPattern.class);
            throw error;
        }
        ActionManager.registerActionProvider(new BuildersActionProvider());
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)templateItem, 1), "ppp", "pip", "ppp", Character.valueOf('i'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('p'), Items.field_151121_aF);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)blueprintItem, 1), "ppp", "pip", "ppp", Character.valueOf('i'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('p'), Items.field_151121_aF);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)markerBlock, 1), "l ", "r ", Character.valueOf('l'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('r'), Blocks.field_150429_aA);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pathMarkerBlock, 1), "l ", "r ", Character.valueOf('l'), new ItemStack(Items.field_151100_aR, 1, 2), Character.valueOf('r'), Blocks.field_150429_aA);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)fillerBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ItemStack(Items.field_151100_aR, 1, 11), Character.valueOf('c'), Blocks.field_150462_ai, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('C'), Blocks.field_150486_ae});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)builderBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ItemStack(Items.field_151100_aR, 1, 11), Character.valueOf('c'), Blocks.field_150462_ai, Character.valueOf('g'), BuildCraftCore.diamondGearItem, Character.valueOf('C'), Blocks.field_150486_ae});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)architectBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ItemStack(Items.field_151100_aR, 1, 11), Character.valueOf('c'), Blocks.field_150462_ai, Character.valueOf('g'), BuildCraftCore.diamondGearItem, Character.valueOf('C'), new ItemStack((Item)blueprintItem, 1)});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)libraryBlock, 1), "bbb", "bBb", "bbb", Character.valueOf('b'), new ItemStack((Item)blueprintItem), Character.valueOf('B'), Blocks.field_150342_X);
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent event) {
        TilePathMarker.clearAvailableMarkersList();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        if (evt.map.func_130086_a() == 0) {
            for (FillerPattern pattern : FillerPattern.patterns.values()) {
                pattern.registerIcon((IIconRegister)evt.map);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            UrbanistToolsIconProvider.INSTANCE.registerIcons((IIconRegister)event.map);
        }
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileBlueprintLibrary.class.getCanonicalName());
    }
}

