/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.core.blueprints.BuildingSlotBlock;
import java.util.Iterator;
import java.util.LinkedList;

public class BuildingSlotIterator {
    private static int ITERATIONS_MAX = 1000;
    private LinkedList<BuildingSlotBlock> buildList;
    private Iterator<BuildingSlotBlock> current;
    private int nbIterations;

    public BuildingSlotIterator(LinkedList<BuildingSlotBlock> buildList) {
        this.buildList = buildList;
    }

    public void startIteration() {
        if (this.current == null || !this.current.hasNext()) {
            this.current = this.buildList.iterator();
        }
        this.nbIterations = 0;
    }

    public boolean hasNext() {
        return this.current.hasNext() && this.nbIterations < ITERATIONS_MAX;
    }

    public BuildingSlotBlock next() {
        BuildingSlotBlock next = this.current.next();
        if (next == null && this.nbIterations == 0) {
            this.current.remove();
        }
        ++this.nbIterations;
        return next;
    }

    public void remove() {
        this.current.remove();
    }

    public void reset() {
        this.current = this.buildList.iterator();
        this.nbIterations = 0;
    }
}

