/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.JavaTools;
import buildcraft.core.DefaultProps;
import buildcraft.core.network.PacketRPCPipe;
import buildcraft.core.network.PacketRPCTile;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCMessageInfo;
import buildcraft.core.network.serializers.ClassMapping;
import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public final class RPCHandler {
    public static int MAX_PACKET_SIZE = 30720;
    private static Map<String, RPCHandler> handlers = new TreeMap<String, RPCHandler>();
    private Map<String, Integer> methodsMap = new TreeMap<String, Integer>();
    private MethodMapping[] methods;

    private RPCHandler(Class c) {
        Method[] sortedMethods = JavaTools.getAllMethods(c).toArray(new Method[0]);
        LinkedList<MethodMapping> mappings = new LinkedList<MethodMapping>();
        Arrays.sort(sortedMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        LinkedList<Method> rpcMethods = new LinkedList<Method>();
        for (Method sortedMethod : sortedMethods) {
            if (sortedMethod.getAnnotation(RPC.class) == null) continue;
            sortedMethod.setAccessible(true);
            this.methodsMap.put(sortedMethod.getName(), rpcMethods.size());
            rpcMethods.add(sortedMethod);
            MethodMapping mapping = new MethodMapping();
            mapping.method = sortedMethod;
            mapping.parameters = sortedMethod.getParameterTypes();
            mapping.mappings = new ClassSerializer[mapping.parameters.length];
            for (int j = 0; j < mapping.parameters.length; ++j) {
                if (Integer.TYPE.equals(mapping.parameters[j]) || Character.TYPE.equals(mapping.parameters[j]) || Float.TYPE.equals(mapping.parameters[j])) continue;
                if (mapping.parameters[j].equals(RPCMessageInfo.class)) {
                    mapping.hasInfo = true;
                    continue;
                }
                mapping.mappings[j] = ClassMapping.get(mapping.parameters[j]);
            }
            mappings.add(mapping);
        }
        this.methods = mappings.toArray(new MethodMapping[mappings.size()]);
    }

    public static void rpcServer(TileEntity tile, String method, Object ... actuals) {
        PacketRPCTile packet;
        if (!handlers.containsKey(tile.getClass().getName())) {
            handlers.put(tile.getClass().getName(), new RPCHandler(tile.getClass()));
        }
        if ((packet = handlers.get(tile.getClass().getName()).createRCPPacket(tile, method, actuals)) != null) {
            ArrayList<PacketRPCTile> packets = packet.breakIntoSmallerPackets(30720);
            for (PacketRPCTile p : packet.breakIntoSmallerPackets(MAX_PACKET_SIZE)) {
                BuildCraftCore.instance.sendToServer(p);
            }
        }
    }

    public static void rpcPlayer(TileEntity tile, String method, EntityPlayer player, Object ... actuals) {
        PacketRPCTile packet;
        if (!handlers.containsKey(tile.getClass().getName())) {
            handlers.put(tile.getClass().getName(), new RPCHandler(tile.getClass()));
        }
        if ((packet = handlers.get(tile.getClass().getName()).createRCPPacket(tile, method, actuals)) != null) {
            for (PacketRPCTile p : packet.breakIntoSmallerPackets(MAX_PACKET_SIZE)) {
                BuildCraftCore.instance.sendToPlayer(player, p);
            }
        }
    }

    public static void rpcBroadcastDefaultPlayers(Pipe pipe, String method, Object ... actuals) {
        RPCHandler.rpcBroadcastPlayers(pipe, method, DefaultProps.NETWORK_UPDATE_RANGE, actuals);
    }

    public static void rpcBroadcastPlayers(TileEntity tile, String method, Object ... actuals) {
        RPCHandler.rpcBroadcastPlayersAtDistance(tile, method, DefaultProps.NETWORK_UPDATE_RANGE, actuals);
    }

    public static void rpcBroadcastPlayersAtDistance(TileEntity tile, String method, int maxDistance, Object ... actuals) {
        PacketRPCTile packet;
        if (!handlers.containsKey(tile.getClass().getName())) {
            handlers.put(tile.getClass().getName(), new RPCHandler(tile.getClass()));
        }
        if ((packet = handlers.get(tile.getClass().getName()).createRCPPacket(tile, method, actuals)) != null) {
            for (PacketRPCTile p : packet.breakIntoSmallerPackets(MAX_PACKET_SIZE)) {
                for (Object o : tile.func_145831_w().field_73010_i) {
                    EntityPlayerMP player = (EntityPlayerMP)o;
                    if (!(Math.abs(player.field_70165_t - (double)tile.field_145851_c) <= (double)maxDistance) || !(Math.abs(player.field_70163_u - (double)tile.field_145848_d) <= (double)maxDistance) || !(Math.abs(player.field_70161_v - (double)tile.field_145849_e) <= (double)maxDistance)) continue;
                    BuildCraftCore.instance.sendToPlayer((EntityPlayer)player, p);
                }
            }
        }
    }

    public static void rpcBroadcastPlayers(Pipe pipe, String method, int maxDistance, Object ... actuals) {
        PacketRPCPipe packet;
        if (!handlers.containsKey(pipe.getClass().getName())) {
            handlers.put(pipe.getClass().getName(), new RPCHandler(pipe.getClass()));
        }
        if ((packet = handlers.get(pipe.getClass().getName()).createRCPPacket(pipe, method, actuals)) != null) {
            for (Object o : pipe.container.getWorld().field_73010_i) {
                EntityPlayerMP player = (EntityPlayerMP)o;
                if (!(Math.abs(player.field_70165_t - (double)pipe.container.field_145851_c) <= (double)maxDistance) || !(Math.abs(player.field_70163_u - (double)pipe.container.field_145848_d) <= (double)maxDistance) || !(Math.abs(player.field_70161_v - (double)pipe.container.field_145849_e) <= (double)maxDistance)) continue;
                BuildCraftCore.instance.sendToPlayer((EntityPlayer)player, packet);
            }
        }
    }

    public static void receiveRPC(TileEntity tile, RPCMessageInfo info, ByteBuf data) {
        if (tile != null) {
            if (!handlers.containsKey(tile.getClass().getName())) {
                handlers.put(tile.getClass().getName(), new RPCHandler(tile.getClass()));
            }
            handlers.get(tile.getClass().getName()).internalRpcReceive(tile, info, data);
        }
    }

    public static void receiveRPC(Pipe pipe, RPCMessageInfo info, ByteBuf data) {
        if (pipe != null) {
            if (!handlers.containsKey(pipe.getClass().getName())) {
                handlers.put(pipe.getClass().getName(), new RPCHandler(pipe.getClass()));
            }
            handlers.get(pipe.getClass().getName()).internalRpcReceive(pipe, info, data);
        }
    }

    private PacketRPCPipe createRCPPacket(Pipe pipe, String method, Object ... actuals) {
        ByteBuf data = Unpooled.buffer();
        try {
            TileGenericPipe tile = pipe.container;
            data.writeShort(tile.func_145831_w().field_73011_w.field_76574_g);
            data.writeInt(tile.field_145851_c);
            data.writeInt(tile.field_145848_d);
            data.writeInt(tile.field_145849_e);
            this.writeParameters(method, data, actuals);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        byte[] bytes = new byte[data.readableBytes()];
        data.readBytes(bytes);
        return new PacketRPCPipe(bytes);
    }

    private PacketRPCTile createRCPPacket(TileEntity tile, String method, Object ... actuals) {
        ByteBuf data = Unpooled.buffer();
        try {
            this.writeParameters(method, data, actuals);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        byte[] bytes = new byte[data.readableBytes()];
        data.readBytes(bytes);
        return new PacketRPCTile(tile, bytes);
    }

    private void writeParameters(String method, ByteBuf data, Object ... actuals) throws IOException, IllegalArgumentException, IllegalAccessException {
        int expectedParameters;
        if (!this.methodsMap.containsKey(method)) {
            throw new RuntimeException(method + " is not a callable method of " + this.getClass().getName());
        }
        int methodIndex = this.methodsMap.get(method);
        MethodMapping m = this.methods[methodIndex];
        Class[] formals = m.parameters;
        int n = expectedParameters = m.hasInfo ? formals.length - 1 : formals.length;
        if (expectedParameters != actuals.length) {
            throw new RuntimeException(this.getClass().getName() + "." + method + " expects " + m.parameters.length + " parameters, not " + actuals.length);
        }
        data.writeShort(methodIndex);
        SerializationContext context = new SerializationContext();
        for (int i = 0; i < actuals.length; ++i) {
            if (Integer.TYPE.equals(formals[i])) {
                data.writeInt(((Integer)actuals[i]).intValue());
                continue;
            }
            if (Float.TYPE.equals(formals[i])) {
                data.writeFloat(((Float)actuals[i]).floatValue());
                continue;
            }
            if (Character.TYPE.equals(formals[i])) {
                data.writeChar((int)((Character)actuals[i]).charValue());
                continue;
            }
            m.mappings[i].write(data, actuals[i], context);
        }
    }

    private void internalRpcReceive(Object o, RPCMessageInfo info, ByteBuf data) {
        try {
            short methodIndex = data.readShort();
            MethodMapping m = this.methods[methodIndex];
            Class[] formals = m.parameters;
            Object[] actuals = new Object[formals.length];
            int expectedParameters = m.hasInfo ? formals.length - 1 : formals.length;
            SerializationContext context = new SerializationContext();
            for (int i = 0; i < expectedParameters; ++i) {
                actuals[i] = Integer.TYPE.equals(formals[i]) ? Integer.valueOf(data.readInt()) : (Float.TYPE.equals(formals[i]) ? Float.valueOf(data.readFloat()) : (Character.TYPE.equals(formals[i]) ? Character.valueOf(data.readChar()) : m.mappings[i].read(data, actuals[i], context)));
            }
            if (m.hasInfo) {
                actuals[actuals.length - 1] = info;
            }
            m.method.invoke(o, actuals);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    class MethodMapping {
        Method method;
        Class[] parameters;
        ClassSerializer[] mappings;
        boolean hasInfo = false;

        MethodMapping() {
        }
    }
}

