/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.serializers.ClassMapping;
import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;

public class TilePacketWrapper {
    ClassSerializer[] rootMappings;

    public TilePacketWrapper(Class c) {
        this(new Class[]{c});
    }

    public TilePacketWrapper(Class[] c) {
        this.rootMappings = new ClassSerializer[c.length];
        for (int i = 0; i < c.length; ++i) {
            this.rootMappings[i] = ClassMapping.get(c[i]);
        }
    }

    public PacketPayload toPayload(final TileEntity tile) {
        return new PacketPayload(new PacketPayload.StreamWriter(){

            @Override
            public void writeData(ByteBuf data) {
                data.writeInt(tile.field_145851_c);
                data.writeInt(tile.field_145848_d);
                data.writeInt(tile.field_145849_e);
                try {
                    SerializationContext context = new SerializationContext();
                    TilePacketWrapper.this.rootMappings[0].write(data, tile, context);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public PacketPayload toPayload(Object obj) {
        return this.toPayload(0, 0, 0, new Object[]{obj});
    }

    public PacketPayload toPayload(int x, int y, int z, Object obj) {
        return this.toPayload(x, y, z, new Object[]{obj});
    }

    public PacketPayload toPayload(final int x, final int y, final int z, final Object[] obj) {
        return new PacketPayload(new PacketPayload.StreamWriter(){

            @Override
            public void writeData(ByteBuf data) {
                data.writeInt(x);
                data.writeInt(y);
                data.writeInt(z);
                for (int i = 0; i < TilePacketWrapper.this.rootMappings.length; ++i) {
                    try {
                        SerializationContext context = new SerializationContext();
                        TilePacketWrapper.this.rootMappings[0].write(data, obj[i], context);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void fromPayload(TileEntity tile, PacketPayload packet) {
        try {
            ByteBuf data = packet.stream;
            data.readInt();
            data.readInt();
            data.readInt();
            SerializationContext context = new SerializationContext();
            this.rootMappings[0].read(data, tile, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fromPayload(Object obj, PacketPayload packet) {
        this.fromPayload(new Object[]{obj}, packet);
    }

    public void fromPayload(Object[] obj, PacketPayload packet) {
        try {
            ByteBuf data = packet.stream;
            data.readInt();
            data.readInt();
            data.readInt();
            for (int i = 0; i < this.rootMappings.length; ++i) {
                SerializationContext context = new SerializationContext();
                this.rootMappings[i].read(data, obj[i], context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

