/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network.serializers;

import buildcraft.core.network.serializers.ClassMapping;
import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;

public class SerializerObject
extends ClassSerializer {
    @Override
    public void write(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException {
        if (o == null) {
            data.writeBoolean(false);
        } else {
            ClassSerializer delegateMapping;
            data.writeBoolean(true);
            Class<?> realClass = o.getClass();
            if (context.classToId.containsKey(realClass.getCanonicalName())) {
                int index = context.classToId.get(realClass.getCanonicalName()) + 1;
                data.writeByte(index);
                delegateMapping = context.idToClass.get(index - 1);
            } else {
                int index = context.classToId.size() + 1;
                delegateMapping = ClassMapping.get(realClass);
                data.writeByte(index);
                Utils.writeUTF(data, realClass.getCanonicalName());
                context.classToId.put(realClass.getCanonicalName(), context.classToId.size());
                context.idToClass.add(delegateMapping);
            }
            if (delegateMapping instanceof ClassMapping) {
                ((ClassMapping)delegateMapping).writeClass(o, data, context);
            } else {
                delegateMapping.write(data, o, context);
            }
        }
    }

    @Override
    public Object read(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        ClassSerializer delegateMapping;
        if (!data.readBoolean()) {
            return null;
        }
        byte index = data.readByte();
        if (context.idToClass.size() < index) {
            String className = Utils.readUTF(data);
            Class<?> cls = Class.forName(className);
            delegateMapping = ClassMapping.get(cls);
            context.idToClass.add(ClassMapping.get(cls));
        } else {
            delegateMapping = context.idToClass.get(index - 1);
        }
        if (delegateMapping instanceof ClassMapping) {
            return ((ClassMapping)delegateMapping).readClass(o, data, context);
        }
        return delegateMapping.read(data, o, context);
    }
}

