/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyReceiver
extends TileBuildCraft
implements IPipeConnection,
IPowerEmitter {
    public static LinkedList<TileEnergyReceiver> knownReceivers = new LinkedList();
    public float energyStored = 0.0f;
    private TileBuffer[] tileCache;

    public TileEnergyReceiver() {
        knownReceivers.add(this);
    }

    @Override
    public void func_145843_s() {
        knownReceivers.remove(this);
    }

    public TileBuffer getTileBuffer(ForgeDirection side) {
        if (this.tileCache == null) {
            this.tileCache = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
        return this.tileCache[side.ordinal()];
    }

    public boolean isPoweredTile(TileEntity tile, ForgeDirection side) {
        if (tile instanceof IPowerReceptor) {
            return ((IPowerReceptor)tile).getPowerReceiver(side.getOpposite()) != null;
        }
        return MjAPI.getMjBattery(tile) != null;
    }

    private void sendPower() {
        for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
            IBatteryObject battery;
            TileEntity tile = this.getTileBuffer(s).getTile();
            if (tile instanceof IPowerReceptor) {
                PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(s.getOpposite());
                if (receptor == null) continue;
                receptor.receiveEnergy(PowerHandler.Type.ENGINE, this.energyStored, s.getOpposite());
                this.energyStored = 0.0f;
                continue;
            }
            if (tile == null || (battery = MjAPI.getMjBattery(tile)) == null) continue;
            battery.addEnergy(this.energyStored);
            this.energyStored = 0.0f;
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.POWER ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public void func_145845_h() {
        this.sendPower();
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return true;
    }
}

