/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.gates.ITrigger;
import buildcraft.core.IItemPipe;
import buildcraft.core.fluids.FluidUtils;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.inventory.InvUtils;
import buildcraft.energy.TileEngineWithInventory;
import buildcraft.energy.gui.ContainerEngine;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEngineIron
extends TileEngineWithInventory
implements IFluidHandler {
    public static int MAX_LIQUID = 10000;
    public static float HEAT_PER_MJ = 0.0023f;
    public static float COOLDOWN_RATE = 0.05f;
    public static int MAX_COOLANT_PER_TICK = 40;
    public Tank tankFuel = new Tank("tankFuel", MAX_LIQUID, this);
    public Tank tankCoolant = new Tank("tankCoolant", MAX_LIQUID, this);
    private int burnTime = 0;
    private TankManager tankManager = new TankManager();
    private IronEngineFuel.Fuel currentFuel = null;
    private int penaltyCooling = 0;
    private boolean lastPowered = false;
    private BiomeGenBase biomeCache;

    public TileEngineIron() {
        super(1);
        this.tankManager.add((Object)this.tankFuel);
        this.tankManager.add((Object)this.tankCoolant);
    }

    @Override
    public ResourceLocation getBaseTexture() {
        return BASE_TEXTURES[2];
    }

    @Override
    public ResourceLocation getChamberTexture() {
        return CHAMBER_TEXTURES[2];
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (player.func_71045_bC() != null) {
            if (player.func_71045_bC().func_77973_b() instanceof IItemPipe) {
                return false;
            }
            ItemStack current = player.func_71045_bC();
            if (current != null && (!this.field_145850_b.field_72995_K ? FluidUtils.handleRightClick(this, side, player, true, true) : FluidContainerRegistry.isContainer((ItemStack)current))) {
                return true;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)BuildCraftEnergy.instance, 20, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public float explosionRange() {
        return 4.0f;
    }

    @Override
    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.07f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.04f;
            }
            case GREEN: {
                return 0.05f;
            }
            case YELLOW: {
                return 0.06f;
            }
            case RED: {
                return 0.07f;
            }
        }
        return 0.0f;
    }

    private float getBiomeTempScalar() {
        if (this.biomeCache == null) {
            this.biomeCache = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
        }
        float tempScalar = this.biomeCache.field_76750_F - 1.0f;
        tempScalar *= 0.5f;
        return tempScalar += 1.0f;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.biomeCache = null;
    }

    @Override
    public boolean isBurning() {
        FluidStack fuel = this.tankFuel.getFluid();
        return fuel != null && fuel.amount > 0 && this.penaltyCooling == 0 && this.isRedstonePowered;
    }

    @Override
    public void burn() {
        FluidStack fuel = this.tankFuel.getFluid();
        if (this.currentFuel == null && fuel != null) {
            this.currentFuel = IronEngineFuel.getFuelForFluid(fuel.getFluid());
        }
        if (this.currentFuel == null) {
            return;
        }
        if (this.penaltyCooling <= 0 && this.isRedstonePowered) {
            this.lastPowered = true;
            if (this.burnTime > 0 || fuel != null && fuel.amount > 0) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                }
                if (this.burnTime <= 0) {
                    if (fuel != null) {
                        if (--fuel.amount <= 0) {
                            this.tankFuel.setFluid(null);
                        }
                        this.burnTime = this.currentFuel.totalBurningTime / 1000;
                    } else {
                        this.currentFuel = null;
                        return;
                    }
                }
                this.currentOutput = this.currentFuel.powerPerCycle;
                this.addEnergy(this.currentFuel.powerPerCycle);
                this.heat += this.currentFuel.powerPerCycle * HEAT_PER_MJ * this.getBiomeTempScalar();
            }
        } else if (this.penaltyCooling <= 0 && this.lastPowered) {
            this.lastPowered = false;
            this.penaltyCooling = 10;
        }
    }

    @Override
    public void updateHeatLevel() {
    }

    @Override
    public void engineUpdate() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (liquid == null && this.heat > 40.0f) {
                liquid = IronEngineCoolant.getFluidCoolant(stack);
            }
            if (liquid != null && this.fill(ForgeDirection.UNKNOWN, liquid, false) == liquid.amount) {
                this.fill(ForgeDirection.UNKNOWN, liquid, true);
                this.func_70299_a(0, InvUtils.consumeItem(stack));
            }
        }
        if (this.heat > 20.0f && (this.penaltyCooling > 0 || !this.isRedstonePowered)) {
            this.heat -= COOLDOWN_RATE;
            this.coolEngine(20.0f);
            this.getEnergyStage();
        } else if (this.heat > 100.0f) {
            this.coolEngine(100.0f);
        }
        if (this.heat <= 20.0f && this.penaltyCooling > 0) {
            --this.penaltyCooling;
        }
        if (this.heat <= 20.0f) {
            this.heat = 20.0f;
        }
    }

    private void coolEngine(float idealHeat) {
        float extraHeat = this.heat - idealHeat;
        FluidStack coolant = this.tankCoolant.getFluid();
        if (coolant == null) {
            return;
        }
        int coolantAmount = Math.min(MAX_COOLANT_PER_TICK, coolant.amount);
        IronEngineCoolant.Coolant currentCoolant = IronEngineCoolant.getCoolant(coolant);
        if (currentCoolant != null) {
            float cooling = currentCoolant.getDegreesCoolingPerMB(this.heat);
            if ((float)coolantAmount * (cooling /= this.getBiomeTempScalar()) > extraHeat) {
                this.tankCoolant.drain(Math.round(extraHeat / cooling), true);
                this.heat -= extraHeat;
            } else {
                this.tankCoolant.drain(coolantAmount, true);
                this.heat -= (float)coolantAmount * cooling;
            }
        }
    }

    @Override
    public int getScaledBurnTime(int i) {
        return this.tankFuel.getFluid() != null ? (int)((float)this.tankFuel.getFluid().amount / (float)MAX_LIQUID * (float)i) : 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readFromNBT(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.penaltyCooling = data.func_74762_e("penaltyCooling");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeToNBT(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("penaltyCooling", this.penaltyCooling);
    }

    public int getScaledCoolant(int i) {
        return this.tankCoolant.getFluid() != null ? (int)((float)this.tankCoolant.getFluid().amount / (float)MAX_LIQUID * (float)i) : 0;
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        switch (id) {
            case 15: {
                if (this.tankFuel.getFluid() == null) {
                    this.tankFuel.setFluid(new FluidStack(value, 0));
                    break;
                }
                this.tankFuel.getFluid().fluidID = value;
                break;
            }
            case 16: {
                if (this.tankCoolant.getFluid() == null) {
                    this.tankCoolant.setFluid(new FluidStack(value, 0));
                    break;
                }
                this.tankCoolant.getFluid().fluidID = value;
                break;
            }
            case 17: {
                if (this.tankFuel.getFluid() == null) {
                    this.tankFuel.setFluid(new FluidStack(0, value));
                    break;
                }
                this.tankFuel.getFluid().amount = value;
                break;
            }
            case 18: {
                if (this.tankCoolant.getFluid() == null) {
                    this.tankCoolant.setFluid(new FluidStack(0, value));
                    break;
                }
                this.tankCoolant.getFluid().amount = value;
                break;
            }
            case 19: {
                this.tankFuel.colorRenderCache = value;
                break;
            }
            case 20: {
                this.tankCoolant.colorRenderCache = value;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        super.sendGUINetworkData(containerEngine, iCrafting);
        iCrafting.func_71112_a((Container)containerEngine, 15, this.tankFuel.getFluid() != null ? this.tankFuel.getFluid().fluidID : 0);
        iCrafting.func_71112_a((Container)containerEngine, 16, this.tankCoolant.getFluid() != null ? this.tankCoolant.getFluid().fluidID : 0);
        iCrafting.func_71112_a((Container)containerEngine, 17, this.tankFuel.getFluid() != null ? this.tankFuel.getFluid().amount : 0);
        iCrafting.func_71112_a((Container)containerEngine, 18, this.tankCoolant.getFluid() != null ? this.tankCoolant.getFluid().amount : 0);
        iCrafting.func_71112_a((Container)containerEngine, 19, this.tankFuel.colorRenderCache);
        iCrafting.func_71112_a((Container)containerEngine, 20, this.tankCoolant.colorRenderCache);
    }

    @Override
    public boolean isActive() {
        return this.penaltyCooling <= 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankFuel.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (this.tankCoolant.getFluidType() == resource.getFluid()) {
            return this.tankCoolant.drain(resource.amount, doDrain);
        }
        if (this.tankFuel.getFluidType() == resource.getFluid()) {
            return this.tankFuel.drain(resource.amount, doDrain);
        }
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (IronEngineCoolant.getCoolant(resource) != null) {
            return this.tankCoolant.fill(resource, doFill);
        }
        if (IronEngineFuel.getFuelForFluid(resource.getFluid()) != null) {
            return this.tankFuel.fill(resource, doFill);
        }
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (IronEngineCoolant.isCoolant(fluid)) {
            return true;
        }
        return IronEngineFuel.getFuelForFluid(fluid) != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo(direction);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (IronEngineCoolant.getCoolant(itemstack) != null) {
            return true;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack) != null;
    }

    public FluidStack getFuel() {
        return this.tankFuel.getFluid();
    }

    public FluidStack getCoolant() {
        return this.tankCoolant.getFluid();
    }

    @Override
    public double maxEnergyReceived() {
        return 2000.0;
    }

    @Override
    public double maxEnergyExtracted() {
        return 500.0;
    }

    @Override
    public double getMaxEnergy() {
        return 10000.0;
    }

    @Override
    public double getCurrentOutput() {
        if (this.currentFuel == null) {
            return 0.0;
        }
        return this.currentFuel.powerPerCycle;
    }

    @Override
    public LinkedList<ITrigger> getTriggers() {
        LinkedList<ITrigger> triggers = super.getTriggers();
        triggers.add(BuildCraftCore.triggerEmptyFluid);
        triggers.add(BuildCraftCore.triggerContainsFluid);
        triggers.add(BuildCraftCore.triggerSpaceFluid);
        triggers.add(BuildCraftCore.triggerFullFluid);
        triggers.add(BuildCraftCore.triggerFluidContainerBelow25);
        triggers.add(BuildCraftCore.triggerFluidContainerBelow50);
        triggers.add(BuildCraftCore.triggerFluidContainerBelow75);
        return triggers;
    }

    public boolean func_145818_k_() {
        return false;
    }
}

