/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.power.ILaserTarget;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.utils.AverageUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileLaserTableBase
extends TileBuildCraft
implements ILaserTarget,
IInventory,
IActionReceptor,
IMachine {
    public double clientRequiredEnergy = 0.0;
    protected SimpleInventory inv = new SimpleInventory(this.func_70302_i_(), "inv", 64);
    protected ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;
    private double energy = 0.0;
    private int recentEnergyAverage;
    private AverageUtil recentEnergyAverageUtil = new AverageUtil(20);

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.recentEnergyAverageUtil.tick();
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public void addEnergy(double energy) {
        this.energy += energy;
    }

    public void subtractEnergy(double energy) {
        this.energy -= energy;
    }

    public abstract double getRequiredEnergy();

    public int getProgressScaled(int ratio) {
        if (this.clientRequiredEnergy == 0.0) {
            return 0;
        }
        if (this.energy >= this.clientRequiredEnergy) {
            return ratio;
        }
        return (int)(this.energy / this.clientRequiredEnergy * (double)ratio);
    }

    public int getRecentEnergyAverage() {
        return this.recentEnergyAverage;
    }

    public abstract boolean canCraft();

    @Override
    public boolean requiresLaserEnergy() {
        return this.canCraft() && this.energy < this.getRequiredEnergy() * 5.0;
    }

    @Override
    public void receiveLaserEnergy(double energy) {
        this.energy += energy;
        this.recentEnergyAverageUtil.push(energy);
    }

    @Override
    public boolean isInvalidTarget() {
        return this.func_145837_r();
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && !this.func_145837_r();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt, "inv");
        nbt.func_74780_a("energy", this.energy);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt, "inv");
        this.energy = nbt.func_74769_h("energy");
    }

    public void getGUINetworkData(int id, int data) {
        int currentStored = (int)(this.energy * 100.0);
        int requiredEnergy = (int)(this.clientRequiredEnergy * 100.0);
        switch (id) {
            case 0: {
                requiredEnergy = requiredEnergy & 0xFFFF0000 | data & 0xFFFF;
                this.clientRequiredEnergy = (float)requiredEnergy / 100.0f;
                break;
            }
            case 1: {
                currentStored = currentStored & 0xFFFF0000 | data & 0xFFFF;
                this.energy = (float)currentStored / 100.0f;
                break;
            }
            case 2: {
                requiredEnergy = requiredEnergy & 0xFFFF | (data & 0xFFFF) << 16;
                this.clientRequiredEnergy = (float)requiredEnergy / 100.0f;
                break;
            }
            case 3: {
                currentStored = currentStored & 0xFFFF | (data & 0xFFFF) << 16;
                this.energy = (float)currentStored / 100.0f;
                break;
            }
            case 4: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF0000 | data & 0xFFFF;
                break;
            }
            case 5: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF | (data & 0xFFFF) << 16;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int requiredEnergy = (int)(this.getRequiredEnergy() * 100.0);
        int currentStored = (int)(this.energy * 100.0);
        int lRecentEnergy = (int)(this.recentEnergyAverageUtil.getAverage() * 100.0);
        iCrafting.func_71112_a(container, 0, requiredEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 1, currentStored & 0xFFFF);
        iCrafting.func_71112_a(container, 2, requiredEnergy >>> 16 & 0xFFFF);
        iCrafting.func_71112_a(container, 3, currentStored >>> 16 & 0xFFFF);
        iCrafting.func_71112_a(container, 4, lRecentEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 5, lRecentEnergy >>> 16 & 0xFFFF);
    }

    @Override
    public boolean isActive() {
        return this.lastMode != ActionMachineControl.Mode.Off;
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return action == BuildCraftCore.actionOn || action == BuildCraftCore.actionOff;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        }
    }
}

