/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerHeat;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTransportPower
extends PipeTransport {
    public static final Map<Class<? extends Pipe>, Integer> powerCapacities = new HashMap<Class<? extends Pipe>, Integer>();
    private static final short MAX_DISPLAY = 100;
    private static final int DISPLAY_SMOOTHING = 10;
    private static final int OVERLOAD_TICKS = 60;
    public float[] displayPower = new float[6];
    public short[] clientDisplayPower = new short[6];
    public int overload;
    public double[] nextPowerQuery = new double[6];
    public double[] internalNextPower = new double[6];
    public double maxPower = 8.0;
    public float[] movementStage = new float[]{0.0f, 0.0f, 0.0f};
    private boolean needsInit = true;
    private TileEntity[] tiles = new TileEntity[6];
    private float[] prevDisplayPower = new float[6];
    private double[] powerQuery = new double[6];
    private long currentDate;
    private double[] internalPower = new double[6];
    private double highestPower;
    private SafeTimeTracker tracker = new SafeTimeTracker(2 * BuildCraftCore.updateFactor);

    public PipeTransportPower() {
        int i;
        for (i = 0; i < 6; ++i) {
            this.powerQuery[i] = 0.0;
        }
        for (i = 0; i < 3; ++i) {
            this.movementStage[i] = (float)Math.random();
        }
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.POWER;
    }

    public void initFromPipe(Class<? extends Pipe> pipeClass) {
        this.maxPower = powerCapacities.get(pipeClass).intValue();
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        IPowerEmitter emitter;
        IPowerReceptor receptor;
        PowerHandler.PowerReceiver receiver;
        if (tile instanceof TileGenericPipe) {
            Pipe pipe2 = ((TileGenericPipe)tile).pipe;
            return !BlockGenericPipe.isValid(pipe2) || pipe2.transport instanceof PipeTransportPower;
        }
        if (tile instanceof IPowerReceptor && (receiver = (receptor = (IPowerReceptor)tile).getPowerReceiver(side.getOpposite())) != null && receiver.getType().canReceiveFromPipes()) {
            return true;
        }
        if (this.container.pipe instanceof PipePowerWood && tile instanceof IPowerEmitter && (emitter = (IPowerEmitter)tile).canEmitPowerFrom(side.getOpposite())) {
            return true;
        }
        return MjAPI.getMjBattery(tile, "buildcraft.kinesis", side.getOpposite()) != null;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.updateTiles();
    }

    private void updateTiles() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.container.getTile(side);
            if (this.container.isPipeConnected(side)) {
                this.tiles[side.ordinal()] = tile;
                continue;
            }
            this.tiles[side.ordinal()] = null;
            this.internalPower[side.ordinal()] = 0.0;
            this.internalNextPower[side.ordinal()] = 0.0;
            this.displayPower[side.ordinal()] = 0.0f;
        }
    }

    private void init() {
        if (this.needsInit) {
            this.needsInit = false;
            this.updateTiles();
        }
    }

    @Override
    public void updateEntity() {
        int i;
        PipeTransportPower nearbyTransport;
        TileGenericPipe nearbyTile;
        double powerConsumed;
        if (this.container.func_145831_w().field_72995_K) {
            for (int i2 = 0; i2 < 6; i2 += 2) {
                this.movementStage[i2 / 2] = (this.movementStage[i2 / 2] + 0.01f) % 1.0f;
            }
            return;
        }
        this.step();
        this.init();
        System.arraycopy(this.displayPower, 0, this.prevDisplayPower, 0, 6);
        Arrays.fill(this.displayPower, 0.0f);
        double totalPowerContained = 0.0;
        for (int in = 0; in < 6; ++in) {
            totalPowerContained += this.internalPower[in];
        }
        double totalPowerQuery = 0.0;
        for (int out = 0; out < 6; ++out) {
            if (this.internalPower[out] != 0.0) continue;
            totalPowerQuery += this.powerQuery[out];
        }
        double totalPowerConsumed = 0.0;
        if (totalPowerContained > 0.0) {
            for (int out = 0; out < 6; ++out) {
                if (!(this.powerQuery[out] > 0.0) || this.internalPower[out] != 0.0) continue;
                powerConsumed = this.powerQuery[out] / totalPowerQuery * totalPowerContained;
                if (this.tiles[out] instanceof TileGenericPipe) {
                    nearbyTile = (TileGenericPipe)this.tiles[out];
                    nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
                    powerConsumed = nearbyTransport.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[out].getOpposite(), powerConsumed);
                } else {
                    IBatteryObject battery = MjAPI.getMjBattery(this.tiles[out], "buildcraft.kinesis", ForgeDirection.VALID_DIRECTIONS[out].getOpposite());
                    if (battery != null) {
                        powerConsumed = battery.addEnergy(powerConsumed);
                    } else {
                        PowerHandler.PowerReceiver prov = this.getReceiverOnSide(ForgeDirection.VALID_DIRECTIONS[out]);
                        if (prov != null) {
                            powerConsumed = prov.receiveEnergy(PowerHandler.Type.PIPE, powerConsumed, ForgeDirection.VALID_DIRECTIONS[out].getOpposite());
                        }
                    }
                }
                int n = out;
                this.displayPower[n] = (float)((double)this.displayPower[n] + powerConsumed);
                totalPowerConsumed += powerConsumed;
            }
        }
        if (totalPowerConsumed > 0.0) {
            int in = 0;
            while (in < 6) {
                powerConsumed = this.internalPower[in] / totalPowerContained * totalPowerConsumed;
                int n = in++;
                this.displayPower[n] = (float)((double)this.displayPower[n] + powerConsumed);
            }
        }
        this.highestPower = 0.0;
        for (int i3 = 0; i3 < 6; ++i3) {
            this.displayPower[i3] = (this.prevDisplayPower[i3] * 9.0f + this.displayPower[i3]) / 10.0f;
            if ((double)this.displayPower[i3] > this.highestPower) {
                this.highestPower = this.displayPower[i3];
            }
            if (!((double)this.displayPower[i3] < 0.01)) continue;
            this.displayPower[i3] = 0.0f;
        }
        this.overload += this.highestPower > this.maxPower * 0.95 ? 1 : -1;
        if (this.overload < 0) {
            this.overload = 0;
        }
        if (this.overload > 60) {
            this.overload = 60;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IBatteryObject battery;
            double request;
            TileEntity tile = this.tiles[dir.ordinal()];
            if (tile instanceof TileGenericPipe && ((TileGenericPipe)tile).pipe.transport instanceof PipeTransportPower) continue;
            PowerHandler.PowerReceiver prov = this.getReceiverOnSide(dir);
            if (prov != null && (request = prov.powerRequest()) > 0.0) {
                this.requestEnergy(dir, request);
            }
            if (tile == null || (battery = MjAPI.getMjBattery(tile, "buildcraft.kinesis", dir.getOpposite())) == null) continue;
            this.requestEnergy(dir, battery.getEnergyRequested());
        }
        double[] transferQuery = new double[6];
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0.0;
            for (int j = 0; j < 6; ++j) {
                if (j == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j];
            }
            transferQuery[i] = Math.min(transferQuery[i], this.maxPower);
        }
        for (i = 0; i < 6; ++i) {
            TileEntity entity;
            if (transferQuery[i] == 0.0 || this.tiles[i] == null || !((entity = this.tiles[i]) instanceof TileGenericPipe)) continue;
            nearbyTile = (TileGenericPipe)entity;
            if (nearbyTile.pipe == null) continue;
            nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
            nearbyTransport.requestEnergy(ForgeDirection.VALID_DIRECTIONS[i].getOpposite(), transferQuery[i]);
        }
        if (this.tracker.markTimeIfDelay(this.container.func_145831_w())) {
            PacketPowerUpdate packet = new PacketPowerUpdate(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
            double displayFactor = 0.09765625;
            for (int i4 = 0; i4 < this.clientDisplayPower.length; ++i4) {
                this.clientDisplayPower[i4] = (short)Math.ceil((double)this.displayPower[i4] * displayFactor);
            }
            packet.displayPower = this.clientDisplayPower;
            packet.overload = this.isOverloaded();
            BuildCraftTransport.instance.sendToPlayers(packet, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
        }
    }

    private PowerHandler.PowerReceiver getReceiverOnSide(ForgeDirection side) {
        TileEntity tile = this.tiles[side.ordinal()];
        if (!(tile instanceof IPowerReceptor)) {
            return null;
        }
        IPowerReceptor receptor = (IPowerReceptor)tile;
        PowerHandler.PowerReceiver receiver = receptor.getPowerReceiver(side.getOpposite());
        if (receiver == null) {
            return null;
        }
        if (!receiver.getType().canReceiveFromPipes()) {
            return null;
        }
        return receiver;
    }

    public boolean isOverloaded() {
        return this.overload >= 60;
    }

    private void step() {
        if (this.container != null && this.container.func_145831_w() != null && this.currentDate != this.container.func_145831_w().func_82737_E()) {
            this.currentDate = this.container.func_145831_w().func_82737_E();
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new double[6];
            this.internalPower = this.internalNextPower;
            this.internalNextPower = new double[6];
            for (int i = 0; i < this.internalNextPower.length; ++i) {
                this.internalNextPower[i] = 0.0;
                this.nextPowerQuery[i] = 0.0;
            }
        }
    }

    public double receiveEnergy(ForgeDirection from, double valI) {
        double ret;
        double val = valI;
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook && (ret = ((IPipeTransportPowerHook)((Object)this.container.pipe)).receiveEnergy(from, val)) >= 0.0) {
            return ret;
        }
        int side = from.ordinal();
        if (this.internalNextPower[side] > this.maxPower) {
            return 0.0;
        }
        int n = side;
        this.internalNextPower[n] = this.internalNextPower[n] + val;
        if (this.internalNextPower[side] > this.maxPower) {
            val -= this.internalNextPower[side] - this.maxPower;
            this.internalNextPower[side] = this.maxPower;
            if (val < 0.0) {
                val = 0.0;
            }
        }
        return val;
    }

    public void requestEnergy(ForgeDirection from, double amount) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + ((IPipeTransportPowerHook)((Object)this.container.pipe)).requestEnergy(from, amount);
        } else {
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + amount;
        }
    }

    @Override
    public void initialize() {
        this.currentDate = this.container.func_145831_w().func_82737_E();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbttagcompound.func_74769_h("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbttagcompound.func_74769_h("nextPowerQuery[" + i + "]");
            this.internalPower[i] = (float)nbttagcompound.func_74769_h("internalPower[" + i + "]");
            this.internalNextPower[i] = (float)nbttagcompound.func_74769_h("internalNextPower[" + i + "]");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.func_74780_a("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.func_74780_a("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.func_74780_a("internalPower[" + i + "]", this.internalPower[i]);
            nbttagcompound.func_74780_a("internalNextPower[" + i + "]", this.internalNextPower[i]);
        }
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
        this.clientDisplayPower = packetPower.displayPower;
        this.overload = packetPower.overload ? 60 : 0;
    }

    public double getCurrentPowerTransferRate() {
        return this.highestPower;
    }

    public double getCurrentPowerAmount() {
        double amount = 0.0;
        for (double d : this.internalPower) {
            amount += d;
        }
        for (double d : this.internalNextPower) {
            amount += d;
        }
        return amount;
    }

    public float getPistonStage(int i) {
        if (this.movementStage[i] < 0.5f) {
            return this.movementStage[i] * 2.0f;
        }
        return 1.0f - (this.movementStage[i] - 0.5f) * 2.0f;
    }

    public double clearInstantPower() {
        double amount = 0.0;
        for (int i = 0; i < this.internalPower.length; ++i) {
            amount += this.internalPower[i];
            this.internalPower[i] = 0.0;
        }
        return amount;
    }

    static {
        powerCapacities.put(PipePowerCobblestone.class, 8);
        powerCapacities.put(PipePowerStone.class, 16);
        powerCapacities.put(PipePowerWood.class, 32);
        powerCapacities.put(PipePowerQuartz.class, 64);
        powerCapacities.put(PipePowerIron.class, 128);
        powerCapacities.put(PipePowerGold.class, 256);
        powerCapacities.put(PipePowerDiamond.class, 1024);
        powerCapacities.put(PipePowerHeat.class, 1024);
    }
}

