/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePowerHeat
extends Pipe<PipeTransportPower> {
    int zeroAcc = 0;
    double powerLevel = 0.0;
    SafeTimeTracker scanTracker = new SafeTimeTracker(40L, 5L);

    public PipePowerHeat(Item item) {
        super(new PipeTransportPower(), item);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    public int getHeatLevel() {
        if (this.powerLevel == 0.0) {
            return 0;
        }
        if (this.powerLevel >= 1000.0) {
            return 8;
        }
        return 1 + (int)(this.powerLevel / 1000.0 * 7.0);
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (this.container == null) {
            return PipeIconProvider.TYPE.PipePowerHeat0.ordinal();
        }
        return PipeIconProvider.TYPE.PipePowerHeat0.ordinal() + this.container.getWorld().func_72805_g(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.getWorld().field_72995_K) {
            return;
        }
        PipeTransportPower power = (PipeTransportPower)this.transport;
        power.requestEnergy(ForgeDirection.UP, 1024.0);
        this.powerLevel = power.clearInstantPower();
        int meta = this.container.getWorld().func_72805_g(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        int newMeta = this.getHeatLevel();
        if (meta != newMeta) {
            this.container.getWorld().func_72921_c(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, newMeta, 2);
            this.container.scheduleRenderUpdate();
        }
        if (this.powerLevel >= 10.0 && this.scanTracker.markTimeIfDelay(this.container.getWorld())) {
            int x = this.container.field_145851_c;
            int y = this.container.field_145848_d;
            int z = this.container.field_145849_e;
            for (int xi = x - 1; xi <= x + 1; ++xi) {
                for (int yi = y - 1; yi <= y + 1; ++yi) {
                    for (int zi = z - 1; zi <= z + 1; ++zi) {
                        if (this.container.getWorld().func_147439_a(xi, yi, zi) != Blocks.field_150451_bX) continue;
                        this.container.getWorld().func_147449_b(xi, yi, zi, Blocks.field_150350_a);
                        for (int i = 0; i < 4; ++i) {
                            ItemStack stack = new ItemStack(BuildCraftCore.redstoneCrystal);
                            EntityItem entityitem = new EntityItem(this.container.getWorld(), (double)((float)xi + 0.5f), (double)((float)yi + 0.5f), (double)((float)zi + 0.5f), stack);
                            entityitem.lifespan = BuildCraftCore.itemLifespan;
                            entityitem.field_145804_b = 10;
                            float f3 = 0.05f;
                            entityitem.field_70159_w = (float)(this.container.getWorld().field_73012_v.nextGaussian() - 0.5) * f3;
                            entityitem.field_70181_x = (float)(this.container.getWorld().field_73012_v.nextGaussian() - 0.5) * f3;
                            entityitem.field_70179_y = (float)(this.container.getWorld().field_73012_v.nextGaussian() - 0.5) * f3;
                            this.container.getWorld().func_72838_d((Entity)entityitem);
                        }
                    }
                }
            }
        }
    }
}

