/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.schematics;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.ITrigger;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.schematics.BptPipeExtension;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class SchematicPipe
extends SchematicTile {
    private BuildingPermission permission = BuildingPermission.ALL;

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.item == Item.func_150899_d((int)this.tileNBT.func_74762_e("pipeId"));
        }
        return false;
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        TileGenericPipe.SideProperties props = new TileGenericPipe.SideProperties();
        props.readFromNBT(this.tileNBT);
        props.rotateLeft();
        props.writeToNBT(this.tileNBT);
        Item pipeItem = Item.func_150899_d((int)this.tileNBT.func_74762_e("pipeId"));
        if (BptPipeExtension.contains(pipeItem)) {
            BptPipeExtension.get(pipeItem).rotateLeft(this, context);
        }
        NBTTagCompound gateNBT = this.tileNBT.func_74775_l("Gate");
        for (int i = 0; i < 8; ++i) {
            if (gateNBT.func_74764_b("trigger[" + i + "]")) {
                ITrigger t = ActionManager.triggers.get(gateNBT.func_74779_i("trigger[" + i + "]"));
                t = t.rotateLeft();
                gateNBT.func_74778_a("trigger[" + i + "]", t.getUniqueTag());
            }
            if (!gateNBT.func_74764_b("action[" + i + "]")) continue;
            IAction a = ActionManager.actions.get(gateNBT.func_74779_i("action[" + i + "]"));
            a = a.rotateLeft();
            gateNBT.func_74778_a("action[" + i + "]", a.getUniqueTag());
        }
    }

    @Override
    public void writeToWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        this.tileNBT.func_74768_a("x", x);
        this.tileNBT.func_74768_a("y", y);
        this.tileNBT.func_74768_a("z", z);
        context.world().func_147465_d(x, y, z, this.block, this.meta, 3);
        TileEntity tile = context.world().func_147438_o(x, y, z);
        tile.func_145839_a(this.tileNBT);
    }

    @Override
    public void writeToBlueprint(IBuilderContext context, int x, int y, int z) {
        TileEntity tile = context.world().func_147438_o(x, y, z);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            tile.func_145841_b(this.tileNBT);
            this.tileNBT.func_82580_o("travelingEntities");
            for (ForgeDirection direction : ForgeDirection.values()) {
                this.tileNBT.func_82580_o("tank[" + direction.ordinal() + "]");
                this.tileNBT.func_82580_o("transferState[" + direction.ordinal() + "]");
            }
            for (int i = 0; i < 6; ++i) {
                this.tileNBT.func_82580_o("powerQuery[" + i + "]");
                this.tileNBT.func_82580_o("nextPowerQuery[" + i + "]");
                this.tileNBT.func_82580_o("internalPower[" + i + "]");
                this.tileNBT.func_82580_o("internalNextPower[" + i + "]");
            }
        }
    }

    @Override
    public void writeRequirementsToBlueprint(IBuilderContext context, int x, int y, int z) {
        TileEntity tile = context.world().func_147438_o(x, y, z);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            ArrayList<ItemStack> items = pipe.computeItemDrop();
            this.storedRequirements = new ItemStack[items.size() + 1];
            items.toArray(this.storedRequirements);
            this.storedRequirements[this.storedRequirements.length - 1] = new ItemStack(pipe.item);
        }
    }

    @Override
    public void postProcessing(IBuilderContext context, int x, int y, int z) {
        Item pipeItem = Item.func_150899_d((int)this.tileNBT.func_74762_e("pipeId"));
        if (BptPipeExtension.contains(pipeItem)) {
            BptPipeExtension.get(pipeItem).postProcessing(this, context);
        }
    }

    @Override
    public Schematic.BuildingStage getBuildStage() {
        return Schematic.BuildingStage.STANDALONE;
    }

    @Override
    public void idsToBlueprint(MappingRegistry registry) {
        super.idsToBlueprint(registry);
        if (this.tileNBT.func_74764_b("pipeId")) {
            Item item = Item.func_150899_d((int)this.tileNBT.func_74762_e("pipeId"));
            this.tileNBT.func_74768_a("pipeId", registry.getIdForItem(item));
        }
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        super.idsToWorld(registry);
        if (this.tileNBT.func_74764_b("pipeId")) {
            try {
                Item item = registry.getItemForId(this.tileNBT.func_74762_e("pipeId"));
                this.tileNBT.func_74768_a("pipeId", Item.func_150891_b((Item)item));
            }
            catch (MappingNotFoundException e) {
                this.tileNBT.func_82580_o("pipeId");
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeToNBT(nbt, registry);
        nbt.func_74768_a("version", 2);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readFromNBT(nbt, registry);
        if (!nbt.func_74764_b("version") || nbt.func_74762_e("version") < 2) {
            this.tileNBT.func_82580_o("items");
            if (this.tileNBT.func_74764_b("Gate")) {
                NBTTagCompound gateNBT = this.tileNBT.func_74775_l("Gate");
                for (int i = 0; i < 8; ++i) {
                    NBTTagCompound parameterNBT;
                    if (!gateNBT.func_74764_b("triggerParameters[" + i + "]") || !(parameterNBT = gateNBT.func_74775_l("triggerParameters[" + i + "]")).func_74764_b("stack")) continue;
                    parameterNBT.func_82580_o("stack");
                }
            }
        }
    }

    @Override
    public BuildingPermission getBuildingPermission() {
        return this.permission;
    }
}

