/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;
import shadersmod.client.Dummy;
import shadersmod.client.HFNoiseTexture;
import shadersmod.client.IShaderPack;
import shadersmod.client.SMath;
import shadersmod.client.ShaderPackDefault;
import shadersmod.client.ShaderPackFolder;
import shadersmod.client.ShaderPackNone;
import shadersmod.client.ShaderPackZip;
import shadersmod.client.ShadersRender;
import shadersmod.client.ShadersTex;
import shadersmod.common.SMCLog;

public class Shaders {
    static bsu mc;
    static cji entityRenderer;
    public static boolean isInitializedOnce;
    public static boolean isShaderPackInitialized;
    public static ContextCapabilities capabilities;
    public static String glVersionString;
    public static String glVendorString;
    public static String glRendererString;
    public static boolean hasGlGenMipmap;
    public static int numberResetDisplayList;
    static boolean needResetModels;
    private static int renderDisplayWidth;
    private static int renderDisplayHeight;
    public static int renderWidth;
    public static int renderHeight;
    public static boolean isRenderingWorld;
    public static boolean isRenderingSky;
    public static boolean isCompositeRendered;
    public static boolean isRenderingDfb;
    public static boolean isShadowPass;
    public static boolean isSleeping;
    public static int activeTexUnit;
    public static boolean isHandRendered;
    public static boolean renderItemPass1DepthMask;
    public static amj itemToRender;
    static float[] sunPosition;
    static float[] moonPosition;
    static float[] shadowLightPosition;
    static float[] upPosition;
    static float[] shadowLightPositionVector;
    static float[] upPosModelView;
    static float[] sunPosModelView;
    static float[] moonPosModelView;
    private static float[] tempMat;
    static float clearColorR;
    static float clearColorG;
    static float clearColorB;
    static float skyColorR;
    static float skyColorG;
    static float skyColorB;
    static long worldTime;
    static long lastWorldTime;
    static long diffWorldTime;
    static float celestialAngle;
    static float sunAngle;
    static float shadowAngle;
    static int moonPhase;
    static long systemTime;
    static long lastSystemTime;
    static long diffSystemTime;
    static int frameCounter;
    static float frameTimeCounter;
    static int systemTimeInt32;
    static float rainStrength;
    static float wetness;
    public static float wetnessHalfLife;
    public static float drynessHalfLife;
    public static float eyeBrightnessHalflife;
    static boolean usewetness;
    static int isEyeInWater;
    static int eyeBrightness;
    static float eyeBrightnessFadeX;
    static float eyeBrightnessFadeY;
    static float eyePosY;
    static float centerDepth;
    static float centerDepthSmooth;
    static float centerDepthSmoothHalflife;
    static boolean centerDepthSmoothEnabled;
    static int superSamplingLevel;
    static boolean updateChunksErrorRecorded;
    static boolean lightmapEnabled;
    static boolean fogEnabled;
    public static int entityAttrib;
    public static int midTexCoordAttrib;
    public static int tangentAttrib;
    public static boolean useEntityAttrib;
    public static boolean useMidTexCoordAttrib;
    public static boolean useMultiTexCoord3Attrib;
    public static boolean useTangentAttrib;
    public static boolean progUseEntityAttrib;
    public static boolean progUseMidTexCoordAttrib;
    public static boolean progUseTangentAttrib;
    public static int atlasSizeX;
    public static int atlasSizeY;
    public static int uniformEntityHurt;
    public static int uniformEntityFlash;
    public static boolean useEntityHurtFlash;
    static double previousCameraPositionX;
    static double previousCameraPositionY;
    static double previousCameraPositionZ;
    static double cameraPositionX;
    static double cameraPositionY;
    static double cameraPositionZ;
    static int shadowPassInterval;
    public static boolean needResizeShadow;
    static int shadowMapWidth;
    static int shadowMapHeight;
    static int spShadowMapWidth;
    static int spShadowMapHeight;
    static float shadowMapFOV;
    static float shadowMapHalfPlane;
    static boolean shadowMapIsOrtho;
    static int shadowPassCounter;
    static int preShadowPassThirdPersonView;
    public static boolean shouldSkipDefaultShadow;
    static boolean waterShadowEnabled;
    static final int MaxDrawBuffers = 8;
    static final int MaxColorBuffers = 8;
    static final int MaxDepthBuffers = 3;
    static final int MaxShadowColorBuffers = 8;
    static final int MaxShadowDepthBuffers = 2;
    static int usedColorBuffers;
    static int usedDepthBuffers;
    static int usedShadowColorBuffers;
    static int usedShadowDepthBuffers;
    static int usedColorAttachs;
    static int usedDrawBuffers;
    static int dfb;
    static int sfb;
    private static int[] gbuffersFormat;
    public static int activeProgram;
    public static final int ProgramNone = 0;
    public static final int ProgramBasic = 1;
    public static final int ProgramTextured = 2;
    public static final int ProgramTexturedLit = 3;
    public static final int ProgramSkyBasic = 4;
    public static final int ProgramSkyTextured = 5;
    public static final int ProgramClouds = 6;
    public static final int ProgramTerrain = 7;
    public static final int ProgramTerrainSolid = 8;
    public static final int ProgramTerrainCutoutMip = 9;
    public static final int ProgramTerrainCutout = 10;
    public static final int ProgramDamagedBlock = 11;
    public static final int ProgramWater = 12;
    public static final int ProgramBlock = 13;
    public static final int ProgramItem = 14;
    public static final int ProgramEntities = 15;
    public static final int ProgramSpiderEyes = 16;
    public static final int ProgramHand = 17;
    public static final int ProgramWeather = 18;
    public static final int ProgramComposite = 19;
    public static final int ProgramComposite1 = 20;
    public static final int ProgramComposite2 = 21;
    public static final int ProgramComposite3 = 22;
    public static final int ProgramComposite4 = 23;
    public static final int ProgramComposite5 = 24;
    public static final int ProgramComposite6 = 25;
    public static final int ProgramComposite7 = 26;
    public static final int ProgramFinal = 27;
    public static final int ProgramShadow = 28;
    public static final int ProgramShadowSolid = 29;
    public static final int ProgramShadowCutout = 30;
    public static final int ProgramCount = 31;
    public static final int MaxCompositePasses = 8;
    private static final String[] programNames;
    private static final int[] programBackups;
    static int[] programsID;
    private static int[] programsRef;
    private static int programIDCopyDepth;
    private static String[] programsDrawBufSettings;
    private static String newDrawBufSetting;
    static IntBuffer[] programsDrawBuffers;
    static IntBuffer activeDrawBuffers;
    private static String[] programsColorAtmSettings;
    private static String newColorAtmSetting;
    private static String activeColorAtmSettings;
    private static int[] programsCompositeMipmapSetting;
    private static int newCompositeMipmapSetting;
    private static int activeCompositeMipmapSetting;
    public static Properties loadedShaders;
    public static Properties shadersConfig;
    public static cui defaultTexture;
    public static boolean normalMapEnabled;
    public static boolean[] shadowHardwareFilteringEnabled;
    public static boolean[] shadowMipmapEnabled;
    public static boolean[] shadowFilterNearest;
    public static boolean[] shadowColorMipmapEnabled;
    public static boolean[] shadowColorFilterNearest;
    public static boolean configTweakBlockDamage;
    public static boolean configCloudShadow;
    public static float configHandDepthMul;
    public static float configRenderResMul;
    public static float configShadowResMul;
    public static int configTexMinFilB;
    public static int configTexMinFilN;
    public static int configTexMinFilS;
    public static int configTexMagFilB;
    public static int configTexMagFilN;
    public static int configTexMagFilS;
    public static boolean configShadowClipFrustrum;
    public static boolean configNormalMap;
    public static boolean configSpecularMap;
    public static boolean configOldLighting;
    public static final int texMinFilRange = 3;
    public static final int texMagFilRange = 2;
    public static final String[] texMinFilDesc;
    public static final String[] texMagFilDesc;
    public static final int[] texMinFilValue;
    public static final int[] texMagFilValue;
    static IShaderPack shaderPack;
    static File currentshader;
    static String currentshadername;
    static String packNameNone;
    static String packNameDefault;
    static String shaderpacksdirname;
    static String optionsfilename;
    static File shadersdir;
    static File shaderpacksdir;
    static File configFile;
    public static final boolean enableShadersOption = true;
    private static final boolean enableShadersDebug = true;
    public static float blockLightLevel05;
    public static float blockLightLevel06;
    public static float blockLightLevel08;
    public static float aoLevel;
    public static float blockAoLight;
    public static float sunPathRotation;
    public static float shadowAngleInterval;
    public static int fogMode;
    public static float fogColorR;
    public static float fogColorG;
    public static float fogColorB;
    public static float shadowIntervalSize;
    public static int terrainIconSize;
    public static int[] terrainTextureSize;
    private static HFNoiseTexture noiseTexture;
    private static boolean noiseTextureEnabled;
    private static int noiseTextureResolution;
    static final int[] dfbColorTexturesA;
    static final int[] colorTexturesToggle;
    static final int[] colorTextureTextureImageUnit;
    static final boolean[][] programsToggleColorTextures;
    private static final int bigBufferSize = 2132;
    private static final ByteBuffer bigBuffer;
    static final float[] faProjection;
    static final float[] faProjectionInverse;
    static final float[] faModelView;
    static final float[] faModelViewInverse;
    static final float[] faShadowProjection;
    static final float[] faShadowProjectionInverse;
    static final float[] faShadowModelView;
    static final float[] faShadowModelViewInverse;
    static final FloatBuffer projection;
    static final FloatBuffer projectionInverse;
    static final FloatBuffer modelView;
    static final FloatBuffer modelViewInverse;
    static final FloatBuffer shadowProjection;
    static final FloatBuffer shadowProjectionInverse;
    static final FloatBuffer shadowModelView;
    static final FloatBuffer shadowModelViewInverse;
    static final FloatBuffer previousProjection;
    static final FloatBuffer previousModelView;
    static final FloatBuffer tempMatrixDirectBuffer;
    static final FloatBuffer tempDirectFloatBuffer;
    static final IntBuffer dfbColorTextures;
    static final IntBuffer dfbDepthTextures;
    static final IntBuffer sfbColorTextures;
    static final IntBuffer sfbDepthTextures;
    static final IntBuffer dfbDrawBuffers;
    static final IntBuffer sfbDrawBuffers;
    static final IntBuffer drawBuffersNone;
    static final IntBuffer drawBuffersAll;
    static final IntBuffer drawBuffersClear0;
    static final IntBuffer drawBuffersClear1;
    static final IntBuffer drawBuffersClearColor;
    static final IntBuffer drawBuffersColorAtt0;
    static final IntBuffer[] drawBuffersBuffer;
    static Map<atr, Integer> mapBlockToEntityData;
    private static final Pattern gbufferFormatPattern;
    private static final Pattern gbufferMipmapEnabledPattern;
    private static final Pattern patternLoadEntityDataMap;
    public static int[] entityData;
    public static int entityDataIndex;

    private Shaders() {
    }

    private static ByteBuffer nextByteBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size);
        return buffer.slice();
    }

    private static IntBuffer nextIntBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size * 4);
        return buffer.asIntBuffer();
    }

    private static FloatBuffer nextFloatBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size * 4);
        return buffer.asFloatBuffer();
    }

    private static IntBuffer[] nextIntBufferArray(int count, int size) {
        IntBuffer[] aib = new IntBuffer[count];
        for (int i = 0; i < count; ++i) {
            aib[i] = Shaders.nextIntBuffer(size);
        }
        return aib;
    }

    public static void loadConfig() {
        SMCLog.info("Load ShadersMod configuration.");
        try {
            if (!shaderpacksdir.exists()) {
                shaderpacksdir.mkdir();
            }
        }
        catch (Exception e) {
            SMCLog.severe("Failed openning shaderpacks directory.");
        }
        shadersConfig = new Properties();
        shadersConfig.setProperty("shaderPack", "");
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                shadersConfig.load(reader);
                reader.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!configFile.exists()) {
            try {
                Shaders.storeConfig();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Object value = null;
        configNormalMap = Boolean.parseBoolean(shadersConfig.getProperty("normalMapEnabled", "true"));
        configSpecularMap = Boolean.parseBoolean(shadersConfig.getProperty("specularMapEnabled", "true"));
        configTweakBlockDamage = Boolean.parseBoolean(shadersConfig.getProperty("tweakBlockDamage", shadersConfig.getProperty("dtweak", "false")));
        configCloudShadow = Boolean.parseBoolean(shadersConfig.getProperty("cloudShadow", "true"));
        configHandDepthMul = Float.parseFloat(shadersConfig.getProperty("handDepthMul", "0.125"));
        configRenderResMul = Float.parseFloat(shadersConfig.getProperty("renderResMul", "1.0"));
        configShadowResMul = Float.parseFloat(shadersConfig.getProperty("shadowResMul", "1.0"));
        configShadowClipFrustrum = Boolean.parseBoolean(shadersConfig.getProperty("shadowClipFrustrum", "true"));
        configOldLighting = Boolean.parseBoolean(shadersConfig.getProperty("oldLighting", "false"));
        configTexMinFilB = Integer.parseInt(shadersConfig.getProperty("TexMinFilB", "0")) % 3;
        configTexMinFilN = Integer.parseInt(shadersConfig.getProperty("TexMinFilN", Integer.toString(configTexMinFilB))) % 3;
        configTexMinFilS = Integer.parseInt(shadersConfig.getProperty("TexMinFilS", Integer.toString(configTexMinFilB))) % 3;
        configTexMagFilB = Integer.parseInt(shadersConfig.getProperty("TexMagFilB", "0")) % 2;
        configTexMagFilN = Integer.parseInt(shadersConfig.getProperty("TexMagFilN", "0")) % 2;
        configTexMagFilS = Integer.parseInt(shadersConfig.getProperty("TexMagFilS", "0")) % 2;
        currentshadername = shadersConfig.getProperty("shaderPack", packNameDefault);
        Shaders.loadShaderPack();
    }

    public static void storeConfig() {
        SMCLog.info("Save ShadersMod configuration.");
        shadersConfig.setProperty("normalMapEnabled", Boolean.toString(configNormalMap));
        shadersConfig.setProperty("specularMapEnabled", Boolean.toString(configSpecularMap));
        shadersConfig.setProperty("tweakBlockDamage", Boolean.toString(configTweakBlockDamage));
        shadersConfig.setProperty("cloudShadow", Boolean.toString(configCloudShadow));
        shadersConfig.setProperty("handDepthMul", Float.toString(configHandDepthMul));
        shadersConfig.setProperty("renderResMul", Float.toString(configRenderResMul));
        shadersConfig.setProperty("shadowResMul", Float.toString(configShadowResMul));
        shadersConfig.setProperty("shadowClipFrustrum", Boolean.toString(configShadowClipFrustrum));
        shadersConfig.setProperty("oldLighting", Boolean.toString(configOldLighting));
        shadersConfig.setProperty("TexMinFilB", Integer.toString(configTexMinFilB));
        shadersConfig.setProperty("TexMinFilN", Integer.toString(configTexMinFilN));
        shadersConfig.setProperty("TexMinFilS", Integer.toString(configTexMinFilS));
        shadersConfig.setProperty("TexMagFilB", Integer.toString(configTexMagFilB));
        shadersConfig.setProperty("TexMagFilN", Integer.toString(configTexMagFilN));
        shadersConfig.setProperty("TexMagFilS", Integer.toString(configTexMagFilS));
        try {
            FileWriter writer = new FileWriter(configFile);
            shadersConfig.store(writer, null);
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setShaderPack(String par1name) {
        currentshadername = par1name;
        shadersConfig.setProperty("shaderPack", par1name);
        Shaders.loadShaderPack();
    }

    public static void loadShaderPack() {
        String packName;
        if (shaderPack != null) {
            shaderPack.close();
            shaderPack = null;
        }
        if (!(packName = shadersConfig.getProperty("shaderPack", packNameDefault)).isEmpty() && !packName.equals(packNameNone)) {
            if (packName.equals(packNameDefault)) {
                shaderPack = new ShaderPackDefault();
            } else {
                try {
                    File packFile = new File(shaderpacksdir, packName);
                    if (packFile.isDirectory()) {
                        shaderPack = new ShaderPackFolder(packName, packFile);
                    } else if (packFile.isFile() && packName.toLowerCase().endsWith(".zip")) {
                        shaderPack = new ShaderPackZip(packName, packFile);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (shaderPack != null) {
            SMCLog.info("Loaded shaderpack.");
        } else {
            SMCLog.info("Did not load shaderpack.");
            shaderPack = new ShaderPackNone();
        }
    }

    static ArrayList listofShaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(packNameNone);
        list.add(packNameDefault);
        try {
            if (!shaderpacksdir.exists()) {
                shaderpacksdir.mkdir();
            }
            File[] listOfFiles = shaderpacksdir.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                File file = listOfFiles[i];
                String name = file.getName();
                if (!file.isDirectory() && (!file.isFile() || !name.toLowerCase().endsWith(".zip"))) continue;
                list.add(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    static String versiontostring(int vv) {
        String vs = Integer.toString(vv);
        return Integer.toString(Integer.parseInt(vs.substring(1, 3))) + "." + Integer.toString(Integer.parseInt(vs.substring(3, 5))) + "." + Integer.toString(Integer.parseInt(vs.substring(5)));
    }

    static void checkOptifine() {
    }

    public static int checkFramebufferStatus(String location) {
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            System.err.format("FramebufferStatus 0x%04X at %s\n", status, location);
        }
        return status;
    }

    public static int checkGLError(String location) {
        boolean skipPrint;
        int errorCode = GL11.glGetError();
        if (errorCode != 0 && !(skipPrint = false)) {
            if (errorCode == 1286) {
                int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
                System.err.format("GL error 0x%04X: %s (Fb status 0x%04X) at %s\n", errorCode, GLU.gluErrorString((int)errorCode), status, location);
            } else {
                System.err.format("GL error 0x%04X: %s at %s\n", errorCode, GLU.gluErrorString((int)errorCode), location);
            }
        }
        return errorCode;
    }

    public static int checkGLError(String location, String info) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            System.err.format("GL error 0x%04x: %s at %s %s\n", errorCode, GLU.gluErrorString((int)errorCode), location, info);
        }
        return errorCode;
    }

    public static int checkGLError(String location, String info1, String info2) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            System.err.format("GL error 0x%04x: %s at %s %s %s\n", errorCode, GLU.gluErrorString((int)errorCode), location, info1, info2);
        }
        return errorCode;
    }

    private static void printChat(String str) {
        Shaders.mc.q.d().a((ho)new hy(str));
    }

    private static void printChatAndLogError(String str) {
        SMCLog.severe(str);
        Shaders.mc.q.d().a((ho)new hy(str));
    }

    public static void printIntBuffer(String title, IntBuffer buf) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(title).append(" [pos ").append(buf.position()).append(" lim ").append(buf.limit()).append(" cap ").append(buf.capacity()).append(" :");
        int lim = buf.limit();
        for (int i = 0; i < lim; ++i) {
            sb.append(" ").append(buf.get(i));
        }
        sb.append("]");
        SMCLog.info(sb.toString());
    }

    public static void startup(bsu mc) {
        Shaders.mc = mc;
        mc = bsu.z();
        capabilities = GLContext.getCapabilities();
        glVersionString = GL11.glGetString((int)7938);
        glVendorString = GL11.glGetString((int)7936);
        glRendererString = GL11.glGetString((int)7937);
        SMCLog.info("ShadersMod version : %s\nOpenGL Version : %s\nVendor :  %s\nRenderer : %s\nCapabilities %s\nGL_MAX_DRAW_BUFFERS = %d\nGL_MAX_COLOR_ATTACHMENTS_EXT = %d\nGL_MAX_TEXTURE_IMAGE_UNITS = %d", "2.4.7", glVersionString, glVendorString, glRendererString, (Shaders.capabilities.OpenGL20 ? " 2.0 " : " - ") + (Shaders.capabilities.OpenGL21 ? " 2.1 " : " - ") + (Shaders.capabilities.OpenGL30 ? " 3.0 " : " - ") + (Shaders.capabilities.OpenGL32 ? " 3.2 " : " - ") + (Shaders.capabilities.OpenGL40 ? " 4.0 " : " - "), GL11.glGetInteger((int)34852), GL11.glGetInteger((int)36063), GL11.glGetInteger((int)34930));
        hasGlGenMipmap = Shaders.capabilities.OpenGL30;
        Shaders.loadConfig();
    }

    private static String toStringYN(boolean b) {
        return b ? "Y" : "N";
    }

    public static void updateBlockLightLevel() {
        if (configOldLighting) {
            blockLightLevel05 = 0.5f;
            blockLightLevel06 = 0.6f;
            blockLightLevel08 = 0.8f;
        } else {
            blockLightLevel05 = 1.0f;
            blockLightLevel06 = 1.0f;
            blockLightLevel08 = 1.0f;
        }
    }

    public static void init() {
        boolean firstInit;
        if (!isInitializedOnce) {
            isInitializedOnce = true;
            firstInit = true;
        } else {
            firstInit = false;
        }
        if (!isShaderPackInitialized) {
            int i;
            Shaders.checkGLError("Shaders.init pre");
            if ("Intel".equals(glVendorString)) {
                Shaders.printChat(String.format("OpenGL %s\n%s %s", glVersionString, glVendorString, glRendererString));
            }
            if (!Shaders.capabilities.OpenGL20) {
                Shaders.printChatAndLogError("No OpenGL 2.0");
            }
            if (!Shaders.capabilities.GL_EXT_framebuffer_object) {
                Shaders.printChatAndLogError("No EXT_framebuffer_object");
            }
            dfbDrawBuffers.position(0).limit(8);
            dfbColorTextures.position(0).limit(16);
            dfbDepthTextures.position(0).limit(3);
            sfbDrawBuffers.position(0).limit(8);
            sfbDepthTextures.position(0).limit(2);
            sfbColorTextures.position(0).limit(8);
            usedColorBuffers = 4;
            usedDepthBuffers = 1;
            usedShadowColorBuffers = 0;
            usedShadowDepthBuffers = 0;
            usedColorAttachs = 1;
            usedDrawBuffers = 1;
            Arrays.fill(gbuffersFormat, 6408);
            Arrays.fill(shadowHardwareFilteringEnabled, false);
            Arrays.fill(shadowMipmapEnabled, false);
            Arrays.fill(shadowFilterNearest, false);
            Arrays.fill(shadowColorMipmapEnabled, false);
            Arrays.fill(shadowColorFilterNearest, false);
            centerDepthSmoothEnabled = false;
            noiseTextureEnabled = false;
            sunPathRotation = 0.0f;
            shadowIntervalSize = 2.0f;
            aoLevel = 0.8f;
            blockAoLight = 1.0f - aoLevel;
            useEntityAttrib = false;
            useMidTexCoordAttrib = false;
            useMultiTexCoord3Attrib = false;
            useTangentAttrib = false;
            waterShadowEnabled = false;
            updateChunksErrorRecorded = false;
            Shaders.updateBlockLightLevel();
            for (int i2 = 0; i2 < 31; ++i2) {
                int pr;
                if (programNames[i2] == "") {
                    Shaders.programsRef[i2] = 0;
                    Shaders.programsID[i2] = 0;
                    Shaders.programsDrawBufSettings[i2] = null;
                    Shaders.programsColorAtmSettings[i2] = null;
                    Shaders.programsCompositeMipmapSetting[i2] = 0;
                    continue;
                }
                newDrawBufSetting = null;
                newColorAtmSetting = null;
                newCompositeMipmapSetting = 0;
                Shaders.programsID[i2] = Shaders.programsRef[i2] = (pr = Shaders.setupProgram(i2, "/shaders/" + programNames[i2] + ".vsh", "/shaders/" + programNames[i2] + ".fsh"));
                Shaders.programsDrawBufSettings[i2] = pr != 0 ? newDrawBufSetting : null;
                Shaders.programsColorAtmSettings[i2] = pr != 0 ? newColorAtmSetting : null;
                Shaders.programsCompositeMipmapSetting[i2] = pr != 0 ? newCompositeMipmapSetting : 0;
            }
            int maxDrawBuffers = GL11.glGetInteger((int)34852);
            HashMap drawBuffersMap = new HashMap();
            for (int p = 0; p < 31; ++p) {
                Arrays.fill(programsToggleColorTextures[p], false);
                if (p == 27) {
                    Shaders.programsDrawBuffers[p] = null;
                    continue;
                }
                if (programsID[p] == 0) {
                    if (p == 28) {
                        Shaders.programsDrawBuffers[p] = drawBuffersNone;
                        continue;
                    }
                    Shaders.programsDrawBuffers[p] = drawBuffersColorAtt0;
                    continue;
                }
                String str = programsDrawBufSettings[p];
                if (str != null) {
                    IntBuffer intbuf = drawBuffersBuffer[p];
                    int numDB = str.length();
                    if (numDB > usedDrawBuffers) {
                        usedDrawBuffers = numDB;
                    }
                    if (numDB > maxDrawBuffers) {
                        numDB = maxDrawBuffers;
                    }
                    Shaders.programsDrawBuffers[p] = intbuf;
                    intbuf.limit(numDB);
                    for (int i3 = 0; i3 < numDB; ++i3) {
                        int drawBuffer = 0;
                        if (str.length() > i3) {
                            int ca = str.charAt(i3) - 48;
                            if (p != 28) {
                                if (ca >= 0 && ca <= 7) {
                                    Shaders.programsToggleColorTextures[p][ca] = true;
                                    drawBuffer = ca + 36064;
                                    if (ca > usedColorAttachs) {
                                        usedColorAttachs = ca;
                                    }
                                    if (ca > usedColorBuffers) {
                                        usedColorBuffers = ca;
                                    }
                                }
                            } else if (ca >= 0 && ca <= 1) {
                                drawBuffer = ca + 36064;
                                if (ca > usedShadowColorBuffers) {
                                    usedShadowColorBuffers = ca;
                                }
                            }
                        }
                        intbuf.put(i3, drawBuffer);
                    }
                    continue;
                }
                if (p != 28 && p != 29 && p != 30) {
                    Shaders.programsDrawBuffers[p] = dfbDrawBuffers;
                    usedDrawBuffers = usedColorBuffers;
                    Arrays.fill(programsToggleColorTextures[p], 0, usedColorBuffers, true);
                    continue;
                }
                Shaders.programsDrawBuffers[p] = sfbDrawBuffers;
            }
            usedColorAttachs = usedColorBuffers;
            shadowPassInterval = usedShadowDepthBuffers > 0 ? 1 : 0;
            shouldSkipDefaultShadow = usedShadowDepthBuffers > 0;
            dfbDrawBuffers.position(0).limit(usedDrawBuffers);
            dfbColorTextures.position(0).limit(usedColorBuffers * 2);
            for (i = 0; i < usedDrawBuffers; ++i) {
                dfbDrawBuffers.put(i, 36064 + i);
            }
            if (usedDrawBuffers > maxDrawBuffers) {
                Shaders.printChatAndLogError("Not enough draw buffers! Requires " + usedDrawBuffers + ".  Has " + maxDrawBuffers + ".");
            }
            sfbDrawBuffers.position(0).limit(usedShadowColorBuffers);
            for (i = 0; i < usedShadowColorBuffers; ++i) {
                sfbDrawBuffers.put(i, 36064 + i);
            }
            for (i = 0; i < 31; ++i) {
                int n = i;
                while (programsID[n] == 0 && programBackups[n] != n) {
                    n = programBackups[n];
                }
                if (n == i || i == 28) continue;
                Shaders.programsID[i] = programsID[n];
                Shaders.programsDrawBufSettings[i] = programsDrawBufSettings[n];
                Shaders.programsDrawBuffers[i] = programsDrawBuffers[n];
            }
            Shaders.resize();
            Shaders.resizeShadow();
            if (noiseTextureEnabled) {
                Shaders.setupNoiseTexture();
            }
            if (defaultTexture == null) {
                defaultTexture = ShadersTex.createDefaultTexture();
            }
            isShaderPackInitialized = true;
            Shaders.loadEntityDataMap();
            Shaders.resetDisplayList();
            if (!firstInit) {
                Shaders.mc.q.d().a((ho)new hy("Shaders initialized."));
            }
            Shaders.checkGLError("Shaders.init");
        }
    }

    public static void resetDisplayList() {
        ++numberResetDisplayList;
        needResetModels = true;
        SMCLog.info("Reset world renderers");
        Shaders.mc.g.a();
        SMCLog.info(".");
    }

    public static void resetDisplayListModels() {
        if (needResetModels) {
            needResetModels = false;
            SMCLog.info("Reset model renderers");
            for (cpu ren : Dummy.get_renderManager_entityRenderMap(mc.ae()).values()) {
                if (!(ren instanceof cqv)) continue;
                cqv rle = (cqv)ren;
                Shaders.resetDisplayListModel(rle.b());
            }
        }
    }

    public static void resetDisplayListModel(ccq model) {
        if (model != null) {
            for (Object obj : model.s) {
                if (!(obj instanceof cdy)) continue;
                Shaders.resetDisplayListModelRenderer((cdy)obj);
            }
        }
    }

    public static void resetDisplayListModelRenderer(cdy mrr) {
        Dummy.invoke_modelRenderer_resetDisplayList(mrr);
        if (mrr.m != null) {
            int n = mrr.m.size();
            for (int i = 0; i < n; ++i) {
                Shaders.resetDisplayListModelRenderer((cdy)mrr.m.get(i));
            }
        }
    }

    private static int setupProgram(int program, String vShaderPath, String fShaderPath) {
        Shaders.checkGLError("pre setupProgram");
        int programid = ARBShaderObjects.glCreateProgramObjectARB();
        Shaders.checkGLError("create");
        if (programid != 0) {
            progUseEntityAttrib = false;
            progUseMidTexCoordAttrib = false;
            progUseTangentAttrib = false;
            int vShader = Shaders.createVertShader(vShaderPath);
            int fShader = Shaders.createFragShader(fShaderPath);
            Shaders.checkGLError("create");
            if (vShader != 0 || fShader != 0) {
                if (vShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)programid, (int)vShader);
                    Shaders.checkGLError("attach");
                }
                if (fShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)programid, (int)fShader);
                    Shaders.checkGLError("attach");
                }
                if (progUseEntityAttrib) {
                    ARBVertexShader.glBindAttribLocationARB((int)programid, (int)entityAttrib, (CharSequence)"mc_Entity");
                    Shaders.checkGLError("mc_Entity");
                }
                if (progUseMidTexCoordAttrib) {
                    ARBVertexShader.glBindAttribLocationARB((int)programid, (int)midTexCoordAttrib, (CharSequence)"mc_midTexCoord");
                    Shaders.checkGLError("mc_midTexCoord");
                }
                if (progUseTangentAttrib) {
                    ARBVertexShader.glBindAttribLocationARB((int)programid, (int)tangentAttrib, (CharSequence)"at_tangent");
                    Shaders.checkGLError("at_tangent");
                }
                ARBShaderObjects.glLinkProgramARB((int)programid);
                if (vShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)programid, (int)vShader);
                    ARBShaderObjects.glDeleteObjectARB((int)vShader);
                }
                if (fShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)programid, (int)fShader);
                    ARBShaderObjects.glDeleteObjectARB((int)fShader);
                }
                Shaders.programsID[program] = programid;
                Shaders.useProgram(program);
                ARBShaderObjects.glValidateProgramARB((int)programid);
                Shaders.useProgram(0);
                Shaders.printLogInfo(programid, vShaderPath + "," + fShaderPath);
                int valid = GL20.glGetProgrami((int)programid, (int)35715);
                if (valid == 1) {
                    SMCLog.info("Program " + programNames[program] + " loaded");
                } else {
                    Shaders.printChatAndLogError("[Shaders] Error : Invalid program " + programNames[program]);
                    ARBShaderObjects.glDeleteObjectARB((int)programid);
                    programid = 0;
                }
            } else {
                ARBShaderObjects.glDeleteObjectARB((int)programid);
                programid = 0;
            }
        }
        return programid;
    }

    private static int createVertShader(String filename) {
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        String vertexCode = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream(filename)));
        }
        catch (Exception e) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e2) {
                ARBShaderObjects.glDeleteObjectARB((int)vertShader);
                return 0;
            }
        }
        if (reader != null) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    vertexCode = vertexCode + line + "\n";
                    if (line.matches("attribute [_a-zA-Z0-9]+ mc_Entity.*")) {
                        useEntityAttrib = true;
                        progUseEntityAttrib = true;
                        continue;
                    }
                    if (line.matches("attribute [_a-zA-Z0-9]+ mc_midTexCoord.*")) {
                        useMidTexCoordAttrib = true;
                        progUseMidTexCoordAttrib = true;
                        continue;
                    }
                    if (line.matches(".*gl_MultiTexCoord3.*")) {
                        useMultiTexCoord3Attrib = true;
                        continue;
                    }
                    if (!line.matches("attribute [_a-zA-Z0-9]+ at_tangent.*")) continue;
                    useTangentAttrib = true;
                    progUseTangentAttrib = true;
                }
            }
            catch (Exception e) {
                SMCLog.severe("Couldn't read " + filename + "!");
                e.printStackTrace();
                ARBShaderObjects.glDeleteObjectARB((int)vertShader);
                return 0;
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                SMCLog.warning("Couldn't close " + filename + "!");
            }
        }
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)vertexCode);
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        Shaders.printLogInfo(vertShader, filename);
        return vertShader;
    }

    private static int createFragShader(String filename) {
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        StringBuilder fragCode = new StringBuilder(0x100000);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream(filename)));
        }
        catch (Exception e) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e2) {
                ARBShaderObjects.glDeleteObjectARB((int)fragShader);
                return 0;
            }
        }
        if (reader != null) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m;
                    String[] parts;
                    fragCode.append(line).append('\n');
                    if (line.matches("#version .*")) continue;
                    if (line.matches("uniform [ _a-zA-Z0-9]+ shadow;.*")) {
                        if (usedShadowDepthBuffers >= 1) continue;
                        usedShadowDepthBuffers = 1;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ watershadow;.*")) {
                        waterShadowEnabled = true;
                        if (usedShadowDepthBuffers >= 2) continue;
                        usedShadowDepthBuffers = 2;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ shadowtex0;.*")) {
                        if (usedShadowDepthBuffers >= 1) continue;
                        usedShadowDepthBuffers = 1;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ shadowtex1;.*")) {
                        if (usedShadowDepthBuffers >= 2) continue;
                        usedShadowDepthBuffers = 2;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ shadowcolor;.*")) {
                        if (usedShadowColorBuffers >= 1) continue;
                        usedShadowColorBuffers = 1;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ shadowcolor0;.*")) {
                        if (usedShadowColorBuffers >= 1) continue;
                        usedShadowColorBuffers = 1;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ shadowcolor1;.*")) {
                        if (usedShadowColorBuffers >= 2) continue;
                        usedShadowColorBuffers = 2;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ depthtex0;.*")) {
                        if (usedDepthBuffers >= 1) continue;
                        usedDepthBuffers = 1;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ depthtex1;.*")) {
                        if (usedDepthBuffers >= 2) continue;
                        usedDepthBuffers = 2;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ depthtex2;.*")) {
                        if (usedDepthBuffers >= 3) continue;
                        usedDepthBuffers = 3;
                        continue;
                    }
                    if (line.matches("uniform [ _a-zA-Z0-9]+ gdepth;.*")) {
                        if (gbuffersFormat[1] != 6408) continue;
                        Shaders.gbuffersFormat[1] = 34836;
                        continue;
                    }
                    if (usedColorBuffers < 5 && line.matches("uniform [ _a-zA-Z0-9]+ gaux1;.*")) {
                        usedColorBuffers = 5;
                        continue;
                    }
                    if (usedColorBuffers < 6 && line.matches("uniform [ _a-zA-Z0-9]+ gaux2;.*")) {
                        usedColorBuffers = 6;
                        continue;
                    }
                    if (usedColorBuffers < 7 && line.matches("uniform [ _a-zA-Z0-9]+ gaux3;.*")) {
                        usedColorBuffers = 7;
                        continue;
                    }
                    if (usedColorBuffers < 8 && line.matches("uniform [ _a-zA-Z0-9]+ gaux4;.*")) {
                        usedColorBuffers = 8;
                        continue;
                    }
                    if (usedColorBuffers < 5 && line.matches("uniform [ _a-zA-Z0-9]+ colortex4;.*")) {
                        usedColorBuffers = 5;
                        continue;
                    }
                    if (usedColorBuffers < 6 && line.matches("uniform [ _a-zA-Z0-9]+ colortex5;.*")) {
                        usedColorBuffers = 6;
                        continue;
                    }
                    if (usedColorBuffers < 7 && line.matches("uniform [ _a-zA-Z0-9]+ colortex6;.*")) {
                        usedColorBuffers = 7;
                        continue;
                    }
                    if (usedColorBuffers < 8 && line.matches("uniform [ _a-zA-Z0-9]+ colortex7;.*")) {
                        usedColorBuffers = 8;
                        continue;
                    }
                    if (usedColorBuffers < 8 && line.matches("uniform [ _a-zA-Z0-9]+ centerDepthSmooth;.*")) {
                        centerDepthSmoothEnabled = true;
                        continue;
                    }
                    if (line.matches("/\\* SHADOWRES:[0-9]+ \\*/.*")) {
                        parts = line.split("(:| )", 4);
                        SMCLog.info("Shadow map resolution: " + parts[2]);
                        spShadowMapWidth = spShadowMapHeight = Integer.parseInt(parts[2]);
                        shadowMapWidth = shadowMapHeight = Math.round((float)spShadowMapWidth * configShadowResMul);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*int[ \t]*shadowMapResolution[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Shadow map resolution: " + parts[1]);
                        spShadowMapWidth = spShadowMapHeight = Integer.parseInt(parts[1]);
                        shadowMapWidth = shadowMapHeight = Math.round((float)spShadowMapWidth * configShadowResMul);
                        continue;
                    }
                    if (line.matches("/\\* SHADOWFOV:[0-9\\.]+ \\*/.*")) {
                        parts = line.split("(:| )", 4);
                        SMCLog.info("Shadow map field of view: " + parts[2]);
                        shadowMapFOV = Float.parseFloat(parts[2]);
                        shadowMapIsOrtho = false;
                        continue;
                    }
                    if (line.matches("/\\* SHADOWHPL:[0-9\\.]+ \\*/.*")) {
                        parts = line.split("(:| )", 4);
                        SMCLog.info("Shadow map half-plane: " + parts[2]);
                        shadowMapHalfPlane = Float.parseFloat(parts[2]);
                        shadowMapIsOrtho = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*float[ \t]*shadowDistance[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Shadow map distance: " + parts[1]);
                        shadowMapHalfPlane = Float.parseFloat(parts[1]);
                        shadowMapIsOrtho = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*float[ \t]*shadowIntervalSize[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Shadow map interval size: " + parts[1]);
                        shadowIntervalSize = Float.parseFloat(parts[1]);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*generateShadowMipmap[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("Generate shadow mipmap");
                        Arrays.fill(shadowMipmapEnabled, true);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*generateShadowColorMipmap[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("Generate shadow color mipmap");
                        Arrays.fill(shadowColorMipmapEnabled, true);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*shadowHardwareFiltering[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("Hardware shadow filtering enabled.");
                        Arrays.fill(shadowHardwareFilteringEnabled, true);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*shadowHardwareFiltering0[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowHardwareFiltering0");
                        Shaders.shadowHardwareFilteringEnabled[0] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*shadowHardwareFiltering1[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowHardwareFiltering1");
                        Shaders.shadowHardwareFilteringEnabled[1] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*(shadowtex0Mipmap|shadowtexMipmap)[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowtex0Mipmap");
                        Shaders.shadowMipmapEnabled[0] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*(shadowtex1Mipmap)[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowtex1Mipmap");
                        Shaders.shadowMipmapEnabled[1] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*(shadowcolor0Mipmap|shadowColor0Mipmap)[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowcolor0Mipmap");
                        Shaders.shadowColorMipmapEnabled[0] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*(shadowcolor1Mipmap|shadowColor1Mipmap)[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowcolor1Mipmap");
                        Shaders.shadowColorMipmapEnabled[1] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*(shadowtex0Nearest|shadowtexNearest|shadow0MinMagNearest)[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowtex0Nearest");
                        Shaders.shadowFilterNearest[0] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*(shadowtex1Nearest|shadow1MinMagNearest)[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowtex1Nearest");
                        Shaders.shadowFilterNearest[1] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*(shadowcolor0Nearest|shadowColor0Nearest|shadowColor0MinMagNearest)[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowcolor0Nearest");
                        Shaders.shadowColorFilterNearest[0] = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*(shadowcolor1Nearest|shadowColor1Nearest|shadowColor1MinMagNearest)[ \t]*=[ \t]*true[ \t]*;.*")) {
                        SMCLog.info("shadowcolor1Nearest");
                        Shaders.shadowColorFilterNearest[1] = true;
                        continue;
                    }
                    if (line.matches("/\\* WETNESSHL:[0-9\\.]+ \\*/.*")) {
                        parts = line.split("(:| )", 4);
                        SMCLog.info("Wetness halflife: " + parts[2]);
                        wetnessHalfLife = Float.parseFloat(parts[2]);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*float[ \t]*wetnessHalflife[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Wetness halflife: " + parts[1]);
                        wetnessHalfLife = Float.parseFloat(parts[1]);
                        continue;
                    }
                    if (line.matches("/\\* DRYNESSHL:[0-9\\.]+ \\*/.*")) {
                        parts = line.split("(:| )", 4);
                        SMCLog.info("Dryness halflife: " + parts[2]);
                        drynessHalfLife = Float.parseFloat(parts[2]);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*float[ \t]*drynessHalflife[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Dryness halflife: " + parts[1]);
                        drynessHalfLife = Float.parseFloat(parts[1]);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*float[ \t]*eyeBrightnessHalflife[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Eye brightness halflife: " + parts[1]);
                        eyeBrightnessHalflife = Float.parseFloat(parts[1]);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*float[ \t]*centerDepthHalflife[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Center depth halflife: " + parts[1]);
                        centerDepthSmoothHalflife = Float.parseFloat(parts[1]);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*float[ \t]*sunPathRotation[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Sun path rotation: " + parts[1]);
                        sunPathRotation = Float.parseFloat(parts[1]);
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*float[ \t]*ambientOcclusionLevel[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("AO Level: " + parts[1]);
                        aoLevel = Float.parseFloat(parts[1]);
                        blockAoLight = 1.0f - aoLevel;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*int[ \t]*superSamplingLevel[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        int ssaa = Integer.parseInt(parts[1]);
                        if (ssaa > 1) {
                            SMCLog.info("Super sampling level: " + ssaa + "x");
                            superSamplingLevel = ssaa;
                            continue;
                        }
                        superSamplingLevel = 1;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*int[ \t]*noiseTextureResolution[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                        parts = line.split("(=[ \t]*|;)");
                        SMCLog.info("Noise texture enabled");
                        SMCLog.info("Noise texture resolution: " + parts[1]);
                        noiseTextureResolution = Integer.parseInt(parts[1]);
                        noiseTextureEnabled = true;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*int[ \t]*\\w+Format[ \t]*=[ \t]*[RGBA81632F]*[ \t]*;.*")) {
                        m = gbufferFormatPattern.matcher(line);
                        m.matches();
                        String name = m.group(1);
                        String value = m.group(2);
                        int bufferindex = Shaders.getBufferIndexFromString(name);
                        int format = Shaders.getTextureFormatFromString(value);
                        if (bufferindex < 0 || format == 0) continue;
                        Shaders.gbuffersFormat[bufferindex] = format;
                        System.out.format("%s format: %s\n", name, value);
                        continue;
                    }
                    if (line.matches("/\\* GAUX4FORMAT:RGBA32F \\*/.*")) {
                        SMCLog.info("gaux4 format : RGB32AF");
                        Shaders.gbuffersFormat[7] = 34836;
                        continue;
                    }
                    if (line.matches("/\\* GAUX4FORMAT:RGB32F \\*/.*")) {
                        SMCLog.info("gaux4 format : RGB32F");
                        Shaders.gbuffersFormat[7] = 34837;
                        continue;
                    }
                    if (line.matches("/\\* GAUX4FORMAT:RGB16 \\*/.*")) {
                        SMCLog.info("gaux4 format : RGB16");
                        Shaders.gbuffersFormat[7] = 32852;
                        continue;
                    }
                    if (line.matches("[ \t]*const[ \t]*bool[ \t]*\\w+MipmapEnabled[ \t]*=[ \t]*true[ \t]*;.*")) {
                        if (!filename.matches(".*composite[0-9]?.fsh") && !filename.matches(".*final.fsh")) continue;
                        m = gbufferMipmapEnabledPattern.matcher(line);
                        m.matches();
                        String name = m.group(1);
                        int bufferindex = Shaders.getBufferIndexFromString(name);
                        if (bufferindex < 0) continue;
                        newCompositeMipmapSetting |= 1 << bufferindex;
                        System.out.format("%s mipmap enabled for %s\n", name, filename);
                        continue;
                    }
                    if (!line.matches("/\\* DRAWBUFFERS:[0-7N]* \\*/.*")) continue;
                    parts = line.split("(:| )", 4);
                    newDrawBufSetting = parts[2];
                }
            }
            catch (Exception e) {
                SMCLog.severe("Couldn't read " + filename + "!");
                e.printStackTrace();
                ARBShaderObjects.glDeleteObjectARB((int)fragShader);
                return 0;
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                SMCLog.severe("Couldn't close " + filename + "!");
            }
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)fragCode);
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        Shaders.printLogInfo(fragShader, filename);
        return fragShader;
    }

    private static boolean printLogInfo(int obj, String name) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            if (infoBytes[length - 1] == 0) {
                infoBytes[length - 1] = 10;
            }
            String out = new String(infoBytes);
            SMCLog.info("Info log: " + name + "\n" + out);
            return false;
        }
        return true;
    }

    public static void setDrawBuffers(IntBuffer drawBuffers) {
        if (drawBuffers == null) {
            drawBuffers = drawBuffersNone;
        }
        if (activeDrawBuffers != drawBuffers) {
            activeDrawBuffers = drawBuffers;
            GL20.glDrawBuffers((IntBuffer)drawBuffers);
        }
    }

    public static void useProgram(int program) {
        atr block;
        int itemID;
        alq item;
        Shaders.checkGLError("pre-useProgram");
        if (isShadowPass) {
            program = 28;
            if (programsID[28] == 0) {
                normalMapEnabled = false;
                return;
            }
        }
        if (activeProgram == program) {
            return;
        }
        activeProgram = program;
        ARBShaderObjects.glUseProgramObjectARB((int)programsID[program]);
        if (programsID[program] == 0) {
            normalMapEnabled = false;
            return;
        }
        if (Shaders.checkGLError("useProgram ", programNames[program]) != 0) {
            Shaders.programsID[program] = 0;
        }
        IntBuffer drawBuffers = programsDrawBuffers[program];
        if (isRenderingDfb) {
            Shaders.setDrawBuffers(drawBuffers);
            Shaders.checkGLError(programNames[program], " draw buffers = ", programsDrawBufSettings[program]);
        }
        activeCompositeMipmapSetting = programsCompositeMipmapSetting[program];
        uniformEntityHurt = ARBShaderObjects.glGetUniformLocationARB((int)programsID[activeProgram], (CharSequence)"entityHurt");
        uniformEntityFlash = ARBShaderObjects.glGetUniformLocationARB((int)programsID[activeProgram], (CharSequence)"entityFlash");
        switch (program) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                normalMapEnabled = true;
                Shaders.setProgramUniform1i("texture", 0);
                Shaders.setProgramUniform1i("lightmap", 1);
                Shaders.setProgramUniform1i("normals", 2);
                Shaders.setProgramUniform1i("specular", 3);
                Shaders.setProgramUniform1i("shadow", waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i("watershadow", 4);
                Shaders.setProgramUniform1i("shadowtex0", 4);
                Shaders.setProgramUniform1i("shadowtex1", 5);
                Shaders.setProgramUniform1i("depthtex0", 6);
                Shaders.setProgramUniform1i("depthtex1", 12);
                Shaders.setProgramUniform1i("shadowcolor", 13);
                Shaders.setProgramUniform1i("shadowcolor0", 13);
                Shaders.setProgramUniform1i("shadowcolor1", 14);
                Shaders.setProgramUniform1i("noisetex", 15);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                normalMapEnabled = false;
                Shaders.setProgramUniform1i("gcolor", 0);
                Shaders.setProgramUniform1i("gdepth", 1);
                Shaders.setProgramUniform1i("gnormal", 2);
                Shaders.setProgramUniform1i("composite", 3);
                Shaders.setProgramUniform1i("gaux1", 7);
                Shaders.setProgramUniform1i("gaux2", 8);
                Shaders.setProgramUniform1i("gaux3", 9);
                Shaders.setProgramUniform1i("gaux4", 10);
                Shaders.setProgramUniform1i("colortex0", 0);
                Shaders.setProgramUniform1i("colortex1", 1);
                Shaders.setProgramUniform1i("colortex2", 2);
                Shaders.setProgramUniform1i("colortex3", 3);
                Shaders.setProgramUniform1i("colortex4", 7);
                Shaders.setProgramUniform1i("colortex5", 8);
                Shaders.setProgramUniform1i("colortex6", 9);
                Shaders.setProgramUniform1i("colortex7", 10);
                Shaders.setProgramUniform1i("shadow", waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i("watershadow", 4);
                Shaders.setProgramUniform1i("shadowtex0", 4);
                Shaders.setProgramUniform1i("shadowtex1", 5);
                Shaders.setProgramUniform1i("gdepthtex", 6);
                Shaders.setProgramUniform1i("depthtex0", 6);
                Shaders.setProgramUniform1i("depthtex1", 11);
                Shaders.setProgramUniform1i("depthtex2", 12);
                Shaders.setProgramUniform1i("shadowcolor", 13);
                Shaders.setProgramUniform1i("shadowcolor0", 13);
                Shaders.setProgramUniform1i("shadowcolor1", 14);
                Shaders.setProgramUniform1i("noisetex", 15);
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                Shaders.setProgramUniform1i("tex", 0);
                Shaders.setProgramUniform1i("texture", 0);
                Shaders.setProgramUniform1i("lightmap", 1);
                Shaders.setProgramUniform1i("normals", 2);
                Shaders.setProgramUniform1i("specular", 3);
                Shaders.setProgramUniform1i("shadow", waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i("watershadow", 4);
                Shaders.setProgramUniform1i("shadowtex0", 4);
                Shaders.setProgramUniform1i("shadowtex1", 5);
                Shaders.setProgramUniform1i("shadowcolor", 13);
                Shaders.setProgramUniform1i("shadowcolor0", 13);
                Shaders.setProgramUniform1i("shadowcolor1", 14);
                Shaders.setProgramUniform1i("noisetex", 15);
                break;
            }
            default: {
                normalMapEnabled = false;
            }
        }
        amj stack = Shaders.mc.h.bY();
        alq alq2 = item = stack != null ? stack.b() : null;
        if (item != null) {
            itemID = alq.e.b((Object)item);
            block = (atr)atr.c.a(itemID);
        } else {
            itemID = -1;
            block = null;
        }
        Shaders.setProgramUniform1i("heldItemId", itemID);
        Shaders.setProgramUniform1i("heldBlockLightValue", block != null ? block.p() : 0);
        Shaders.setProgramUniform1i("fogMode", fogEnabled ? fogMode : 0);
        Shaders.setProgramUniform3f("fogColor", fogColorR, fogColorG, fogColorB);
        Shaders.setProgramUniform3f("skyColor", skyColorR, skyColorG, skyColorB);
        Shaders.setProgramUniform1i("worldTime", (int)worldTime % 24000);
        Shaders.setProgramUniform1i("moonPhase", moonPhase);
        Shaders.setProgramUniform1f("frameTimeCounter", frameTimeCounter);
        Shaders.setProgramUniform1f("sunAngle", sunAngle);
        Shaders.setProgramUniform1f("shadowAngle", shadowAngle);
        Shaders.setProgramUniform1f("rainStrength", rainStrength);
        Shaders.setProgramUniform1f("aspectRatio", (float)renderWidth / (float)renderHeight);
        Shaders.setProgramUniform1f("viewWidth", renderWidth);
        Shaders.setProgramUniform1f("viewHeight", renderHeight);
        Shaders.setProgramUniform1f("near", 0.05f);
        Shaders.setProgramUniform1f("far", Shaders.mc.t.c * 16);
        Shaders.setProgramUniform3f("sunPosition", sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f("moonPosition", moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f("shadowLightPosition", shadowLightPosition[0], shadowLightPosition[1], shadowLightPosition[2]);
        Shaders.setProgramUniform3f("upPosition", upPosition[0], upPosition[1], upPosition[2]);
        Shaders.setProgramUniform3f("previousCameraPosition", (float)previousCameraPositionX, (float)previousCameraPositionY, (float)previousCameraPositionZ);
        Shaders.setProgramUniform3f("cameraPosition", (float)cameraPositionX, (float)cameraPositionY, (float)cameraPositionZ);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelView", false, modelView);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelViewInverse", false, modelViewInverse);
        Shaders.setProgramUniformMatrix4ARB("gbufferPreviousProjection", false, previousProjection);
        Shaders.setProgramUniformMatrix4ARB("gbufferProjection", false, projection);
        Shaders.setProgramUniformMatrix4ARB("gbufferProjectionInverse", false, projectionInverse);
        Shaders.setProgramUniformMatrix4ARB("gbufferPreviousModelView", false, previousModelView);
        if (usedShadowDepthBuffers > 0) {
            Shaders.setProgramUniformMatrix4ARB("shadowProjection", false, shadowProjection);
            Shaders.setProgramUniformMatrix4ARB("shadowProjectionInverse", false, shadowProjectionInverse);
            Shaders.setProgramUniformMatrix4ARB("shadowModelView", false, shadowModelView);
            Shaders.setProgramUniformMatrix4ARB("shadowModelViewInverse", false, shadowModelViewInverse);
        }
        Shaders.setProgramUniform1f("wetness", wetness);
        Shaders.setProgramUniform1f("eyeAltitude", eyePosY);
        Shaders.setProgramUniform2i("eyeBrightness", eyeBrightness & 0xFFFF, eyeBrightness >> 16);
        Shaders.setProgramUniform2i("eyeBrightnessSmooth", Math.round(eyeBrightnessFadeX), Math.round(eyeBrightnessFadeY));
        Shaders.setProgramUniform2i("terrainTextureSize", terrainTextureSize[0], terrainTextureSize[1]);
        Shaders.setProgramUniform1i("terrainIconSize", terrainIconSize);
        Shaders.setProgramUniform1i("isEyeInWater", isEyeInWater);
        Shaders.setProgramUniform1i("hideGUI", Shaders.mc.t.aw ? 1 : 0);
        Shaders.setProgramUniform1f("centerDepthSmooth", centerDepthSmooth);
        Shaders.setProgramUniform2i("atlasSize", atlasSizeX, atlasSizeY);
        Shaders.checkGLError("useProgram ", programNames[program]);
    }

    public static void setProgramUniform1i(String name, int x2) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform1iARB((int)uniform, (int)x2);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform2i(String name, int x2, int y) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform2iARB((int)uniform, (int)x2, (int)y);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform1f(String name, float x2) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform1fARB((int)uniform, (float)x2);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform3f(String name, float x2, float y, float z) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform3fARB((int)uniform, (float)x2, (float)y, (float)z);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniformMatrix4ARB(String name, boolean transpose, FloatBuffer matrix) {
        int gp = programsID[activeProgram];
        if (gp != 0 && matrix != null) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniformMatrix4ARB((int)uniform, (boolean)transpose, (FloatBuffer)matrix);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    private static int getBufferIndexFromString(String name) {
        if (name.equals("colortex0") || name.equals("gcolor")) {
            return 0;
        }
        if (name.equals("colortex1") || name.equals("gdepth")) {
            return 1;
        }
        if (name.equals("colortex2") || name.equals("gnormal")) {
            return 2;
        }
        if (name.equals("colortex3") || name.equals("composite")) {
            return 3;
        }
        if (name.equals("colortex4") || name.equals("gaux1")) {
            return 4;
        }
        if (name.equals("colortex5") || name.equals("gaux2")) {
            return 5;
        }
        if (name.equals("colortex6") || name.equals("gaux3")) {
            return 6;
        }
        if (name.equals("colortex7") || name.equals("gaux4")) {
            return 7;
        }
        return -1;
    }

    private static int getTextureFormatFromString(String par) {
        if (par.matches("[ \t]*R8[ \t]*")) {
            return 33321;
        }
        if (par.matches("[ \t]*RG8[ \t]*")) {
            return 33323;
        }
        if (par.matches("[ \t]*RGB8[ \t]*")) {
            return 32849;
        }
        if (par.matches("[ \t]*RGBA8[ \t]*")) {
            return 32856;
        }
        if (par.matches("[ \t]*R16[ \t]*")) {
            return 33322;
        }
        if (par.matches("[ \t]*RG16[ \t]*")) {
            return 33324;
        }
        if (par.matches("[ \t]*RGB16[ \t]*")) {
            return 32852;
        }
        if (par.matches("[ \t]*RGBA16[ \t]*")) {
            return 32859;
        }
        if (par.matches("[ \t]*R32F[ \t]*")) {
            return 33326;
        }
        if (par.matches("[ \t]*RG32F[ \t]*")) {
            return 33328;
        }
        if (par.matches("[ \t]*RGB32F[ \t]*")) {
            return 34837;
        }
        if (par.matches("[ \t]*RGBA32F[ \t]*")) {
            return 34836;
        }
        return 0;
    }

    private static void setupNoiseTexture() {
        if (noiseTexture == null) {
            noiseTexture = new HFNoiseTexture(noiseTextureResolution, noiseTextureResolution);
        }
    }

    private static void loadEntityDataMap() {
        mapBlockToEntityData = new IdentityHashMap<atr, Integer>(300);
        if (mapBlockToEntityData.isEmpty()) {
            for (oa key : atr.c.c()) {
                atr block = (atr)atr.c.a((Object)key);
                int id = atr.c.b((Object)block);
                mapBlockToEntityData.put(block, id);
            }
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream("/mc_Entity_x.txt")));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (reader != null) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m = patternLoadEntityDataMap.matcher(line);
                    if (m.matches()) {
                        String name = m.group(1);
                        String value = m.group(2);
                        int id = Integer.parseInt(value);
                        atr block = atr.b((String)name);
                        if (block != null) {
                            mapBlockToEntityData.put(block, id);
                            continue;
                        }
                        SMCLog.warning("Unknown block name %s", name);
                        continue;
                    }
                    System.out.format("unmatched %s\n", line);
                }
            }
            catch (Exception e) {
                SMCLog.warning("Error parsing mc_Entity_x.txt");
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static IntBuffer fillIntBufferZero(IntBuffer buf) {
        int limit = buf.limit();
        for (int i = buf.position(); i < limit; ++i) {
            buf.put(i, 0);
        }
        return buf;
    }

    public static void uninit() {
        if (isShaderPackInitialized) {
            Shaders.checkGLError("Shaders.uninit pre");
            for (int i = 0; i < 31; ++i) {
                if (programsRef[i] != 0) {
                    ARBShaderObjects.glDeleteObjectARB((int)programsRef[i]);
                    Shaders.checkGLError("del programRef");
                }
                Shaders.programsRef[i] = 0;
                Shaders.programsID[i] = 0;
                Shaders.programsDrawBufSettings[i] = null;
                Shaders.programsDrawBuffers[i] = null;
                Shaders.programsCompositeMipmapSetting[i] = 0;
            }
            if (dfb != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
                dfb = 0;
                Shaders.checkGLError("del dfb");
            }
            if (sfb != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
                sfb = 0;
                Shaders.checkGLError("del sfb");
            }
            if (dfbDepthTextures != null) {
                GL11.glDeleteTextures((IntBuffer)dfbDepthTextures);
                Shaders.fillIntBufferZero(dfbDepthTextures);
                Shaders.checkGLError("del dfbDepthTextures");
            }
            if (dfbColorTextures != null) {
                GL11.glDeleteTextures((IntBuffer)dfbColorTextures);
                Shaders.fillIntBufferZero(dfbColorTextures);
                Shaders.checkGLError("del dfbTextures");
            }
            if (sfbDepthTextures != null) {
                GL11.glDeleteTextures((IntBuffer)sfbDepthTextures);
                Shaders.fillIntBufferZero(sfbDepthTextures);
                Shaders.checkGLError("del shadow depth");
            }
            if (sfbColorTextures != null) {
                GL11.glDeleteTextures((IntBuffer)sfbColorTextures);
                Shaders.fillIntBufferZero(sfbColorTextures);
                Shaders.checkGLError("del shadow color");
            }
            if (dfbDrawBuffers != null) {
                Shaders.fillIntBufferZero(dfbDrawBuffers);
            }
            if (noiseTexture != null) {
                noiseTexture.destroy();
                noiseTexture = null;
            }
            SMCLog.info("Uninit");
            shadowPassInterval = 0;
            shouldSkipDefaultShadow = false;
            isShaderPackInitialized = false;
            Shaders.checkGLError("Shaders.uninit");
        }
    }

    public static void scheduleResize() {
        renderDisplayHeight = 0;
    }

    public static void scheduleResizeShadow() {
        needResizeShadow = true;
    }

    private static void resize() {
        renderDisplayWidth = Shaders.mc.d;
        renderDisplayHeight = Shaders.mc.e;
        renderWidth = Math.round((float)renderDisplayWidth * configRenderResMul);
        renderHeight = Math.round((float)renderDisplayHeight * configRenderResMul);
        Shaders.setupFrameBuffer();
    }

    private static void resizeShadow() {
        needResizeShadow = false;
        shadowMapWidth = Math.round((float)spShadowMapWidth * configShadowResMul);
        shadowMapHeight = Math.round((float)spShadowMapHeight * configShadowResMul);
        Shaders.setupShadowFrameBuffer();
    }

    private static void setupFrameBuffer() {
        int i;
        if (dfb != 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
            GL11.glDeleteTextures((IntBuffer)dfbDepthTextures);
            GL11.glDeleteTextures((IntBuffer)dfbColorTextures);
        }
        dfb = EXTFramebufferObject.glGenFramebuffersEXT();
        GL11.glGenTextures((IntBuffer)((IntBuffer)dfbDepthTextures.clear().limit(usedDepthBuffers)));
        GL11.glGenTextures((IntBuffer)((IntBuffer)dfbColorTextures.clear().limit(16)));
        dfbDepthTextures.position(0);
        dfbColorTextures.position(0);
        dfbColorTextures.get(dfbColorTexturesA).position(0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        GL20.glDrawBuffers((int)0);
        GL11.glReadBuffer((int)0);
        for (i = 0; i < usedDepthBuffers; ++i) {
            GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(i));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)34891, (int)6409);
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)renderWidth, (int)renderHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)dfbDepthTextures.get(0), (int)0);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        GL11.glReadBuffer((int)0);
        Shaders.checkGLError("FT d");
        for (i = 0; i < usedColorBuffers; ++i) {
            GL11.glBindTexture((int)3553, (int)dfbColorTexturesA[i]);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)gbuffersFormat[i], (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)dfbColorTexturesA[i], (int)0);
            Shaders.checkGLError("FT c");
        }
        for (i = 0; i < usedColorBuffers; ++i) {
            GL11.glBindTexture((int)3553, (int)dfbColorTexturesA[8 + i]);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)gbuffersFormat[i], (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            Shaders.checkGLError("FT ca");
        }
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status == 36058) {
            Shaders.printChatAndLogError("Failed framebuffer incomplete formats");
            for (int i2 = 0; i2 < usedColorBuffers; ++i2) {
                GL11.glBindTexture((int)3553, (int)dfbColorTextures.get(i2));
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i2), (int)3553, (int)dfbColorTextures.get(i2), (int)0);
                Shaders.checkGLError("FT c");
            }
            status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
            if (status == 36053) {
                SMCLog.info("complete");
            }
        }
        GL11.glBindTexture((int)3553, (int)0);
        if (status != 36053) {
            Shaders.printChatAndLogError("Failed creating framebuffer! (Status " + status + ")");
        } else {
            SMCLog.info("Framebuffer created.");
        }
    }

    private static void setupShadowFrameBuffer() {
        int filter;
        int i;
        if (usedShadowDepthBuffers == 0) {
            return;
        }
        if (sfb != 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
            GL11.glDeleteTextures((IntBuffer)sfbDepthTextures);
            GL11.glDeleteTextures((IntBuffer)sfbColorTextures);
        }
        sfb = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
        GL20.glDrawBuffers((int)0);
        GL11.glReadBuffer((int)0);
        GL11.glGenTextures((IntBuffer)((IntBuffer)sfbDepthTextures.clear().limit(usedShadowDepthBuffers)));
        GL11.glGenTextures((IntBuffer)((IntBuffer)sfbColorTextures.clear().limit(usedShadowColorBuffers)));
        sfbDepthTextures.position(0);
        sfbColorTextures.position(0);
        for (i = 0; i < usedShadowDepthBuffers; ++i) {
            GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(i));
            GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
            GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
            filter = shadowFilterNearest[i] ? 9728 : 9729;
            GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
            if (shadowHardwareFilteringEnabled[i]) {
                GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
            }
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTextures.get(0), (int)0);
        Shaders.checkGLError("FT sd");
        for (i = 0; i < usedShadowColorBuffers; ++i) {
            GL11.glBindTexture((int)3553, (int)sfbColorTextures.get(i));
            GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
            GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
            filter = shadowColorFilterNearest[i] ? 9728 : 9729;
            GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)sfbColorTextures.get(i), (int)0);
            Shaders.checkGLError("FT sc");
        }
        GL11.glBindTexture((int)3553, (int)0);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            Shaders.printChatAndLogError("Failed creating shadow framebuffer! (Status " + status + ")");
        } else {
            SMCLog.info("Shadow framebuffer created.");
        }
    }

    public static void beginRender(bsu minecraft, float partialTicks, long finishTimeNano) {
        int i;
        Shaders.checkGLError("pre beginRender");
        mc = minecraft;
        Shaders.mc.y.a("init");
        entityRenderer = Shaders.mc.o;
        if (!isShaderPackInitialized) {
            Shaders.init();
        }
        if (Shaders.mc.d != renderDisplayWidth || Shaders.mc.e != renderDisplayHeight) {
            Shaders.resize();
        }
        if (needResizeShadow) {
            Shaders.resizeShadow();
        }
        if ((diffWorldTime = ((worldTime = Shaders.mc.f.L()) - lastWorldTime) % 24000L) < 0L) {
            diffWorldTime += 24000L;
        }
        lastWorldTime = worldTime;
        moonPhase = Shaders.mc.f.x();
        systemTime = System.currentTimeMillis();
        if (lastSystemTime == 0L) {
            lastSystemTime = systemTime;
        }
        diffSystemTime = systemTime - lastSystemTime;
        lastSystemTime = systemTime;
        frameTimeCounter += (float)diffSystemTime * 0.001f;
        frameTimeCounter %= 100000.0f;
        rainStrength = minecraft.f.j(partialTicks);
        float fadeScalar = (float)diffSystemTime * 0.01f;
        float temp1 = (float)Math.exp(Math.log(0.5) * (double)fadeScalar / (double)(wetness < rainStrength ? drynessHalfLife : wetnessHalfLife));
        wetness = wetness * temp1 + rainStrength * (1.0f - temp1);
        wv renderViewEntity = mc.aa();
        isSleeping = renderViewEntity instanceof xn && ((xn)renderViewEntity).bI();
        eyePosY = (float)renderViewEntity.t * partialTicks + (float)renderViewEntity.Q * (1.0f - partialTicks);
        eyeBrightness = renderViewEntity.b(partialTicks);
        float fadeScalar2 = (float)diffSystemTime * 0.01f;
        float temp2 = (float)Math.exp(Math.log(0.5) * (double)fadeScalar2 / (double)eyeBrightnessHalflife);
        eyeBrightnessFadeX = eyeBrightnessFadeX * temp2 + (float)(eyeBrightness & 0xFFFF) * (1.0f - temp2);
        eyeBrightnessFadeY = eyeBrightnessFadeY * temp2 + (float)(eyeBrightness >> 16) * (1.0f - temp2);
        isEyeInWater = Shaders.mc.t.ax == 0 && !((xm)mc.aa()).bI() && Shaders.mc.h.a(bof.h) ? 1 : 0;
        brw skyColorV = Shaders.mc.f.a(mc.aa(), partialTicks);
        skyColorR = (float)skyColorV.a;
        skyColorG = (float)skyColorV.b;
        skyColorB = (float)skyColorV.c;
        isRenderingWorld = true;
        isCompositeRendered = false;
        isHandRendered = false;
        if (usedShadowDepthBuffers >= 1) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(0));
            if (usedShadowDepthBuffers >= 2) {
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(1));
            }
        }
        GL13.glActiveTexture((int)33984);
        for (i = 0; i < usedColorBuffers; ++i) {
            GL11.glBindTexture((int)3553, (int)dfbColorTexturesA[i]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glBindTexture((int)3553, (int)dfbColorTexturesA[8 + i]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        }
        GL11.glBindTexture((int)3553, (int)0);
        for (i = 0; i < 4 && 4 + i < usedColorBuffers; ++i) {
            GL13.glActiveTexture((int)(33991 + i));
            GL11.glBindTexture((int)3553, (int)dfbColorTextures.get(4 + i));
        }
        GL13.glActiveTexture((int)33990);
        GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(0));
        if (usedDepthBuffers >= 2) {
            GL13.glActiveTexture((int)33995);
            GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(1));
            if (usedDepthBuffers >= 3) {
                GL13.glActiveTexture((int)33996);
                GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(2));
            }
        }
        for (i = 0; i < usedShadowColorBuffers; ++i) {
            GL13.glActiveTexture((int)(33997 + i));
            GL11.glBindTexture((int)3553, (int)sfbColorTextures.get(i));
        }
        if (noiseTextureEnabled) {
            GL13.glActiveTexture((int)(33984 + Shaders.noiseTexture.textureUnit));
            GL11.glBindTexture((int)3553, (int)noiseTexture.getID());
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        }
        GL13.glActiveTexture((int)33984);
        previousCameraPositionX = cameraPositionX;
        previousCameraPositionY = cameraPositionY;
        previousCameraPositionZ = cameraPositionZ;
        previousProjection.position(0);
        projection.position(0);
        previousProjection.put(projection);
        previousProjection.position(0);
        projection.position(0);
        previousModelView.position(0);
        modelView.position(0);
        previousModelView.put(modelView);
        previousModelView.position(0);
        modelView.position(0);
        Shaders.checkGLError("beginRender");
        ShadersRender.renderShadowMap(entityRenderer, 0, partialTicks, finishTimeNano);
        Shaders.mc.y.b();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        for (i = 0; i < usedColorBuffers; ++i) {
            Shaders.colorTexturesToggle[i] = 0;
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)dfbColorTexturesA[i], (int)0);
        }
        Shaders.checkGLError("end beginRender");
    }

    public static void beginRenderPass(int pass, float partialTicks, long finishTimeNano) {
        if (isShadowPass) {
            return;
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
        activeDrawBuffers = null;
        ShadersTex.bindNSTextures(Dummy.invoke_iTextureObject_getMultiTexID(defaultTexture));
        Shaders.useProgram(2);
        Shaders.checkGLError("end beginRenderPass");
    }

    public static void setViewport(int vx, int vy, int vw, int vh) {
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (isShadowPass) {
            GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
        } else {
            GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
            isRenderingDfb = true;
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2929);
            Shaders.setDrawBuffers(drawBuffersNone);
            Shaders.useProgram(2);
            Shaders.checkGLError("beginRenderPass");
        }
    }

    public static int setFogMode(int val) {
        fogMode = val;
        return fogMode;
    }

    public static void setFogColor(float r, float g, float b) {
        fogColorR = r;
        fogColorG = g;
        fogColorB = b;
    }

    public static void setClearColor(float red, float green, float blue, float alpha) {
        cjm.a((float)red, (float)green, (float)blue, (float)alpha);
        clearColorR = red;
        clearColorG = green;
        clearColorB = blue;
    }

    public static void clearRenderBuffer() {
        if (isShadowPass) {
            Shaders.checkGLError("shadow clear pre");
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTextures.get(0), (int)0);
            GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL20.glDrawBuffers((IntBuffer)programsDrawBuffers[28]);
            Shaders.checkFramebufferStatus("shadow clear");
            GL11.glClear((int)16640);
            Shaders.checkGLError("shadow clear");
            return;
        }
        Shaders.checkGLError("clear pre");
        GL20.glDrawBuffers((int)36064);
        GL11.glClear((int)16384);
        GL20.glDrawBuffers((int)36065);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16384);
        for (int i = 2; i < usedColorBuffers; ++i) {
            GL20.glDrawBuffers((int)(36064 + i));
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16384);
        }
        Shaders.setDrawBuffers(dfbDrawBuffers);
        Shaders.checkFramebufferStatus("clear");
        Shaders.checkGLError("clear");
    }

    public static void setCamera(float partialTicks) {
        wv viewEntity = mc.aa();
        double x2 = viewEntity.P + (viewEntity.s - viewEntity.P) * (double)partialTicks;
        double y = viewEntity.Q + (viewEntity.t - viewEntity.Q) * (double)partialTicks;
        double z = viewEntity.R + (viewEntity.u - viewEntity.R) * (double)partialTicks;
        cameraPositionX = x2;
        cameraPositionY = y;
        cameraPositionZ = z;
        GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)projection.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)projectionInverse.position(0), (FloatBuffer)projection.position(0), faProjectionInverse, faProjection);
        projection.position(0);
        projectionInverse.position(0);
        GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)modelView.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)modelViewInverse.position(0), (FloatBuffer)modelView.position(0), faModelViewInverse, faModelView);
        modelView.position(0);
        modelViewInverse.position(0);
        Shaders.checkGLError("setCamera");
    }

    public static void setCameraShadow(float partialTicks) {
        float angleInterval;
        wv viewEntity = mc.aa();
        double x2 = viewEntity.P + (viewEntity.s - viewEntity.P) * (double)partialTicks;
        double y = viewEntity.Q + (viewEntity.t - viewEntity.Q) * (double)partialTicks;
        double z = viewEntity.R + (viewEntity.u - viewEntity.R) * (double)partialTicks;
        cameraPositionX = x2;
        cameraPositionY = y;
        cameraPositionZ = z;
        GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)projection.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)projectionInverse.position(0), (FloatBuffer)projection.position(0), faProjectionInverse, faProjection);
        projection.position(0);
        projectionInverse.position(0);
        GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)modelView.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)modelViewInverse.position(0), (FloatBuffer)modelView.position(0), faModelViewInverse, faModelView);
        modelView.position(0);
        modelViewInverse.position(0);
        GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        if (shadowMapIsOrtho) {
            GL11.glOrtho((double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)0.05f, (double)256.0);
        } else {
            GLU.gluPerspective((float)shadowMapFOV, (float)((float)shadowMapWidth / (float)shadowMapHeight), (float)0.05f, (float)256.0f);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        celestialAngle = Shaders.mc.f.c(partialTicks);
        sunAngle = celestialAngle < 0.75f ? celestialAngle + 0.25f : celestialAngle - 0.75f;
        float angle = celestialAngle * -360.0f;
        float f = angleInterval = shadowAngleInterval > 0.0f ? angle % shadowAngleInterval - shadowAngleInterval * 0.5f : 0.0f;
        if ((double)sunAngle <= 0.5) {
            GL11.glRotatef((float)(angle - angleInterval), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)sunPathRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            shadowAngle = sunAngle;
        } else {
            GL11.glRotatef((float)(angle + 180.0f - angleInterval), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)sunPathRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            shadowAngle = sunAngle - 0.5f;
        }
        if (shadowMapIsOrtho) {
            float trans = shadowIntervalSize;
            float trans2 = trans / 2.0f;
            GL11.glTranslatef((float)((float)x2 % trans - trans2), (float)((float)y % trans - trans2), (float)((float)z % trans - trans2));
        }
        float raSun = sunAngle * ((float)Math.PI * 2);
        float x1 = (float)Math.cos(raSun);
        float y1 = (float)Math.sin(raSun);
        float raTilt = sunPathRotation * ((float)Math.PI * 2);
        float x22 = x1;
        float y2 = y1 * (float)Math.cos(raTilt);
        float z2 = y1 * (float)Math.sin(raTilt);
        if ((double)sunAngle > 0.5) {
            x22 = -x22;
            y2 = -y2;
            z2 = -z2;
        }
        Shaders.shadowLightPositionVector[0] = x22;
        Shaders.shadowLightPositionVector[1] = y2;
        Shaders.shadowLightPositionVector[2] = z2;
        Shaders.shadowLightPositionVector[3] = 0.0f;
        GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)shadowProjection.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)shadowProjectionInverse.position(0), (FloatBuffer)shadowProjection.position(0), faShadowProjectionInverse, faShadowProjection);
        shadowProjection.position(0);
        shadowProjectionInverse.position(0);
        GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)shadowModelView.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)shadowModelViewInverse.position(0), (FloatBuffer)shadowModelView.position(0), faShadowModelViewInverse, faShadowModelView);
        shadowModelView.position(0);
        shadowModelViewInverse.position(0);
        Shaders.setProgramUniformMatrix4ARB("gbufferProjection", false, projection);
        Shaders.setProgramUniformMatrix4ARB("gbufferProjectionInverse", false, projectionInverse);
        Shaders.setProgramUniformMatrix4ARB("gbufferPreviousProjection", false, previousProjection);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelView", false, modelView);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelViewInverse", false, modelViewInverse);
        Shaders.setProgramUniformMatrix4ARB("gbufferPreviousModelView", false, previousModelView);
        Shaders.setProgramUniformMatrix4ARB("shadowProjection", false, shadowProjection);
        Shaders.setProgramUniformMatrix4ARB("shadowProjectionInverse", false, shadowProjectionInverse);
        Shaders.setProgramUniformMatrix4ARB("shadowModelView", false, shadowModelView);
        Shaders.setProgramUniformMatrix4ARB("shadowModelViewInverse", false, shadowModelViewInverse);
        Shaders.mc.t.ax = 1;
        Shaders.checkGLError("setCamera");
    }

    public static void preCelestialRotate() {
        Shaders.setUpPosition();
        GL11.glRotatef((float)(sunPathRotation * 1.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        Shaders.checkGLError("preCelestialRotate");
    }

    public static void postCelestialRotate() {
        FloatBuffer modelView = tempMatrixDirectBuffer;
        modelView.clear();
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelView.get(tempMat, 0, 16);
        SMath.multiplyMat4xVec4(sunPosition, tempMat, sunPosModelView);
        SMath.multiplyMat4xVec4(moonPosition, tempMat, moonPosModelView);
        System.arraycopy(shadowAngle == sunAngle ? sunPosition : moonPosition, 0, shadowLightPosition, 0, 3);
        Shaders.checkGLError("postCelestialRotate");
    }

    public static void setUpPosition() {
        FloatBuffer modelView = tempMatrixDirectBuffer;
        modelView.clear();
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelView.get(tempMat, 0, 16);
        SMath.multiplyMat4xVec4(upPosition, tempMat, upPosModelView);
    }

    public static void genCompositeMipmap() {
        if (hasGlGenMipmap) {
            for (int i = 0; i < usedColorBuffers; ++i) {
                if ((activeCompositeMipmapSetting & 1 << i) == 0) continue;
                GL13.glActiveTexture((int)(33984 + colorTextureTextureImageUnit[i]));
                GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
                GL30.glGenerateMipmap((int)3553);
            }
            GL13.glActiveTexture((int)33984);
        }
    }

    public static void drawComposite() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
    }

    public static void renderCompositeFinal() {
        int i;
        if (isShadowPass) {
            return;
        }
        Shaders.checkGLError("pre-renderCompositeFinal");
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        if (usedShadowDepthBuffers >= 1) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(0));
            if (usedShadowDepthBuffers >= 2) {
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(1));
            }
        }
        for (i = 0; i < usedColorBuffers; ++i) {
            GL13.glActiveTexture((int)(33984 + colorTextureTextureImageUnit[i]));
            GL11.glBindTexture((int)3553, (int)dfbColorTexturesA[i]);
        }
        GL13.glActiveTexture((int)33990);
        GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(0));
        if (usedDepthBuffers >= 2) {
            GL13.glActiveTexture((int)33995);
            GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(1));
            if (usedDepthBuffers >= 3) {
                GL13.glActiveTexture((int)33996);
                GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(2));
            }
        }
        for (i = 0; i < usedShadowColorBuffers; ++i) {
            GL13.glActiveTexture((int)(33997 + i));
            GL11.glBindTexture((int)3553, (int)sfbColorTextures.get(i));
        }
        if (noiseTextureEnabled) {
            GL13.glActiveTexture((int)(33984 + Shaders.noiseTexture.textureUnit));
            GL11.glBindTexture((int)3553, (int)noiseTexture.getID());
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        }
        GL13.glActiveTexture((int)33984);
        boolean enableAltBuffers = true;
        for (int i2 = 0; i2 < usedColorBuffers; ++i2) {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i2), (int)3553, (int)dfbColorTexturesA[8 + i2], (int)0);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)dfbDepthTextures.get(0), (int)0);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        Shaders.checkGLError("pre-composite");
        for (int cp = 0; cp < 8; ++cp) {
            if (programsID[19 + cp] == 0) continue;
            Shaders.useProgram(19 + cp);
            Shaders.checkGLError(programNames[19 + cp]);
            if (activeCompositeMipmapSetting != 0) {
                Shaders.genCompositeMipmap();
            }
            Shaders.drawComposite();
            for (int i3 = 0; i3 < usedColorBuffers; ++i3) {
                if (!programsToggleColorTextures[19 + cp][i3]) continue;
                int t0 = colorTexturesToggle[i3];
                int t1 = Shaders.colorTexturesToggle[i3] = 8 - t0;
                GL13.glActiveTexture((int)(33984 + colorTextureTextureImageUnit[i3]));
                GL11.glBindTexture((int)3553, (int)dfbColorTexturesA[t1 + i3]);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i3), (int)3553, (int)dfbColorTexturesA[t0 + i3], (int)0);
            }
            GL13.glActiveTexture((int)33984);
        }
        Shaders.checkGLError("composite");
        isRenderingDfb = false;
        mc.b().a(true);
        dax.a((int)dax.b, (int)dax.d, (int)3553, (int)Shaders.mc.b().g, (int)0);
        GL11.glViewport((int)0, (int)0, (int)Shaders.mc.d, (int)Shaders.mc.e);
        if (cji.a) {
            boolean maskR = cji.b != 0;
            GL11.glColorMask((boolean)maskR, (!maskR ? 1 : 0) != 0, (!maskR ? 1 : 0) != 0, (boolean)true);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glClearColor((float)clearColorR, (float)clearColorG, (float)clearColorB, (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDepthMask((boolean)false);
        Shaders.checkGLError("pre-final");
        Shaders.useProgram(27);
        Shaders.checkGLError("final");
        if (activeCompositeMipmapSetting != 0) {
            Shaders.genCompositeMipmap();
        }
        Shaders.drawComposite();
        Shaders.checkGLError("renderCompositeFinal");
        isCompositeRendered = true;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        Shaders.useProgram(0);
    }

    public static void endRender() {
        if (isShadowPass) {
            Shaders.checkGLError("shadow endRender");
            return;
        }
        if (!isCompositeRendered) {
            Shaders.renderCompositeFinal();
        }
        isRenderingWorld = false;
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Shaders.useProgram(0);
        bss.a();
        Shaders.checkGLError("endRender end");
    }

    public static void beginSky() {
        isRenderingSky = true;
        fogEnabled = true;
        Shaders.setDrawBuffers(dfbDrawBuffers);
        Shaders.useProgram(5);
        Shaders.pushEntity(-2, 0);
    }

    public static void setSkyColor(brw v3color) {
        skyColorR = (float)v3color.a;
        skyColorG = (float)v3color.b;
        skyColorB = (float)v3color.c;
        Shaders.setProgramUniform3f("skyColor", skyColorR, skyColorG, skyColorB);
    }

    public static void drawHorizon() {
        civ tess = ckx.a().c();
        float farDistance = Shaders.mc.t.c * 16;
        double xzq = (double)farDistance * 0.9238;
        double xzp = (double)farDistance * 0.3826;
        double xzn = -xzp;
        double xzm = -xzq;
        double top = 16.0;
        double bot = -cameraPositionY;
        tess.b();
        tess.b(xzn, bot, xzm);
        tess.b(xzn, top, xzm);
        tess.b(xzm, top, xzn);
        tess.b(xzm, bot, xzn);
        tess.b(xzm, bot, xzn);
        tess.b(xzm, top, xzn);
        tess.b(xzm, top, xzp);
        tess.b(xzm, bot, xzp);
        tess.b(xzm, bot, xzp);
        tess.b(xzm, top, xzp);
        tess.b(xzn, top, xzp);
        tess.b(xzn, bot, xzp);
        tess.b(xzn, bot, xzp);
        tess.b(xzn, top, xzp);
        tess.b(xzp, top, xzq);
        tess.b(xzp, bot, xzq);
        tess.b(xzp, bot, xzq);
        tess.b(xzp, top, xzq);
        tess.b(xzq, top, xzp);
        tess.b(xzq, bot, xzp);
        tess.b(xzq, bot, xzp);
        tess.b(xzq, top, xzp);
        tess.b(xzq, top, xzn);
        tess.b(xzq, bot, xzn);
        tess.b(xzq, bot, xzn);
        tess.b(xzq, top, xzn);
        tess.b(xzp, top, xzm);
        tess.b(xzp, bot, xzm);
        tess.b(xzp, bot, xzm);
        tess.b(xzp, top, xzm);
        tess.b(xzn, top, xzm);
        tess.b(xzn, bot, xzm);
        ckx.a().b();
    }

    public static void preSkyList() {
        GL11.glColor3f((float)fogColorR, (float)fogColorG, (float)fogColorB);
        Shaders.drawHorizon();
        GL11.glColor3f((float)skyColorR, (float)skyColorG, (float)skyColorB);
    }

    public static void endSky() {
        isRenderingSky = false;
        Shaders.setDrawBuffers(dfbDrawBuffers);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
        Shaders.popEntity();
    }

    public static void beginUpdateChunks() {
        Shaders.checkGLError("beginUpdateChunks1");
        Shaders.checkFramebufferStatus("beginUpdateChunks1");
        if (!isShadowPass) {
            Shaders.useProgram(7);
        }
        Shaders.checkGLError("beginUpdateChunks2");
        Shaders.checkFramebufferStatus("beginUpdateChunks2");
    }

    public static void endUpdateChunks() {
        Shaders.checkGLError("endUpdateChunks1");
        Shaders.checkFramebufferStatus("endUpdateChunks1");
        if (!isShadowPass) {
            Shaders.useProgram(7);
        }
        Shaders.checkGLError("endUpdateChunks2");
        Shaders.checkFramebufferStatus("endUpdateChunks2");
    }

    public static boolean shouldRenderClouds(bto gs) {
        Shaders.checkGLError("shouldRenderClouds");
        return isShadowPass ? configCloudShadow : gs.h;
    }

    public static void beginClouds() {
        fogEnabled = true;
        Shaders.pushEntity(-3, 0);
        Shaders.useProgram(6);
    }

    public static void endClouds() {
        Shaders.disableFog();
        Shaders.popEntity();
    }

    public static void beginEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(15);
            if (programsID[activeProgram] != 0) {
                boolean bl = useEntityHurtFlash = uniformEntityHurt != -1 || uniformEntityFlash != -1;
                if (uniformEntityHurt != -1) {
                    ARBShaderObjects.glUniform1iARB((int)uniformEntityHurt, (int)0);
                }
                if (uniformEntityHurt != -1) {
                    ARBShaderObjects.glUniform1iARB((int)uniformEntityFlash, (int)0);
                }
            } else {
                useEntityHurtFlash = false;
            }
            Shaders.resetDisplayListModels();
        }
    }

    public static void nextEntity() {
        if (isRenderingWorld) {
            Shaders.useProgram(15);
        }
    }

    public static void beginSpiderEyes() {
        if (isRenderingWorld && programsID[16] != programsID[0]) {
            Shaders.useProgram(16);
            cjm.d();
            cjm.a((int)516, (float)0.0f);
            cjm.b((int)770, (int)771);
        }
    }

    public static void endEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void setEntityHurtFlash(int hurt, int flash) {
        if (useEntityHurtFlash && isRenderingWorld && !isShadowPass) {
            if (uniformEntityHurt != -1) {
                ARBShaderObjects.glUniform1iARB((int)uniformEntityHurt, (int)hurt);
            }
            if (uniformEntityFlash != -1) {
                ARBShaderObjects.glUniform1iARB((int)uniformEntityFlash, (int)(flash >> 24));
            }
            Shaders.checkGLError("setEntityHurtFlash");
        }
    }

    public static void resetEntityHurtFlash() {
        Shaders.setEntityHurtFlash(0, 0);
    }

    public static void beginLivingDamage() {
        if (isRenderingWorld) {
            ShadersTex.bindTexture(defaultTexture);
            if (!isShadowPass) {
                Shaders.setDrawBuffers(drawBuffersColorAtt0);
            }
        }
    }

    public static void endLivingDamage() {
        if (isRenderingWorld && !isShadowPass) {
            Shaders.setDrawBuffers(programsDrawBuffers[15]);
        }
    }

    public static void beginBlockEntities() {
        if (isRenderingWorld) {
            Shaders.checkGLError("beginBlockEntities");
            Shaders.useProgram(13);
        }
    }

    public static void endBlockEntities() {
        if (isRenderingWorld) {
            Shaders.checkGLError("endBlockEntities");
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
            ShadersTex.bindNSTextures(Dummy.invoke_iTextureObject_getMultiTexID(defaultTexture));
        }
    }

    public static void beginLitParticles() {
        ckx.a().c().d(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(3);
    }

    public static void beginParticles() {
        ckx.a().c().d(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(2);
    }

    public static void endParticles() {
        ckx.a().c().d(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(3);
    }

    public static void readCenterDepth() {
        if (!isShadowPass && centerDepthSmoothEnabled) {
            tempDirectFloatBuffer.clear();
            GL11.glReadPixels((int)(renderWidth / 2), (int)(renderHeight / 2), (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)tempDirectFloatBuffer);
            centerDepth = tempDirectFloatBuffer.get(0);
            float fadeScalar = (float)diffSystemTime * 0.01f;
            float fadeFactor = (float)Math.exp(Math.log(0.5) * (double)fadeScalar / (double)centerDepthSmoothHalflife);
            centerDepthSmooth = centerDepthSmooth * fadeFactor + centerDepth * (1.0f - fadeFactor);
        }
    }

    public static void beginWeather() {
        if (!isShadowPass) {
            if (usedDepthBuffers >= 3) {
                GL13.glActiveTexture((int)33996);
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
                GL13.glActiveTexture((int)33984);
            }
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3008);
            Shaders.useProgram(18);
        }
    }

    public static void endWeather() {
        GL11.glDisable((int)3042);
        Shaders.useProgram(3);
    }

    public static void preWater() {
        if (usedDepthBuffers >= 2) {
            GL13.glActiveTexture((int)33995);
            Shaders.checkGLError("pre copy depth");
            GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
            Shaders.checkGLError("copy depth");
            GL13.glActiveTexture((int)33984);
        }
        ShadersTex.bindNSTextures(Dummy.invoke_iTextureObject_getMultiTexID(defaultTexture));
    }

    public static void beginWater() {
        if (isRenderingWorld) {
            if (!isShadowPass) {
                Shaders.useProgram(12);
                GL11.glEnable((int)3042);
                GL11.glDepthMask((boolean)true);
            } else {
                GL11.glDepthMask((boolean)true);
            }
        }
    }

    public static void endWater() {
        if (isRenderingWorld) {
            if (isShadowPass) {
                // empty if block
            }
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void beginProjectRedHalo() {
        if (isRenderingWorld) {
            Shaders.useProgram(1);
        }
    }

    public static void endProjectRedHalo() {
        if (isRenderingWorld) {
            Shaders.useProgram(3);
        }
    }

    public static void applyHandDepth() {
        if ((double)configHandDepthMul != 1.0) {
            GL11.glScaled((double)1.0, (double)1.0, (double)configHandDepthMul);
        }
    }

    public static void beginHand() {
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        Shaders.useProgram(17);
        Shaders.checkGLError("beginHand");
        Shaders.checkFramebufferStatus("beginHand");
    }

    public static void endHand() {
        Shaders.checkGLError("pre endHand");
        Shaders.checkFramebufferStatus("pre endHand");
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        Shaders.checkGLError("endHand");
    }

    public static void beginFPOverlay() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static void endFPOverlay() {
    }

    public static void glEnableWrapper(int cap) {
        GL11.glEnable((int)cap);
        if (cap == 3553) {
            Shaders.enableTexture2D();
        } else if (cap == 2912) {
            Shaders.enableFog();
        }
    }

    public static void glDisableWrapper(int cap) {
        GL11.glDisable((int)cap);
        if (cap == 3553) {
            Shaders.disableTexture2D();
        } else if (cap == 2912) {
            Shaders.disableFog();
        }
    }

    public static void sglEnableT2D(int cap) {
        GL11.glEnable((int)cap);
        Shaders.enableTexture2D();
    }

    public static void sglDisableT2D(int cap) {
        GL11.glDisable((int)cap);
        Shaders.disableTexture2D();
    }

    public static void sglEnableFog(int cap) {
        GL11.glEnable((int)cap);
        Shaders.enableFog();
    }

    public static void sglDisableFog(int cap) {
        GL11.glDisable((int)cap);
        Shaders.disableFog();
    }

    public static void enableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram(5);
        } else if (activeProgram == 1) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void disableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram(4);
        } else if (activeProgram == 2 || activeProgram == 3) {
            Shaders.useProgram(1);
        }
    }

    public static void enableFog() {
        fogEnabled = true;
        Shaders.setProgramUniform1i("fogMode", fogMode);
    }

    public static void disableFog() {
        fogEnabled = false;
        Shaders.setProgramUniform1i("fogMode", 0);
    }

    public static void setFog(int fogMode) {
        cjm.d((int)fogMode);
        Shaders.fogMode = fogMode;
        if (fogEnabled) {
            Shaders.setProgramUniform1i("fogMode", fogMode);
        }
    }

    public static void sglFogi(int pname, int param) {
        GL11.glFogi((int)pname, (int)param);
        if (pname == 2917) {
            fogMode = param;
            if (fogEnabled) {
                Shaders.setProgramUniform1i("fogMode", fogMode);
            }
        }
    }

    public static void enableLightmap() {
        lightmapEnabled = true;
        if (activeProgram == 2) {
            Shaders.useProgram(3);
        }
    }

    public static void disableLightmap() {
        lightmapEnabled = false;
        if (activeProgram == 3) {
            Shaders.useProgram(2);
        }
    }

    public static int getEntityData() {
        return entityData[entityDataIndex * 2];
    }

    public static int getEntityData2() {
        return entityData[entityDataIndex * 2 + 1];
    }

    public static int setEntityData1(int data1) {
        Shaders.entityData[Shaders.entityDataIndex * 2] = entityData[entityDataIndex * 2] & 0xFFFF | data1 << 16;
        return data1;
    }

    public static int setEntityData2(int data2) {
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = entityData[entityDataIndex * 2 + 1] & 0xFFFF0000 | data2 & 0xFFFF;
        return data2;
    }

    public static void pushEntity(int data0, int data1) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = data0 & 0xFFFF | data1 << 16;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void pushEntity(int data0) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = data0 & 0xFFFF;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void pushEntity(atr block) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = atr.c.b((Object)block) & 0xFFFF | block.b() << 16;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void popEntity() {
        Shaders.entityData[Shaders.entityDataIndex * 2] = 0;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
        --entityDataIndex;
    }

    public static void mcProfilerEndSection() {
        Shaders.mc.y.b();
    }

    static {
        isInitializedOnce = false;
        isShaderPackInitialized = false;
        hasGlGenMipmap = false;
        numberResetDisplayList = 0;
        needResetModels = false;
        renderDisplayWidth = 0;
        renderDisplayHeight = 0;
        renderWidth = 0;
        renderHeight = 0;
        isRenderingWorld = false;
        isRenderingSky = false;
        isCompositeRendered = false;
        isRenderingDfb = false;
        isShadowPass = false;
        activeTexUnit = 0;
        renderItemPass1DepthMask = false;
        sunPosition = new float[4];
        moonPosition = new float[4];
        shadowLightPosition = new float[4];
        upPosition = new float[4];
        shadowLightPositionVector = new float[4];
        upPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        sunPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        moonPosModelView = new float[]{0.0f, -100.0f, 0.0f, 0.0f};
        tempMat = new float[16];
        worldTime = 0L;
        lastWorldTime = 0L;
        diffWorldTime = 0L;
        celestialAngle = 0.0f;
        sunAngle = 0.0f;
        shadowAngle = 0.0f;
        moonPhase = 0;
        systemTime = 0L;
        lastSystemTime = 0L;
        diffSystemTime = 0L;
        frameCounter = 0;
        frameTimeCounter = 0.0f;
        systemTimeInt32 = 0;
        rainStrength = 0.0f;
        wetness = 0.0f;
        wetnessHalfLife = 600.0f;
        drynessHalfLife = 200.0f;
        eyeBrightnessHalflife = 10.0f;
        usewetness = false;
        isEyeInWater = 0;
        eyeBrightness = 0;
        eyeBrightnessFadeX = 0.0f;
        eyeBrightnessFadeY = 0.0f;
        eyePosY = 0.0f;
        centerDepth = 0.0f;
        centerDepthSmooth = 0.0f;
        centerDepthSmoothHalflife = 1.0f;
        centerDepthSmoothEnabled = false;
        superSamplingLevel = 1;
        updateChunksErrorRecorded = false;
        lightmapEnabled = false;
        fogEnabled = true;
        entityAttrib = 10;
        midTexCoordAttrib = 11;
        tangentAttrib = 12;
        useEntityAttrib = false;
        useMidTexCoordAttrib = false;
        useMultiTexCoord3Attrib = false;
        useTangentAttrib = false;
        progUseEntityAttrib = false;
        progUseMidTexCoordAttrib = false;
        progUseTangentAttrib = false;
        atlasSizeX = 0;
        atlasSizeY = 0;
        uniformEntityHurt = -1;
        uniformEntityFlash = -1;
        shadowPassInterval = 0;
        needResizeShadow = false;
        shadowMapWidth = 1024;
        shadowMapHeight = 1024;
        spShadowMapWidth = 1024;
        spShadowMapHeight = 1024;
        shadowMapFOV = 90.0f;
        shadowMapHalfPlane = 160.0f;
        shadowMapIsOrtho = true;
        shadowPassCounter = 0;
        shouldSkipDefaultShadow = false;
        waterShadowEnabled = false;
        usedColorBuffers = 0;
        usedDepthBuffers = 0;
        usedShadowColorBuffers = 0;
        usedShadowDepthBuffers = 0;
        usedColorAttachs = 0;
        usedDrawBuffers = 0;
        dfb = 0;
        sfb = 0;
        gbuffersFormat = new int[8];
        activeProgram = 0;
        programNames = new String[]{"", "gbuffers_basic", "gbuffers_textured", "gbuffers_textured_lit", "gbuffers_skybasic", "gbuffers_skytextured", "gbuffers_clouds", "gbuffers_terrain", "gbuffers_terrain_solid", "gbuffers_terrain_cutout_mip", "gbuffers_terrain_cutout", "gbuffers_damagedblock", "gbuffers_water", "gbuffers_block", "gbuffers_item", "gbuffers_entities", "gbuffers_spidereyes", "gbuffers_hand", "gbuffers_weather", "composite", "composite1", "composite2", "composite3", "composite4", "composite5", "composite6", "composite7", "final", "shadow", "shadow_solid", "shadow_cutout"};
        programBackups = new int[]{0, 0, 1, 2, 1, 2, 2, 3, 7, 7, 7, 7, 7, 7, 3, 3, 2, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 28};
        programsID = new int[31];
        programsRef = new int[31];
        programIDCopyDepth = 0;
        programsDrawBufSettings = new String[31];
        newDrawBufSetting = null;
        programsDrawBuffers = new IntBuffer[31];
        activeDrawBuffers = null;
        programsColorAtmSettings = new String[31];
        newColorAtmSetting = null;
        activeColorAtmSettings = null;
        programsCompositeMipmapSetting = new int[31];
        newCompositeMipmapSetting = 0;
        activeCompositeMipmapSetting = 0;
        loadedShaders = null;
        shadersConfig = null;
        defaultTexture = null;
        normalMapEnabled = false;
        shadowHardwareFilteringEnabled = new boolean[2];
        shadowMipmapEnabled = new boolean[2];
        shadowFilterNearest = new boolean[2];
        shadowColorMipmapEnabled = new boolean[8];
        shadowColorFilterNearest = new boolean[8];
        configTweakBlockDamage = true;
        configCloudShadow = true;
        configHandDepthMul = 0.125f;
        configRenderResMul = 1.0f;
        configShadowResMul = 1.0f;
        configTexMinFilB = 0;
        configTexMinFilN = 0;
        configTexMinFilS = 0;
        configTexMagFilB = 0;
        configTexMagFilN = 0;
        configTexMagFilS = 0;
        configShadowClipFrustrum = true;
        configNormalMap = true;
        configSpecularMap = true;
        configOldLighting = false;
        texMinFilDesc = new String[]{"Nearest", "Nearest-Nearest", "Nearest-Linear"};
        texMagFilDesc = new String[]{"Nearest", "Linear"};
        texMinFilValue = new int[]{9728, 9984, 9986};
        texMagFilValue = new int[]{9728, 9729};
        shaderPack = null;
        packNameNone = "(none)";
        packNameDefault = "(internal)";
        shaderpacksdirname = "shaderpacks";
        optionsfilename = "optionsshaders.txt";
        shadersdir = new File(bsu.z().v, "shaders");
        shaderpacksdir = new File(bsu.z().v, shaderpacksdirname);
        configFile = new File(bsu.z().v, optionsfilename);
        blockLightLevel05 = 0.5f;
        blockLightLevel06 = 0.6f;
        blockLightLevel08 = 0.8f;
        aoLevel = 0.8f;
        blockAoLight = 1.0f - aoLevel;
        sunPathRotation = 0.0f;
        shadowAngleInterval = 0.0f;
        fogMode = 0;
        shadowIntervalSize = 2.0f;
        terrainIconSize = 16;
        terrainTextureSize = new int[2];
        noiseTextureEnabled = false;
        noiseTextureResolution = 256;
        dfbColorTexturesA = new int[16];
        colorTexturesToggle = new int[8];
        colorTextureTextureImageUnit = new int[]{0, 1, 2, 3, 7, 8, 9, 10};
        programsToggleColorTextures = new boolean[31][8];
        bigBuffer = (ByteBuffer)BufferUtils.createByteBuffer((int)2132).limit(0);
        faProjection = new float[16];
        faProjectionInverse = new float[16];
        faModelView = new float[16];
        faModelViewInverse = new float[16];
        faShadowProjection = new float[16];
        faShadowProjectionInverse = new float[16];
        faShadowModelView = new float[16];
        faShadowModelViewInverse = new float[16];
        projection = Shaders.nextFloatBuffer(16);
        projectionInverse = Shaders.nextFloatBuffer(16);
        modelView = Shaders.nextFloatBuffer(16);
        modelViewInverse = Shaders.nextFloatBuffer(16);
        shadowProjection = Shaders.nextFloatBuffer(16);
        shadowProjectionInverse = Shaders.nextFloatBuffer(16);
        shadowModelView = Shaders.nextFloatBuffer(16);
        shadowModelViewInverse = Shaders.nextFloatBuffer(16);
        previousProjection = Shaders.nextFloatBuffer(16);
        previousModelView = Shaders.nextFloatBuffer(16);
        tempMatrixDirectBuffer = Shaders.nextFloatBuffer(16);
        tempDirectFloatBuffer = Shaders.nextFloatBuffer(16);
        dfbColorTextures = Shaders.nextIntBuffer(16);
        dfbDepthTextures = Shaders.nextIntBuffer(3);
        sfbColorTextures = Shaders.nextIntBuffer(8);
        sfbDepthTextures = Shaders.nextIntBuffer(2);
        dfbDrawBuffers = Shaders.nextIntBuffer(8);
        sfbDrawBuffers = Shaders.nextIntBuffer(8);
        drawBuffersNone = Shaders.nextIntBuffer(8);
        drawBuffersAll = Shaders.nextIntBuffer(8);
        drawBuffersClear0 = Shaders.nextIntBuffer(8);
        drawBuffersClear1 = Shaders.nextIntBuffer(8);
        drawBuffersClearColor = Shaders.nextIntBuffer(8);
        drawBuffersColorAtt0 = Shaders.nextIntBuffer(8);
        drawBuffersBuffer = Shaders.nextIntBufferArray(31, 8);
        drawBuffersNone.limit(0);
        drawBuffersColorAtt0.put(36064).position(0).limit(1);
        gbufferFormatPattern = Pattern.compile("[ \t]*const[ \t]*int[ \t]*(\\w+)Format[ \t]*=[ \t]*([RGBA81632F]*)[ \t]*;.*");
        gbufferMipmapEnabledPattern = Pattern.compile("[ \t]*const[ \t]*bool[ \t]*(\\w+)MipmapEnabled[ \t]*=[ \t]*true[ \t]*;.*");
        patternLoadEntityDataMap = Pattern.compile("\\s*([\\w:]+)\\s*=\\s*([-]?\\d+)\\s*");
        entityData = new int[32];
        entityDataIndex = 0;
    }
}

