/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadersmod.common.SMCLog;
import shadersmod.transform.Names;

public class SMCCTRender
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVrenderShadow
    extends MethodVisitor {
        public MVrenderShadow(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "shouldSkipDefaultShadow", "Z");
            Label l1 = new Label();
            this.mv.visitJumpInsn(153, l1);
            this.mv.visitInsn(177);
            this.mv.visitLabel(l1);
            SMCLog.finer("    conditionally skip default shadow");
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Names.render_renderShadow.equalsNameDesc(name, desc)) {
                return new MVrenderShadow(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

