/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadersmod.common.SMCLog;
import shadersmod.transform.Names;

public class SMCCTRenderGlobal
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVsetupTerrain
    extends MethodVisitor {
        MethodVisitor mvOut;

        public MVsetupTerrain(MethodVisitor mv) {
            super(262144);
            this.mvOut = mv;
            this.setNextState(new State0());
        }

        void setNextState(MethodVisitor next) {
            this.mv = next;
        }

        class StateEnd
        extends MVState {
            StateEnd() {
            }

            @Override
            public void visitEnd() {
                this.mv.visitEnd();
            }
        }

        class State0
        extends MVState {
            State0() {
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderGlobal_renderDispatcher.equals(owner, name, desc)) {
                    this.mv.visitInsn(87);
                    this.mv.visitFieldInsn(178, "shadersmod/client/Shaders", "isShadowPass", "Z");
                    Label label1 = new Label();
                    this.mv.visitJumpInsn(153, label1);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "mcProfilerEndSection", "()V");
                    this.mv.visitInsn(177);
                    this.mv.visitLabel(label1);
                    this.mv.visitFrame(3, 0, null, 0, null);
                    this.mv.visitVarInsn(25, 0);
                    MVsetupTerrain.this.setNextState(new StateEnd());
                }
                this.mv.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        class MVState
        extends MethodVisitor {
            public MVState() {
                super(262144, MVsetupTerrain.this.mvOut);
            }

            public void visitEnd() {
                if (((Object)((Object)this)).getClass() != StateEnd.class) {
                    SMCLog.severe("  ends in bad state %s", ((Object)((Object)this)).getClass().getSimpleName());
                }
                this.mv.visitEnd();
            }
        }
    }

    private static class MVrenderBlockLayer1
    extends MethodVisitor {
        public MVrenderBlockLayer1(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (Names.chunkRenderContainer_renderChunkLayer.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "preRenderChunkLayer", "()V");
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "postRenderChunkLayer", "()V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVpostRenderBlockDamage
    extends MethodVisitor {
        public MVpostRenderBlockDamage(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "endBlockDamage", "()V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVpreRenderBlockDamage
    extends MethodVisitor {
        public MVpreRenderBlockDamage(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitMethodInsn(184, "shadersmod/client/ShadersRender", "beginBlockDamage", "()V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVrenderSky
    extends MethodVisitor {
        int state = 0;
        int lastVar = 0;

        public MVrenderSky(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitVarInsn(int opcode, int var) {
            this.mv.visitVarInsn(opcode, var);
            this.lastVar = opcode == 25 ? var : 0;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            switch (this.state) {
                case 0: {
                    if (!Names.vec3_xCoord.equals(owner, name)) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "setSkyColor", "(" + Names.vec3_.desc + ")V");
                    this.mv.visitVarInsn(25, this.lastVar);
                }
            }
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            switch (this.state) {
                case 1: {
                    if (!Names.glStateManager_color3.equals(owner, name, desc)) break;
                    ++this.state;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    return;
                }
                case 2: {
                    if (!Names.glStateManager_color3.equals(owner, name, desc)) break;
                    ++this.state;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "preSkyList", "()V");
                    return;
                }
                case 3: {
                    if (!Names.worldClient_getRainStrength.equals(owner, name, desc)) break;
                    ++this.state;
                }
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (Names.glStateManager_enableFog.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "enableFog", "()V");
            } else if (Names.glStateManager_disableFog.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "disableFog", "()V");
            } else if (Names.glStateManager_enableTexture2D.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "enableTexture2D", "()V");
            } else if (Names.glStateManager_disableTexture2D.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "disableTexture2D", "()V");
            } else if (Names.glStateManager_rotate.equals(owner, name, desc)) {
                if (this.state == 4) {
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "preCelestialRotate", "()V");
                } else if (this.state == 5) {
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "postCelestialRotate", "()V");
                }
            }
        }
    }

    private static class MVendisTexFog
    extends MethodVisitor {
        public MVendisTexFog(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (Names.glStateManager_enableFog.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "enableFog", "()V");
            } else if (Names.glStateManager_disableFog.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "disableFog", "()V");
            } else if (Names.glStateManager_enableTexture2D.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "enableTexture2D", "()V");
            } else if (Names.glStateManager_disableTexture2D.equals(owner, name, desc)) {
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "disableTexture2D", "()V");
            }
        }
    }

    private static class MVrenderEntities
    extends MethodVisitor {
        MethodVisitor mvOut;

        public MVrenderEntities(MethodVisitor mv) {
            super(262144);
            this.mvOut = mv;
            this.mv = new State0();
        }

        void setNextState(MVState state) {
            this.mv = state;
        }

        class StateEnd
        extends MVState {
            StateEnd() {
            }

            @Override
            public void visitEnd() {
                this.mv.visitEnd();
            }
        }

        class State5
        extends MVState {
            State5() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                if (Names.entityRenderer_disableLightmap.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endBlockEntities", "()V");
                    MVrenderEntities.this.setNextState(new StateEnd());
                }
            }
        }

        class State4
        extends MVState {
            State4() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "endEntities", "()V");
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginBlockEntities", "()V");
                MVrenderEntities.this.setNextState(new State5());
            }
        }

        class State3
        extends MVState {
            State3() {
            }

            public void visitLdcInsn(Object cst) {
                String scst;
                if (cst instanceof String && (scst = (String)cst).equals("blockentities")) {
                    MVrenderEntities.this.setNextState(new State4());
                }
                this.mv.visitLdcInsn(cst);
            }
        }

        class State2
        extends MVState {
            State2() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (Names.renderManager_renderEntitySimple.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "nextEntity", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                } else if (Names.renderManager_renderWitherSkull.equals(owner, name, desc)) {
                    this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "nextEntity", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    MVrenderEntities.this.setNextState(new State3());
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }

        class State1
        extends MVState {
            State1() {
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitMethodInsn(184, "shadersmod/client/Shaders", "beginEntities", "()V");
                MVrenderEntities.this.setNextState(new State2());
            }
        }

        class State0
        extends MVState {
            State0() {
            }

            public void visitLdcInsn(Object cst) {
                String scst;
                if (cst instanceof String && (scst = (String)cst).equals("entities")) {
                    MVrenderEntities.this.setNextState(new State1());
                }
                this.mv.visitLdcInsn(cst);
            }
        }

        class MVState
        extends MethodVisitor {
            MVState() {
                super(262144, MVrenderEntities.this.mvOut);
            }

            public void visitEnd() {
                if (((Object)((Object)this)).getClass() != StateEnd.class) {
                    SMCLog.severe("  ends in bad state %s", ((Object)((Object)this)).getClass().getSimpleName());
                }
                this.mv.visitEnd();
            }
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (Names.renderGlobal_worldRenderers.name.equals(name)) {
                access = access & 0xFFFFFFF9 | 1;
            }
            return this.cv.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Names.renderGlobal_setupTerrain.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVsetupTerrain(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.renderGlobal_renderSky.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderSky(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.renderGlobal_renderBlockLayer1.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderBlockLayer1(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.renderGlobal_renderEntities.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderEntities(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.renderGlobal_preRenderBlockDamage.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVpreRenderBlockDamage(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.renderGlobal_postRenderBlockDamage.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVpostRenderBlockDamage(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.renderGlobal_drawSelectionBox.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVendisTexFog(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.renderGlobal_sortAndRender.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVendisTexFog(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

