/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import shadersmod.common.SMCLog;
import shadersmod.transform.AccessorGenerator;
import shadersmod.transform.Names;

public class SMCCTWorldRenderer
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVaddVertex
    extends MethodVisitor {
        public MVaddVertex(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, "shadersmod/client/SVertexBuilder", "beginAddVertex", "(" + Names.worldRenderer_.desc + ")V");
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, "shadersmod/client/SVertexBuilder", "endAddVertex", "(" + Names.worldRenderer_.desc + ")V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVaddData
    extends MethodVisitor {
        public MVaddData(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitMethodInsn(184, "shadersmod/client/SVertexBuilder", "beginAddVertexData", "(" + Names.worldRenderer_.desc + "[I)V");
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, "shadersmod/client/SVertexBuilder", "endAddVertexData", "(" + Names.worldRenderer_.desc + ")V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVsetVertexFormat
    extends MethodVisitor {
        public MVsetVertexFormat(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, "shadersmod/client/SVertexBuilder", "endSetVertexFormat", "(" + Names.worldRenderer_.desc + ")V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVgrow
    extends MethodVisitor {
        public MVgrow(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(21, 1);
            this.mv.visitInsn(5);
            this.mv.visitInsn(104);
            this.mv.visitVarInsn(54, 1);
        }
    }

    private static class MVinit
    extends MethodVisitor {
        public MVinit(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(21, 1);
            this.mv.visitInsn(5);
            this.mv.visitInsn(104);
            this.mv.visitVarInsn(54, 1);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, "shadersmod/client/SVertexBuilder", "initVertexBuilder", "(" + Names.worldRenderer_.desc + ")V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        boolean endFields = false;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ("sVertexBuilder".equals(name)) {
                return null;
            }
            access = access & 0xFFFFFFF9 | 1;
            return this.cv.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!this.endFields) {
                this.endFields = true;
                FieldVisitor fv = this.cv.visitField(1, "sVertexBuilder", "Lshadersmod/client/SVertexBuilder;", null, null);
                fv.visitEnd();
            }
            if (Names.equalsNameDesc("<init>", "(I)V", name, desc)) {
                return new MVinit(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.worldRenderer_growBuffer.equalsNameDesc(name, desc)) {
                return new MVgrow(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.worldRenderer_setVertexFormat.equalsNameDesc(name, desc)) {
                return new MVsetVertexFormat(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.worldRenderer_addVertexData.equalsNameDesc(name, desc)) {
                return new MVaddData(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.worldRenderer_addVertex.equalsNameDesc(name, desc)) {
                return new MVaddVertex(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            AccessorGenerator.generateFieldAccessor(this.cv, "rawIntBuffer", Names.worldRenderer_rawIntBuffer);
            AccessorGenerator.generateFieldAccessor(this.cv, "rawFloatBuffer", Names.worldRenderer_rawFloatBuffer);
            AccessorGenerator.generateFieldAccessor(this.cv, "vertexCount", Names.worldRenderer_vertexCount);
            AccessorGenerator.generateFieldAccessor(this.cv, "rawBufferIndex", Names.worldRenderer_rawBufferIndex);
            AccessorGenerator.generateFieldAccessor(this.cv, "drawMode", Names.worldRenderer_drawMode);
            super.visitEnd();
        }
    }
}

