/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class NaturalTextures {
    private static NaturalProperties[] propertiesByIndex = new NaturalProperties[0];

    public static void update() {
        propertiesByIndex = new NaturalProperties[0];
    }

    public static NaturalProperties getNaturalProperties(bmj icon) {
        if (!(icon instanceof bmj)) {
            return null;
        }
        bmj ts = icon;
        int tileNum = ts.getIndexInMap();
        if (tileNum < 0 || tileNum >= propertiesByIndex.length) {
            return null;
        }
        NaturalProperties props = propertiesByIndex[tileNum];
        return props;
    }

    private static NaturalProperties[] makeDefaultProperties() {
        Config.dbg("NaturalTextures: Creating default configuration.");
        ArrayList propsList = new ArrayList();
        NaturalTextures.setIconProperties(propsList, "grass_top", "4F");
        NaturalTextures.setIconProperties(propsList, "stone", "2F");
        NaturalTextures.setIconProperties(propsList, "dirt", "4F");
        NaturalTextures.setIconProperties(propsList, "grass_side", "F");
        NaturalTextures.setIconProperties(propsList, "grass_side_overlay", "F");
        NaturalTextures.setIconProperties(propsList, "stone_slab_top", "F");
        NaturalTextures.setIconProperties(propsList, "bedrock", "2F");
        NaturalTextures.setIconProperties(propsList, "sand", "4F");
        NaturalTextures.setIconProperties(propsList, "gravel", "2");
        NaturalTextures.setIconProperties(propsList, "log_oak", "2F");
        NaturalTextures.setIconProperties(propsList, "log_oak_top", "4F");
        NaturalTextures.setIconProperties(propsList, "gold_ore", "2F");
        NaturalTextures.setIconProperties(propsList, "iron_ore", "2F");
        NaturalTextures.setIconProperties(propsList, "coal_ore", "2F");
        NaturalTextures.setIconProperties(propsList, "diamond_ore", "2F");
        NaturalTextures.setIconProperties(propsList, "redstone_ore", "2F");
        NaturalTextures.setIconProperties(propsList, "lapis_ore", "2F");
        NaturalTextures.setIconProperties(propsList, "obsidian", "4F");
        NaturalTextures.setIconProperties(propsList, "leaves_oak", "2F");
        NaturalTextures.setIconProperties(propsList, "leaves_jungle", "2");
        NaturalTextures.setIconProperties(propsList, "snow", "4F");
        NaturalTextures.setIconProperties(propsList, "grass_side_snowed", "F");
        NaturalTextures.setIconProperties(propsList, "cactus_side", "2F");
        NaturalTextures.setIconProperties(propsList, "clay", "4F");
        NaturalTextures.setIconProperties(propsList, "mycelium_side", "F");
        NaturalTextures.setIconProperties(propsList, "mycelium_top", "4F");
        NaturalTextures.setIconProperties(propsList, "farmland_wet", "2F");
        NaturalTextures.setIconProperties(propsList, "farmland_dry", "2F");
        NaturalTextures.setIconProperties(propsList, "netherrack", "4F");
        NaturalTextures.setIconProperties(propsList, "soul_sand", "4F");
        NaturalTextures.setIconProperties(propsList, "glowstone", "4");
        NaturalTextures.setIconProperties(propsList, "log_spruce", "2F");
        NaturalTextures.setIconProperties(propsList, "log_birch", "F");
        NaturalTextures.setIconProperties(propsList, "leaves_spruce", "2F");
        NaturalTextures.setIconProperties(propsList, "log_jungle", "2F");
        NaturalTextures.setIconProperties(propsList, "end_stone", "4");
        NaturalTextures.setIconProperties(propsList, "sandstone_top", "4");
        NaturalTextures.setIconProperties(propsList, "sandstone_bottom", "4F");
        NaturalTextures.setIconProperties(propsList, "redstone_lamp_on", "4F");
        NaturalProperties[] terrainProps = propsList.toArray(new NaturalProperties[propsList.size()]);
        return terrainProps;
    }

    private static void setIconProperties(List propsList, String iconName, String propStr) {
        bmi terrainMap = TextureUtils.getTextureMapBlocks();
        bmj icon = terrainMap.getSpriteSafe("minecraft:blocks/" + iconName);
        if (icon == null) {
            Config.warn("*** NaturalProperties: Icon not found: " + iconName + " ***");
            return;
        }
        if (!(icon instanceof bmj)) {
            Config.warn("*** NaturalProperties: Icon is not IconStitched: " + iconName + ": " + icon.getClass().getName() + " ***");
            return;
        }
        bmj ts = icon;
        int index = ts.getIndexInMap();
        if (index < 0) {
            Config.warn("*** NaturalProperties: Invalid index for icon: " + iconName + ": " + index + " ***");
            return;
        }
        if (!Config.isFromDefaultResourcePack(new jz("textures/blocks/" + iconName + ".png"))) {
            return;
        }
        while (index >= propsList.size()) {
            propsList.add(null);
        }
        NaturalProperties props = new NaturalProperties(propStr);
        propsList.set(index, props);
        Config.dbg("NaturalTextures: " + iconName + " = " + propStr);
    }
}

